/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.http.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.http.client.AcceptedType;
import zeenea.connector.commons.http.client.HttpJsonMapper;
import zeenea.connector.commons.http.client.RestOptions;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.commons.util.ObjectUtil;
import zeenea.connector.commons.util.Pair;

public final class RestRequest<T> {
    @Nullable
    private final TracingContext ctx;
    @Nullable
    private final URI base;
    @NotNull
    private final List<String> path;
    @NotNull
    private final List<Pair<String, String>> queryParams;
    @NotNull
    private final List<Pair<String, String>> headers;
    @NotNull
    private final JavaType responseType;
    @NotNull
    private final Set<RestOptions> options;
    @NotNull
    private final List<AcceptedType> accept;
    @Nullable
    private final Long timeout;
    @Nullable
    private final Long keepAlive;

    public RestRequest(@NotNull Builder<T> builder) {
        this.ctx = builder.ctx;
        this.base = builder.base;
        this.path = Objects.requireNonNull(builder.path);
        this.queryParams = (List)ObjectUtil.defaultTo(builder.queryParams, Collections.emptyList());
        this.headers = (List)ObjectUtil.defaultTo(builder.headers, Collections.emptyList());
        this.responseType = Objects.requireNonNull(builder.responseType);
        this.options = (Set)ObjectUtil.defaultTo(builder.options, () -> EnumSet.noneOf(RestOptions.class));
        this.accept = (List)ObjectUtil.defaultTo(builder.accept, Collections.emptyList());
        this.timeout = builder.timeout;
        this.keepAlive = builder.keepAlive;
    }

    public static <T> Builder<T> builder(Class<T> responseType) {
        return new Builder(HttpJsonMapper.of().constructType(responseType));
    }

    public static <T> Builder<T> builder(TypeReference<T> responseType) {
        return new Builder(HttpJsonMapper.of().constructType(responseType));
    }

    @Nullable
    public TracingContext ctx() {
        return this.ctx;
    }

    @Nullable
    public URI base() {
        return this.base;
    }

    @NotNull
    public List<String> path() {
        return this.path;
    }

    @NotNull
    public List<Pair<String, String>> queryParams() {
        return this.queryParams;
    }

    @NotNull
    public List<Pair<String, String>> headers() {
        return this.headers;
    }

    @NotNull
    public JavaType responseType() {
        return this.responseType;
    }

    @NotNull
    public Set<RestOptions> options() {
        return this.options;
    }

    public List<AcceptedType> accept() {
        return this.accept;
    }

    @Nullable
    public Long timeout() {
        return this.timeout;
    }

    @Nullable
    public Long keepAlive() {
        return this.keepAlive;
    }

    public static final class Builder<T> {
        private TracingContext ctx;
        private URI base;
        private List<String> path = List.of();
        private List<Pair<String, String>> queryParams;
        private List<Pair<String, String>> headers;
        private final JavaType responseType;
        private final Set<RestOptions> options = EnumSet.noneOf(RestOptions.class);
        private List<AcceptedType> accept;
        private Long timeout;
        private Long keepAlive;

        private Builder(JavaType responseType) {
            this.responseType = responseType;
        }

        public Builder<T> ctx(TracingContext ctx) {
            this.ctx = ctx;
            return this;
        }

        public Builder<T> base(URI base) {
            this.base = base;
            return this;
        }

        public Builder<T> path(String path) {
            if (path != null && !path.isEmpty()) {
                if (path.charAt(0) == '/') {
                    path = path.substring(1);
                }
                this.path = List.of(path.split("/"));
            } else {
                this.path = List.of();
            }
            return this;
        }

        public Builder<T> path(List<String> path) {
            this.path = path;
            return this;
        }

        public Builder<T> queryParams(List<Pair<String, String>> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public Builder<T> headers(List<Pair<String, String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder<T> accept(List<AcceptedType> accept) {
            this.accept = accept;
            return this;
        }

        public Builder<T> accept(AcceptedType ... accept) {
            this.accept = Arrays.asList(accept);
            return this;
        }

        public Builder<T> options(RestOptions ... options) {
            this.options.clear();
            this.options.addAll(Arrays.asList(options));
            return this;
        }

        public Builder<T> timeout(Long value) {
            this.timeout = value;
            return this;
        }

        public Builder<T> keepAlive(Long value) {
            this.keepAlive = value;
            return this;
        }

        public RestRequest<T> build() {
            return new RestRequest(this);
        }
    }
}

