/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.db;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public enum DbEngine {
    BIGQUERY(NameNorm.SENSITIVE, 443, Feature.OPTIONAL_MULTI_DB, Feature.FIXED_PORT),
    DATABRICKS(NameNorm.LOWERCASE_ONLY, 443, Feature.MULTI_DB),
    DB2(NameNorm.UPPERCASE, 50000),
    GREENPLUM(NameNorm.LOWERCASE, 5432, "public", Feature.DEFAULT_SCHEMA),
    HIVE(NameNorm.SENSITIVE, 10000, Feature.NO_DB),
    MARIADB(NameNorm.LOWERCASE, 3306, Feature.NO_DB),
    MYSQL(NameNorm.LOWERCASE, 3306, Feature.MULTI_DB, Feature.NO_SCHEMA),
    NETEZZA(NameNorm.UPPERCASE, 5480),
    ORACLE(NameNorm.UPPERCASE, 1521, Feature.NO_DB),
    POSTGRESQL(NameNorm.LOWERCASE, 5432, "public", Feature.DEFAULT_SCHEMA),
    REDSHIFT(NameNorm.LOWERCASE, 5439, "public", Feature.DEFAULT_SCHEMA),
    SNOWFLAKE(NameNorm.UPPERCASE, 443, "PUBLIC", Feature.OPTIONAL_MULTI_DB, Feature.FIXED_PORT, Feature.DEFAULT_SCHEMA),
    SQLSERVER(NameNorm.INSENSITIVE, 1433, "dbo", Feature.OPTIONAL_MULTI_DB, Feature.DEFAULT_SCHEMA),
    TERADATA(NameNorm.INSENSITIVE, 6666),
    TDV(NameNorm.INSENSITIVE, 9400, List.of("services", "databases"), Feature.PREFIXED, Feature.MULTI_DB, Feature.OPTIONAL_DB, Feature.OPTIONAL_SCHEMA, Feature.FIXED_PORT),
    DENODO(NameNorm.LOWERCASE, 9996, Feature.MULTI_DB, Feature.NO_SCHEMA),
    ATHENA(NameNorm.INSENSITIVE, 443, Feature.PREFIXED, Feature.MULTI_DB, Feature.NO_HOST),
    UNKNOWN(NameNorm.SENSITIVE, 0, Feature.MULTI_DB);

    private static final String SNOWFLAKE_DOMAIN = ".snowflakecomputing.com";
    private static final String BIGQUERY_DOMAIN = "bigquery.googleapis.com";
    private final NameNorm norm;
    private final Set<Feature> features;
    private final List<String> defaultPrefix;
    private final int defaultPort;
    private final String defaultSchema;

    private DbEngine(NameNorm norm, int defaultPort) {
        this(norm, defaultPort, null, List.of(), new Feature[0]);
    }

    private DbEngine(NameNorm norm, int defaultPort, Feature ... feature) {
        this(norm, defaultPort, null, List.of(), feature);
    }

    private DbEngine(NameNorm norm, int defaultPort, String defaultSchema, Feature ... feature) {
        this(norm, defaultPort, defaultSchema, List.of(), feature);
    }

    private DbEngine(NameNorm norm, int defaultPort, List<String> defaultPrefix, Feature ... feature) {
        this(norm, defaultPort, null, defaultPrefix, feature);
    }

    private DbEngine(NameNorm norm, int defaultPort, String defaultSchema, List<String> defaultPrefix, Feature ... feature) {
        this.norm = norm;
        this.features = EnumSet.noneOf(Feature.class);
        Collections.addAll(this.features, feature);
        this.defaultPrefix = List.copyOf(defaultPrefix);
        this.defaultPort = defaultPort;
        this.defaultSchema = defaultSchema;
    }

    public NameNorm norm() {
        return this.norm;
    }

    public boolean has(Feature feature) {
        return this.features.contains((Object)feature);
    }

    public int defaultPort() {
        return this.defaultPort;
    }

    public List<String> defaultPrefix() {
        return this.defaultPrefix;
    }

    public String defaultSchema() {
        return this.defaultSchema;
    }

    @Nullable
    public String normalizeHost(@Nullable String host) {
        if (this == BIGQUERY) {
            return BIGQUERY_DOMAIN;
        }
        if (host == null || ((String)host).isBlank()) {
            return null;
        }
        host = ((String)host).toLowerCase(Locale.ROOT);
        if (this == SNOWFLAKE && !((String)host).endsWith(SNOWFLAKE_DOMAIN)) {
            host = (String)host + SNOWFLAKE_DOMAIN;
        }
        return host;
    }

    @Nullable
    public String unescape(@Nullable String name) throws IllegalArgumentException {
        if (name == null || name.isEmpty()) {
            return null;
        }
        char quote = name.charAt(0);
        switch (quote) {
            case '\"': {
                if (name.length() == 1 || name.charAt(name.length() - 1) != '\"') {
                    throw new IllegalArgumentException("sql_parser_invalid_double_quote_identifier: " + name);
                }
                return this.normalizeQuoted(name.substring(1, name.length() - 1).replace("\"\"", "\""));
            }
            case '`': {
                if (name.length() == 1 || name.charAt(name.length() - 1) != '`') {
                    throw new IllegalArgumentException("sql_parser_invalid_back_quote_identifier: " + name);
                }
                return this.normalizeQuoted(name.substring(1, name.length() - 1));
            }
            case '[': {
                if (name.length() == 1 || name.charAt(name.length() - 1) != ']') {
                    throw new IllegalArgumentException("sql_parser_invalid_bracket_quote_identifier: " + name);
                }
                return this.normalizeQuoted(name.substring(1, name.length() - 1));
            }
        }
        return this.normalizeUnquoted(name);
    }

    private String normalizeQuoted(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return null;
        }
        if (this.norm == NameNorm.LOWERCASE_ONLY) {
            return identifier.toLowerCase(Locale.ROOT);
        }
        return identifier;
    }

    private String normalizeUnquoted(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return null;
        }
        switch (this.norm) {
            case LOWERCASE: 
            case LOWERCASE_ONLY: {
                return identifier.toLowerCase(Locale.ROOT);
            }
            case UPPERCASE: {
                return identifier.toUpperCase(Locale.ROOT);
            }
        }
        return identifier;
    }

    public static enum Feature {
        PREFIXED,
        MULTI_DB,
        OPTIONAL_MULTI_DB,
        OPTIONAL_DB,
        NO_HOST,
        NO_DB,
        NO_SCHEMA,
        FIXED_PORT,
        DEFAULT_SCHEMA,
        OPTIONAL_SCHEMA;

    }

    public static enum NameNorm {
        UPPERCASE,
        LOWERCASE,
        LOWERCASE_ONLY,
        INSENSITIVE,
        SENSITIVE;

    }
}

