/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import zeenea.connector.commons.api.KeyStoreConfig;

@ParametersAreNonnullByDefault
@Generated(from="KeyStoreConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableKeyStoreConfig
extends KeyStoreConfig {
    private final Path storePath;
    private final String storeType;
    private final String storePassword;
    private final String keyPassword;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableKeyStoreConfig(Builder builder) {
        this.storePath = builder.storePath;
        this.storePassword = builder.storePassword;
        if (builder.storeType != null) {
            this.initShim.storeType(builder.storeType);
        }
        if (builder.keyPassword != null) {
            this.initShim.keyPassword(builder.keyPassword);
        }
        this.storeType = this.initShim.getStoreType();
        this.keyPassword = this.initShim.getKeyPassword();
        this.initShim = null;
    }

    private ImmutableKeyStoreConfig(Path storePath, String storeType, String storePassword, String keyPassword) {
        this.storePath = storePath;
        this.storeType = storeType;
        this.storePassword = storePassword;
        this.keyPassword = keyPassword;
        this.initShim = null;
    }

    @Override
    public Path getStorePath() {
        return this.storePath;
    }

    @Override
    public String getStoreType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getStoreType() : this.storeType;
    }

    @Override
    public String getStorePassword() {
        return this.storePassword;
    }

    @Override
    public String getKeyPassword() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getKeyPassword() : this.keyPassword;
    }

    public final ImmutableKeyStoreConfig withStorePath(Path value) {
        if (this.storePath == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "storePath");
        return ImmutableKeyStoreConfig.validate(new ImmutableKeyStoreConfig(newValue, this.storeType, this.storePassword, this.keyPassword));
    }

    public final ImmutableKeyStoreConfig withStoreType(String value) {
        String newValue = Objects.requireNonNull(value, "storeType");
        if (this.storeType.equals(newValue)) {
            return this;
        }
        return ImmutableKeyStoreConfig.validate(new ImmutableKeyStoreConfig(this.storePath, newValue, this.storePassword, this.keyPassword));
    }

    public final ImmutableKeyStoreConfig withStorePassword(String value) {
        String newValue = Objects.requireNonNull(value, "storePassword");
        if (this.storePassword.equals(newValue)) {
            return this;
        }
        return ImmutableKeyStoreConfig.validate(new ImmutableKeyStoreConfig(this.storePath, this.storeType, newValue, this.keyPassword));
    }

    public final ImmutableKeyStoreConfig withKeyPassword(String value) {
        String newValue = Objects.requireNonNull(value, "keyPassword");
        if (this.keyPassword.equals(newValue)) {
            return this;
        }
        return ImmutableKeyStoreConfig.validate(new ImmutableKeyStoreConfig(this.storePath, this.storeType, this.storePassword, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyStoreConfig && this.equalTo(0, (ImmutableKeyStoreConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyStoreConfig another) {
        return this.storePath.equals(another.storePath) && this.storeType.equals(another.storeType) && this.storePassword.equals(another.storePassword) && this.keyPassword.equals(another.keyPassword);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.storePath.hashCode();
        h += (h << 5) + this.storeType.hashCode();
        h += (h << 5) + this.storePassword.hashCode();
        h += (h << 5) + this.keyPassword.hashCode();
        return h;
    }

    public String toString() {
        return "KeyStoreConfig{storePath=" + String.valueOf(this.storePath) + ", storeType=" + this.storeType + ", storePassword=*******, keyPassword=*******}";
    }

    private static ImmutableKeyStoreConfig validate(ImmutableKeyStoreConfig instance) {
        instance.check();
        return instance;
    }

    public static ImmutableKeyStoreConfig copyOf(KeyStoreConfig instance) {
        if (instance instanceof ImmutableKeyStoreConfig) {
            return (ImmutableKeyStoreConfig)instance;
        }
        return ImmutableKeyStoreConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KeyStoreConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STORE_PATH = 1L;
        private static final long INIT_BIT_STORE_PASSWORD = 2L;
        private long initBits = 3L;
        @Nullable
        private Path storePath;
        @Nullable
        private String storeType;
        @Nullable
        private String storePassword;
        @Nullable
        private String keyPassword;

        private Builder() {
        }

        public final Builder from(KeyStoreConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.storePath(instance.getStorePath());
            this.storeType(instance.getStoreType());
            this.storePassword(instance.getStorePassword());
            this.keyPassword(instance.getKeyPassword());
            return this;
        }

        public final Builder storePath(Path storePath) {
            this.storePath = Objects.requireNonNull(storePath, "storePath");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder storeType(String storeType) {
            this.storeType = Objects.requireNonNull(storeType, "storeType");
            return this;
        }

        public final Builder storePassword(String storePassword) {
            this.storePassword = Objects.requireNonNull(storePassword, "storePassword");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder keyPassword(String keyPassword) {
            this.keyPassword = Objects.requireNonNull(keyPassword, "keyPassword");
            return this;
        }

        public ImmutableKeyStoreConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableKeyStoreConfig.validate(new ImmutableKeyStoreConfig(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("storePath");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("storePassword");
            }
            return "Cannot build KeyStoreConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Generated(from="KeyStoreConfig", generator="Immutables")
    private final class InitShim {
        private byte storeTypeBuildStage = 0;
        private String storeType;
        private byte keyPasswordBuildStage = 0;
        private String keyPassword;

        private InitShim() {
        }

        String getStoreType() {
            if (this.storeTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storeTypeBuildStage == 0) {
                this.storeTypeBuildStage = (byte)-1;
                this.storeType = Objects.requireNonNull(ImmutableKeyStoreConfig.super.getStoreType(), "storeType");
                this.storeTypeBuildStage = 1;
            }
            return this.storeType;
        }

        void storeType(String storeType) {
            this.storeType = storeType;
            this.storeTypeBuildStage = 1;
        }

        String getKeyPassword() {
            if (this.keyPasswordBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keyPasswordBuildStage == 0) {
                this.keyPasswordBuildStage = (byte)-1;
                this.keyPassword = Objects.requireNonNull(ImmutableKeyStoreConfig.super.getKeyPassword(), "keyPassword");
                this.keyPasswordBuildStage = 1;
            }
            return this.keyPassword;
        }

        void keyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
            this.keyPasswordBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.storeTypeBuildStage == -1) {
                attributes.add("storeType");
            }
            if (this.keyPasswordBuildStage == -1) {
                attributes.add("keyPassword");
            }
            return "Cannot build KeyStoreConfig, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }
}

