/*
 * Decompiled with CFR 0.152.
 */
package com.benasher44.uuid;

import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u001a\r\u0010\u000b\u001a\u00060\u0002j\u0002`\fH\u0086\b\u001a\u0012\u0010\r\u001a\u00060\u0002j\u0002`\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00060\u0002j\u0002`\f2\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u001c\u0010\u0011\u001a\u00020\u0012*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0016\u0010\u0005\u001a\u00020\u0006*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0016\u0010\t\u001a\u00020\u0006*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b*\n\u0010\u0015\"\u00020\u00022\u00020\u0002\u00a8\u0006\u0016"}, d2={"bytes", "", "Ljava/util/UUID;", "getBytes", "(Ljava/util/UUID;)[B", "variant", "", "getVariant", "(Ljava/util/UUID;)I", "version", "getVersion", "uuid4", "Lcom/benasher44/uuid/Uuid;", "uuidFrom", "string", "", "uuidOf", "segmentToLong", "", "start", "end", "Uuid", "uuid"})
public final class UuidKt {
    @NotNull
    public static final UUID uuidOf(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        boolean bl = bytes.length == 16;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Invalid UUID bytes. Expected 16 bytes; found ", (Object)bytes.length);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        bl2 = false;
        bl3 = false;
        ByteBuffer it = byteBuffer;
        boolean bl5 = false;
        return new UUID(it.getLong(), it.getLong());
    }

    @NotNull
    public static final UUID uuidFrom(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (string.length() != 36) {
            throw new IllegalArgumentException("Invalid UUID string, expected exactly 36 characters but got " + string.length() + ": " + string);
        }
        return new UUID(UuidKt.segmentToLong(string, 0, 19), UuidKt.segmentToLong(string, 19, 36));
    }

    private static final long segmentToLong(String $this$segmentToLong, int start, int end) {
        long result = 0L;
        int i = 0;
        i = start;
        do {
            char c;
            if ($this$segmentToLong.charAt(i) == '-') {
                c = i == 8 || i == 13 || i == 18 || i == 23 ? (char)'\u0001' : '\u0000';
                boolean bl = false;
                boolean bl2 = false;
                if (c != '\u0000') continue;
                boolean bl3 = false;
                String string = "Invalid UUID string, encountered dash at index " + i + " but it can occur only at 8, 13, 18, or 23: " + $this$segmentToLong;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            result *= (long)16;
            c = $this$segmentToLong.charAt(i);
            if (c == '0') continue;
            if (c == '1') {
                ++result;
                continue;
            }
            if (c == '2') {
                result += 2L;
                continue;
            }
            if (c == '3') {
                result += 3L;
                continue;
            }
            if (c == '4') {
                result += 4L;
                continue;
            }
            if (c == '5') {
                result += 5L;
                continue;
            }
            if (c == '6') {
                result += 6L;
                continue;
            }
            if (c == '7') {
                result += 7L;
                continue;
            }
            if (c == '8') {
                result += 8L;
                continue;
            }
            if (c == '9') {
                result += 9L;
                continue;
            }
            if (c == 'a' ? true : c == 'A') {
                result += 10L;
                continue;
            }
            if (c == 'b' ? true : c == 'B') {
                result += 11L;
                continue;
            }
            if (c == 'c' ? true : c == 'C') {
                result += 12L;
                continue;
            }
            if (c == 'd' ? true : c == 'D') {
                result += 13L;
                continue;
            }
            if (c == 'e' ? true : c == 'E') {
                result += 14L;
                continue;
            }
            if (c == 'f' ? true : c == 'F') {
                result += 15L;
                continue;
            }
            throw new IllegalArgumentException("Invalid UUID string, encountered non-hexadecimal digit `" + $this$segmentToLong.charAt(i) + "` at index " + i + " in: " + $this$segmentToLong);
        } while (++i < end);
        return result;
    }

    @NotNull
    public static final UUID uuid4() {
        boolean $i$f$uuid4 = false;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
        return uUID;
    }

    @NotNull
    public static final byte[] getBytes(@NotNull UUID $this$bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$bytes, (String)"<this>");
        byte[] byArray = ByteBuffer.allocate(16).putLong($this$bytes.getMostSignificantBits()).putLong($this$bytes.getLeastSignificantBits()).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"allocate(16).putLong(mos\u2026tSignificantBits).array()");
        return byArray;
    }

    public static final int getVersion(@NotNull UUID $this$version) {
        Intrinsics.checkNotNullParameter((Object)$this$version, (String)"<this>");
        boolean $i$f$getVersion = false;
        return $this$version.version();
    }

    public static final int getVariant(@NotNull UUID $this$variant) {
        Intrinsics.checkNotNullParameter((Object)$this$variant, (String)"<this>");
        boolean $i$f$getVariant = false;
        return $this$variant.variant();
    }

    public static /* synthetic */ void Uuid$annotations() {
    }
}

