/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.log;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.common.ItemIdentifier;
import zeenea.connector.source.ZeePath;

public class TracingContext {
    private static final ThreadLocal<TracingContext> current = new ThreadLocal();
    private static final AtomicInteger nextValue = new AtomicInteger();
    @NotNull
    private final String text;

    private TracingContext(@NotNull String text) {
        this.text = text;
    }

    @NotNull
    public static TracingContext newConnector(String connectionCode) {
        return new TracingContext(connectionCode + "/new_connector#" + TracingContext.nextNumber());
    }

    @NotNull
    public static TracingContext inventory(@NotNull String connectionCode) {
        return new TracingContext(connectionCode + "/inventory#" + TracingContext.nextNumber());
    }

    @NotNull
    public static TracingContext extractItem(@NotNull String connectionCode, @NotNull ZeePath path) {
        return new TracingContext(connectionCode + "/extract_item#" + TracingContext.nextNumber() + "(path='" + path.escapedValue() + "')");
    }

    @NotNull
    public static TracingContext extractItem(@NotNull String connectionCode, @NotNull ItemIdentifier itemIdentifier) {
        return new TracingContext(connectionCode + "/extract_item#" + TracingContext.nextNumber() + "(itemIdentifier='" + String.valueOf(itemIdentifier) + "')");
    }

    @NotNull
    public static TracingContext synchronize(@NotNull String connectionCode) {
        return new TracingContext(connectionCode + "/synchonize#" + TracingContext.nextNumber());
    }

    @NotNull
    public static TracingContext dataSampling(@NotNull String connectionCode, @NotNull ZeePath path) {
        return new TracingContext(connectionCode + "/data_sample#" + TracingContext.nextNumber() + "(path='" + path.escapedValue() + "')");
    }

    @NotNull
    public static TracingContext fingerprint(@NotNull String connectionCode, @NotNull ZeePath path, @NotNull List<String> technicalNames) {
        return new TracingContext(connectionCode + "/fingerprint#" + TracingContext.nextNumber() + "(path='" + path.escapedValue() + "', technicalNames='" + String.valueOf(technicalNames) + "')");
    }

    @NotNull
    public static TracingContext estimateCount(@NotNull String connectionCode, @NotNull ZeePath path) {
        return new TracingContext(connectionCode + "/estimate_count#" + TracingContext.nextNumber() + "(path='" + path.escapedValue() + "')");
    }

    @NotNull
    public static TracingContext checkFieldAndType(@NotNull String connectionCode, @NotNull ZeePath path, @NotNull List<String> technicalNames) {
        return new TracingContext(connectionCode + "/check_field_and_type#" + TracingContext.nextNumber() + "(path='" + path.escapedValue() + "', technicalNames='" + String.valueOf(technicalNames) + "')");
    }

    @NotNull
    public static TracingContext test() {
        return new TracingContext("test/test#" + TracingContext.nextNumber());
    }

    @NotNull
    private static String nextNumber() {
        return Integer.toUnsignedString(nextValue.getAndIncrement());
    }

    @Nullable
    public static TracingContext current() {
        return current.get();
    }

    @NotNull
    public static TracingContext get() {
        TracingContext tracingContext = current.get();
        if (tracingContext == null) {
            throw new NoSuchElementException("No tracing context defined");
        }
        return tracingContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T with(Supplier<T> action) {
        TracingContext old = current.get();
        current.set(this);
        try {
            T t = action.get();
            return t;
        }
        finally {
            if (old != null) {
                current.set(old);
            } else {
                current.remove();
            }
        }
    }

    public String toString() {
        return this.text;
    }
}

