/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.http.client;

import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import zeenea.connector.commons.http.client.EntityMapper;

public enum HttpPlainTextMapper implements EntityMapper
{
    INSTANCE;


    public static HttpPlainTextMapper of() {
        return INSTANCE;
    }

    @Override
    public <T> T readEntity(HttpEntity entity, JavaType type) throws IOException {
        if (type.getRawClass() != String.class) {
            throw new IllegalArgumentException("Type must be String for plain text mapper");
        }
        return (T)new String(entity.getContent().readAllBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public <T> HttpEntity writeAsEntity(T content) {
        if (content instanceof String) {
            byte[] bytes = ((String)content).getBytes(StandardCharsets.UTF_8);
            return new ByteArrayEntity(bytes, ContentType.TEXT_PLAIN);
        }
        throw new IllegalArgumentException("Content must be a String for plain text mapper");
    }

    @Override
    public <T> String prettyPrint(T o) {
        if (!(o instanceof String)) {
            throw new IllegalArgumentException("Input must be a String for plain text mapper");
        }
        return (String)o;
    }
}

