/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.internal;

import com.apollographql.apollo3.api.Adapters;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.Error;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.json.-JsonReaders;
import com.apollographql.apollo3.api.json.JsonReader;
import com.apollographql.apollo3.api.json.MapJsonReader;
import com.apollographql.apollo3.exception.JsonDataException;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0010J\f\u0010\u0012\u001a\u00020\u000e*\u00020\bH\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\bH\u0002J\u0014\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0016*\u00020\bH\u0002J\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016*\u00020\bH\u0002J\u0014\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0016*\u00020\bH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/apollographql/apollo3/api/internal/ResponseParser;", "", "()V", "parse", "Lcom/apollographql/apollo3/api/ApolloResponse;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "jsonReader", "Lcom/apollographql/apollo3/api/json/JsonReader;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "parseError", "Lcom/apollographql/apollo3/api/Error;", "payload", "", "", "readError", "readErrorLocation", "Lcom/apollographql/apollo3/api/Error$Location;", "readErrorLocations", "", "readErrors", "readPath", "apollo-api"})
@SourceDebugExtension(value={"SMAP\nResponseParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseParser.kt\ncom/apollographql/apollo3/api/internal/ResponseParser\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 uuid.kt\ncom/benasher44/uuid/UuidKt\n*L\n1#1,151:1\n66#2:152\n52#2,4:153\n60#2,10:158\n56#2,3:168\n71#2,3:171\n96#3:157\n*S KotlinDebug\n*F\n+ 1 ResponseParser.kt\ncom/apollographql/apollo3/api/internal/ResponseParser\n*L\n25#1:152\n25#1:153,4\n25#1:158,10\n25#1:168,3\n25#1:171,3\n47#1:157\n*E\n"})
public final class ResponseParser {
    @NotNull
    public static final ResponseParser INSTANCE = new ResponseParser();

    private ResponseParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final <D extends Operation.Data> ApolloResponse<D> parse(@NotNull JsonReader jsonReader, @NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters) {
        ApolloResponse<Operation.Data> apolloResponse;
        Throwable thrown$iv;
        block24: {
            Intrinsics.checkNotNullParameter((Object)jsonReader, (String)"jsonReader");
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            Closeable $this$use$iv = jsonReader;
            boolean $i$f$use = false;
            thrown$iv = null;
            try {
                JsonReader jsonReader2 = (JsonReader)$this$use$iv;
                boolean bl = false;
                jsonReader2.beginObject();
                Operation.Data data = null;
                List<Error> errors = null;
                Map extensions = null;
                block21: while (jsonReader2.hasNext()) {
                    switch (jsonReader2.nextName()) {
                        case "data": {
                            data = (Operation.Data)Adapters.-nullable(operation.adapter()).fromJson(jsonReader2, customScalarAdapters);
                            continue block21;
                        }
                        case "errors": {
                            errors = INSTANCE.readErrors(jsonReader2);
                            continue block21;
                        }
                        case "extensions": {
                            Object object = -JsonReaders.readAny(jsonReader2);
                            extensions = object instanceof Map ? (Map)object : null;
                            continue block21;
                        }
                    }
                    jsonReader2.skipValue();
                }
                jsonReader2.endObject();
                if (jsonReader2.peek() != JsonReader.Token.END_DOCUMENT) {
                    throw new JsonDataException("Expected END_DOCUMENT but was " + (Object)((Object)jsonReader2.peek()));
                }
                boolean $i$f$uuid4 = false;
                UUID uUID = UUID.randomUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
                Object object = uUID;
                Operation.Data data2 = data;
                apolloResponse = new ApolloResponse.Builder<Operation.Data>(operation, (UUID)object, data2).errors(errors).extensions(extensions).build();
            }
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    apolloResponse = null;
                    break block24;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block25: {
                        try {
                            $this$use$iv.close();
                        }
                        catch (Throwable t$iv2) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv2;
                                break block25;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                        }
                    }
                }
            }
            try {
                $this$use$iv.close();
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
        }
        ApolloResponse<Operation.Data> result$iv = apolloResponse;
        Throwable throwable = thrown$iv;
        if (throwable == null) return result$iv;
        throw throwable;
    }

    @NotNull
    public final Error parseError(@NotNull Map<String, ? extends Object> payload) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        return this.readError(new MapJsonReader(payload, null, 2, null));
    }

    private final List<Error> readErrors(JsonReader $this$readErrors) {
        if ($this$readErrors.peek() == JsonReader.Token.NULL) {
            $this$readErrors.nextNull();
            return CollectionsKt.emptyList();
        }
        $this$readErrors.beginArray();
        List list = new ArrayList();
        while ($this$readErrors.hasNext()) {
            list.add(this.readError($this$readErrors));
        }
        $this$readErrors.endArray();
        return list;
    }

    /*
     * Unable to fully structure code
     */
    private final Error readError(JsonReader $this$readError) {
        message = "";
        locations = null;
        path = null;
        extensions = null;
        nonStandardFields = null;
        $this$readError.beginObject();
        block6: while ($this$readError.hasNext()) {
            block12: {
                block11: {
                    name = $this$readError.nextName();
                    switch (name.hashCode()) {
                        case 3433509: {
                            if (!name.equals("path")) {
                                ** break;
                            }
                            break block11;
                        }
                        case -1809421292: {
                            if (!name.equals("extensions")) {
                                ** break;
                            }
                            break block12;
                        }
                        case -1197189282: {
                            if (name.equals("locations")) break;
                            ** break;
                        }
                        case 954925063: {
                            if (!name.equals("message")) ** break;
                            v0 = $this$readError.nextString();
                            if (v0 == null) {
                                v0 = "";
                            }
                            message = v0;
                            continue block6;
                        }
                    }
                    locations = this.readErrorLocations($this$readError);
                    continue;
                }
                path = this.readPath($this$readError);
                continue;
            }
            var8_8 = -JsonReaders.readAny($this$readError);
            extensions = var8_8 instanceof Map != false ? (Map)var8_8 : null;
            continue;
lbl38:
            // 5 sources

            if (nonStandardFields == null) {
                nonStandardFields = new LinkedHashMap<K, V>();
            }
            nonStandardFields.put(name, -JsonReaders.readAny($this$readError));
        }
        $this$readError.endObject();
        return new Error(message, locations, path, extensions, nonStandardFields);
    }

    private final List<Object> readPath(JsonReader $this$readPath) {
        if ($this$readPath.peek() == JsonReader.Token.NULL) {
            return (List)((Object)$this$readPath.nextNull());
        }
        List list = new ArrayList();
        $this$readPath.beginArray();
        block3: while ($this$readPath.hasNext()) {
            switch (WhenMappings.$EnumSwitchMapping$0[$this$readPath.peek().ordinal()]) {
                case 1: 
                case 2: {
                    list.add($this$readPath.nextInt());
                    continue block3;
                }
            }
            String string = $this$readPath.nextString();
            Intrinsics.checkNotNull((Object)string);
            list.add(string);
        }
        $this$readPath.endArray();
        return list;
    }

    private final List<Error.Location> readErrorLocations(JsonReader $this$readErrorLocations) {
        if ($this$readErrorLocations.peek() == JsonReader.Token.NULL) {
            return (List)((Object)$this$readErrorLocations.nextNull());
        }
        List list = new ArrayList();
        $this$readErrorLocations.beginArray();
        while ($this$readErrorLocations.hasNext()) {
            list.add(this.readErrorLocation($this$readErrorLocations));
        }
        $this$readErrorLocations.endArray();
        return list;
    }

    private final Error.Location readErrorLocation(JsonReader $this$readErrorLocation) {
        int line = -1;
        int column = -1;
        $this$readErrorLocation.beginObject();
        while ($this$readErrorLocation.hasNext()) {
            String string = $this$readErrorLocation.nextName();
            if (Intrinsics.areEqual((Object)string, (Object)"line")) {
                line = $this$readErrorLocation.nextInt();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"column")) {
                column = $this$readErrorLocation.nextInt();
                continue;
            }
            $this$readErrorLocation.skipValue();
        }
        $this$readErrorLocation.endObject();
        return new Error.Location(line, column);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonReader.Token.values().length];
            try {
                nArray[JsonReader.Token.NUMBER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonReader.Token.LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

