package zeenea.connector.sqlserver.services.ssrs.client.xml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link SharedDataSet}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSharedDataSet.builder()}.
 */
@Generated(from = "SharedDataSet", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableSharedDataSet
    implements SharedDataSet {
  private final @Nullable String name;
  private final @Nullable String sharedDataSetReference;
  private final @Nullable DataSet dataSet;

  private ImmutableSharedDataSet(
      @Nullable String name,
      @Nullable String sharedDataSetReference,
      @Nullable DataSet dataSet) {
    this.name = name;
    this.sharedDataSetReference = sharedDataSetReference;
    this.dataSet = dataSet;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code sharedDataSetReference} attribute
   */
  @JsonProperty("sharedDataSetReference")
  @JacksonXmlProperty(localName = "SharedDataSetReference")
  @Override
  public @Nullable String getSharedDataSetReference() {
    return sharedDataSetReference;
  }

  /**
   * @return The value of the {@code dataSet} attribute
   */
  @JsonProperty("dataSet")
  @JacksonXmlProperty(localName = "DataSet")
  @Override
  public @Nullable DataSet getDataSet() {
    return dataSet;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SharedDataSet#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSharedDataSet withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableSharedDataSet(value, this.sharedDataSetReference, this.dataSet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SharedDataSet#getSharedDataSetReference() sharedDataSetReference} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sharedDataSetReference (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSharedDataSet withSharedDataSetReference(@Nullable String value) {
    if (Objects.equals(this.sharedDataSetReference, value)) return this;
    return new ImmutableSharedDataSet(this.name, value, this.dataSet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SharedDataSet#getDataSet() dataSet} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dataSet (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSharedDataSet withDataSet(@Nullable DataSet value) {
    if (this.dataSet == value) return this;
    return new ImmutableSharedDataSet(this.name, this.sharedDataSetReference, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSharedDataSet} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSharedDataSet
        && equalTo(0, (ImmutableSharedDataSet) another);
  }

  private boolean equalTo(int synthetic, ImmutableSharedDataSet another) {
    return Objects.equals(name, another.name)
        && Objects.equals(sharedDataSetReference, another.sharedDataSetReference)
        && Objects.equals(dataSet, another.dataSet);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code sharedDataSetReference}, {@code dataSet}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(sharedDataSetReference);
    h += (h << 5) + Objects.hashCode(dataSet);
    return h;
  }

  /**
   * Prints the immutable value {@code SharedDataSet} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SharedDataSet{"
        + "name=" + name
        + ", sharedDataSetReference=" + sharedDataSetReference
        + ", dataSet=" + dataSet
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link SharedDataSet} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SharedDataSet instance
   */
  public static ImmutableSharedDataSet copyOf(SharedDataSet instance) {
    if (instance instanceof ImmutableSharedDataSet) {
      return (ImmutableSharedDataSet) instance;
    }
    return ImmutableSharedDataSet.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSharedDataSet ImmutableSharedDataSet}.
   * <pre>
   * ImmutableSharedDataSet.builder()
   *    .name(String | null) // nullable {@link SharedDataSet#getName() name}
   *    .sharedDataSetReference(String | null) // nullable {@link SharedDataSet#getSharedDataSetReference() sharedDataSetReference}
   *    .dataSet(zeenea.connector.sqlserver.services.ssrs.client.xml.DataSet | null) // nullable {@link SharedDataSet#getDataSet() dataSet}
   *    .build();
   * </pre>
   * @return A new ImmutableSharedDataSet builder
   */
  public static ImmutableSharedDataSet.Builder builder() {
    return new ImmutableSharedDataSet.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSharedDataSet ImmutableSharedDataSet}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SharedDataSet", generator = "Immutables")
  @JacksonXmlRootElement(localName = "SharedDataSet")
  public static final class Builder {
    private String name;
    private String sharedDataSetReference;
    private DataSet dataSet;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SharedDataSet} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SharedDataSet instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String sharedDataSetReferenceValue = instance.getSharedDataSetReference();
      if (sharedDataSetReferenceValue != null) {
        sharedDataSetReference(sharedDataSetReferenceValue);
      }
      @Nullable DataSet dataSetValue = instance.getDataSet();
      if (dataSetValue != null) {
        dataSet(dataSetValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SharedDataSet#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link SharedDataSet#getSharedDataSetReference() sharedDataSetReference} attribute.
     * @param sharedDataSetReference The value for sharedDataSetReference (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("sharedDataSetReference")
    @JacksonXmlProperty(localName = "SharedDataSetReference")
    public final Builder sharedDataSetReference(@Nullable String sharedDataSetReference) {
      this.sharedDataSetReference = sharedDataSetReference;
      return this;
    }

    /**
     * Initializes the value for the {@link SharedDataSet#getDataSet() dataSet} attribute.
     * @param dataSet The value for dataSet (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dataSet")
    @JacksonXmlProperty(localName = "DataSet")
    public final Builder dataSet(@Nullable DataSet dataSet) {
      this.dataSet = dataSet;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSharedDataSet ImmutableSharedDataSet}.
     * @return An immutable instance of SharedDataSet
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSharedDataSet build() {
      return new ImmutableSharedDataSet(name, sharedDataSetReference, dataSet);
    }
  }
}
