package zeenea.connector.sqlserver.services.ssrs.client.xml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RpdDataSource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRpdDataSource.builder()}.
 */
@Generated(from = "RpdDataSource", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableRpdDataSource
    implements RpdDataSource {
  private final ConnectionProperties connectionProperties;

  private ImmutableRpdDataSource(ConnectionProperties connectionProperties) {
    this.connectionProperties = connectionProperties;
  }

  /**
   * @return The value of the {@code connectionProperties} attribute
   */
  @JsonProperty("connectionProperties")
  @JacksonXmlProperty(localName = "ConnectionProperties")
  @Override
  public ConnectionProperties getConnectionProperties() {
    return connectionProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RpdDataSource#getConnectionProperties() connectionProperties} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectionProperties
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRpdDataSource withConnectionProperties(ConnectionProperties value) {
    if (this.connectionProperties == value) return this;
    ConnectionProperties newValue = Objects.requireNonNull(value, "connectionProperties");
    return new ImmutableRpdDataSource(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRpdDataSource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRpdDataSource
        && equalTo(0, (ImmutableRpdDataSource) another);
  }

  private boolean equalTo(int synthetic, ImmutableRpdDataSource another) {
    return connectionProperties.equals(another.connectionProperties);
  }

  /**
   * Computes a hash code from attributes: {@code connectionProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + connectionProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RpdDataSource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RpdDataSource{"
        + "connectionProperties=" + connectionProperties
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link RpdDataSource} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RpdDataSource instance
   */
  public static ImmutableRpdDataSource copyOf(RpdDataSource instance) {
    if (instance instanceof ImmutableRpdDataSource) {
      return (ImmutableRpdDataSource) instance;
    }
    return ImmutableRpdDataSource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRpdDataSource ImmutableRpdDataSource}.
   * <pre>
   * ImmutableRpdDataSource.builder()
   *    .connectionProperties(zeenea.connector.sqlserver.services.ssrs.client.xml.ConnectionProperties) // required {@link RpdDataSource#getConnectionProperties() connectionProperties}
   *    .build();
   * </pre>
   * @return A new ImmutableRpdDataSource builder
   */
  public static ImmutableRpdDataSource.Builder builder() {
    return new ImmutableRpdDataSource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRpdDataSource ImmutableRpdDataSource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RpdDataSource", generator = "Immutables")
  @JacksonXmlRootElement(localName = "RpdDataSource")
  public static final class Builder {
    private static final long INIT_BIT_CONNECTION_PROPERTIES = 0x1L;
    private long initBits = 0x1L;

    private ConnectionProperties connectionProperties;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RpdDataSource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RpdDataSource instance) {
      Objects.requireNonNull(instance, "instance");
      this.connectionProperties(instance.getConnectionProperties());
      return this;
    }

    /**
     * Initializes the value for the {@link RpdDataSource#getConnectionProperties() connectionProperties} attribute.
     * @param connectionProperties The value for connectionProperties 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("connectionProperties")
    @JacksonXmlProperty(localName = "ConnectionProperties")
    public final Builder connectionProperties(ConnectionProperties connectionProperties) {
      this.connectionProperties = Objects.requireNonNull(connectionProperties, "connectionProperties");
      initBits &= ~INIT_BIT_CONNECTION_PROPERTIES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRpdDataSource ImmutableRpdDataSource}.
     * @return An immutable instance of RpdDataSource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRpdDataSource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRpdDataSource(connectionProperties);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONNECTION_PROPERTIES) != 0) attributes.add("connectionProperties");
      return "Cannot build RpdDataSource, some of required attributes are not set " + attributes;
    }
  }
}
