package zeenea.connector.sqlserver.services.ssrs.client.xml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link QueryParameter}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQueryParameter.builder()}.
 */
@Generated(from = "QueryParameter", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableQueryParameter
    implements QueryParameter {
  private final String name;
  private final String value;

  private ImmutableQueryParameter(String name, String value) {
    this.name = name;
    this.value = value;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JacksonXmlProperty(isAttribute = true, localName = "Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @JacksonXmlProperty(localName = "Value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QueryParameter#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQueryParameter withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableQueryParameter(newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QueryParameter#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQueryParameter withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableQueryParameter(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQueryParameter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQueryParameter
        && equalTo(0, (ImmutableQueryParameter) another);
  }

  private boolean equalTo(int synthetic, ImmutableQueryParameter another) {
    return name.equals(another.name)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QueryParameter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "QueryParameter{"
        + "name=" + name
        + ", value=" + value
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link QueryParameter} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QueryParameter instance
   */
  public static ImmutableQueryParameter copyOf(QueryParameter instance) {
    if (instance instanceof ImmutableQueryParameter) {
      return (ImmutableQueryParameter) instance;
    }
    return ImmutableQueryParameter.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQueryParameter ImmutableQueryParameter}.
   * <pre>
   * ImmutableQueryParameter.builder()
   *    .name(String) // required {@link QueryParameter#getName() name}
   *    .value(String) // required {@link QueryParameter#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableQueryParameter builder
   */
  public static ImmutableQueryParameter.Builder builder() {
    return new ImmutableQueryParameter.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQueryParameter ImmutableQueryParameter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QueryParameter", generator = "Immutables")
  @JacksonXmlRootElement(localName = "QueryParameter")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code QueryParameter} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QueryParameter instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link QueryParameter#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    @JacksonXmlProperty(isAttribute = true, localName = "Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link QueryParameter#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    @JacksonXmlProperty(localName = "Value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableQueryParameter ImmutableQueryParameter}.
     * @return An immutable instance of QueryParameter
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQueryParameter build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQueryParameter(name, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build QueryParameter, some of required attributes are not set " + attributes;
    }
  }
}
