package zeenea.connector.sqlserver.services.ssrs.client.xml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Filter}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFilter.builder()}.
 */
@Generated(from = "Filter", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableFilter implements Filter {
  private final String filterExpression;
  private final String operator;

  private ImmutableFilter(String filterExpression, String operator) {
    this.filterExpression = filterExpression;
    this.operator = operator;
  }

  /**
   * @return The value of the {@code filterExpression} attribute
   */
  @JsonProperty("filterExpression")
  @JacksonXmlProperty(localName = "FilterExpression")
  @Override
  public String getFilterExpression() {
    return filterExpression;
  }

  /**
   * @return The value of the {@code operator} attribute
   */
  @JsonProperty("operator")
  @JacksonXmlProperty(localName = "Operator")
  @Override
  public String getOperator() {
    return operator;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Filter#getFilterExpression() filterExpression} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for filterExpression
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFilter withFilterExpression(String value) {
    String newValue = Objects.requireNonNull(value, "filterExpression");
    if (this.filterExpression.equals(newValue)) return this;
    return new ImmutableFilter(newValue, this.operator);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Filter#getOperator() operator} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for operator
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFilter withOperator(String value) {
    String newValue = Objects.requireNonNull(value, "operator");
    if (this.operator.equals(newValue)) return this;
    return new ImmutableFilter(this.filterExpression, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFilter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFilter
        && equalTo(0, (ImmutableFilter) another);
  }

  private boolean equalTo(int synthetic, ImmutableFilter another) {
    return filterExpression.equals(another.filterExpression)
        && operator.equals(another.operator);
  }

  /**
   * Computes a hash code from attributes: {@code filterExpression}, {@code operator}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + filterExpression.hashCode();
    h += (h << 5) + operator.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Filter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Filter{"
        + "filterExpression=" + filterExpression
        + ", operator=" + operator
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Filter} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Filter instance
   */
  public static ImmutableFilter copyOf(Filter instance) {
    if (instance instanceof ImmutableFilter) {
      return (ImmutableFilter) instance;
    }
    return ImmutableFilter.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFilter ImmutableFilter}.
   * <pre>
   * ImmutableFilter.builder()
   *    .filterExpression(String) // required {@link Filter#getFilterExpression() filterExpression}
   *    .operator(String) // required {@link Filter#getOperator() operator}
   *    .build();
   * </pre>
   * @return A new ImmutableFilter builder
   */
  public static ImmutableFilter.Builder builder() {
    return new ImmutableFilter.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFilter ImmutableFilter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Filter", generator = "Immutables")
  @JacksonXmlRootElement(localName = "Filter")
  public static final class Builder {
    private static final long INIT_BIT_FILTER_EXPRESSION = 0x1L;
    private static final long INIT_BIT_OPERATOR = 0x2L;
    private long initBits = 0x3L;

    private String filterExpression;
    private String operator;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Filter} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Filter instance) {
      Objects.requireNonNull(instance, "instance");
      this.filterExpression(instance.getFilterExpression());
      this.operator(instance.getOperator());
      return this;
    }

    /**
     * Initializes the value for the {@link Filter#getFilterExpression() filterExpression} attribute.
     * @param filterExpression The value for filterExpression 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("filterExpression")
    @JacksonXmlProperty(localName = "FilterExpression")
    public final Builder filterExpression(String filterExpression) {
      this.filterExpression = Objects.requireNonNull(filterExpression, "filterExpression");
      initBits &= ~INIT_BIT_FILTER_EXPRESSION;
      return this;
    }

    /**
     * Initializes the value for the {@link Filter#getOperator() operator} attribute.
     * @param operator The value for operator 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("operator")
    @JacksonXmlProperty(localName = "Operator")
    public final Builder operator(String operator) {
      this.operator = Objects.requireNonNull(operator, "operator");
      initBits &= ~INIT_BIT_OPERATOR;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFilter ImmutableFilter}.
     * @return An immutable instance of Filter
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFilter build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFilter(filterExpression, operator);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FILTER_EXPRESSION) != 0) attributes.add("filterExpression");
      if ((initBits & INIT_BIT_OPERATOR) != 0) attributes.add("operator");
      return "Cannot build Filter, some of required attributes are not set " + attributes;
    }
  }
}
