package zeenea.connector.sqlserver.services.ssrs.client.xml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Field}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableField.builder()}.
 */
@Generated(from = "Field", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableField implements Field {
  private final String name;
  private final String dataField;
  private final String type;

  private ImmutableField(String name, String dataField, String type) {
    this.name = name;
    this.dataField = dataField;
    this.type = type;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JacksonXmlProperty(isAttribute = true, localName = "Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code dataField} attribute
   */
  @JsonProperty("dataField")
  @JacksonXmlProperty(namespace = "rd", localName = "DataField")
  @Override
  public String getDataField() {
    return dataField;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @JacksonXmlProperty(namespace = "rd", localName = "TypeName")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableField(newValue, this.dataField, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getDataField() dataField} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dataField
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withDataField(String value) {
    String newValue = Objects.requireNonNull(value, "dataField");
    if (this.dataField.equals(newValue)) return this;
    return new ImmutableField(this.name, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableField(this.name, this.dataField, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableField} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableField
        && equalTo(0, (ImmutableField) another);
  }

  private boolean equalTo(int synthetic, ImmutableField another) {
    return name.equals(another.name)
        && dataField.equals(another.dataField)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code dataField}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + dataField.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Field} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Field{"
        + "name=" + name
        + ", dataField=" + dataField
        + ", type=" + type
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Field} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Field instance
   */
  public static ImmutableField copyOf(Field instance) {
    if (instance instanceof ImmutableField) {
      return (ImmutableField) instance;
    }
    return ImmutableField.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableField ImmutableField}.
   * <pre>
   * ImmutableField.builder()
   *    .name(String) // required {@link Field#getName() name}
   *    .dataField(String) // required {@link Field#getDataField() dataField}
   *    .type(String) // required {@link Field#getType() type}
   *    .build();
   * </pre>
   * @return A new ImmutableField builder
   */
  public static ImmutableField.Builder builder() {
    return new ImmutableField.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableField ImmutableField}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Field", generator = "Immutables")
  @JacksonXmlRootElement(localName = "Field")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_DATA_FIELD = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private String name;
    private String dataField;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Field} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Field instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.dataField(instance.getDataField());
      this.type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    @JacksonXmlProperty(isAttribute = true, localName = "Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getDataField() dataField} attribute.
     * @param dataField The value for dataField 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dataField")
    @JacksonXmlProperty(namespace = "rd", localName = "DataField")
    public final Builder dataField(String dataField) {
      this.dataField = Objects.requireNonNull(dataField, "dataField");
      initBits &= ~INIT_BIT_DATA_FIELD;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    @JacksonXmlProperty(namespace = "rd", localName = "TypeName")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableField ImmutableField}.
     * @return An immutable instance of Field
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableField build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableField(name, dataField, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_DATA_FIELD) != 0) attributes.add("dataField");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build Field, some of required attributes are not set " + attributes;
    }
  }
}
