package zeenea.connector.sqlserver.services.ssas.client.model.tabular;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Table}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTable.builder()}.
 */
@Generated(from = "Table", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableTable
    implements Table {
  private final String id;
  private final String name;
  private final @Nullable String description;
  private final boolean hidden;
  private final String modifiedTime;
  private final String structureModifiedTime;
  private final boolean isPrivate;

  private ImmutableTable(
      String id,
      String name,
      @Nullable String description,
      boolean hidden,
      String modifiedTime,
      String structureModifiedTime,
      boolean isPrivate) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.hidden = hidden;
    this.modifiedTime = modifiedTime;
    this.structureModifiedTime = structureModifiedTime;
    this.isPrivate = isPrivate;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JacksonXmlProperty(localName = "ID")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JacksonXmlProperty(localName = "Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @JacksonXmlProperty(localName = "Description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code hidden} attribute
   */
  @JsonProperty("hidden")
  @JacksonXmlProperty(localName = "IsHidden")
  @Override
  public boolean isHidden() {
    return hidden;
  }

  /**
   * @return The value of the {@code modifiedTime} attribute
   */
  @JsonProperty("modifiedTime")
  @JacksonXmlProperty(localName = "ModifiedTime")
  @Override
  public String getModifiedTime() {
    return modifiedTime;
  }

  /**
   * @return The value of the {@code structureModifiedTime} attribute
   */
  @JsonProperty("structureModifiedTime")
  @JacksonXmlProperty(localName = "StructureModifiedTime")
  @Override
  public String getStructureModifiedTime() {
    return structureModifiedTime;
  }

  /**
   * @return The value of the {@code isPrivate} attribute
   */
  @JsonProperty("private")
  @JacksonXmlProperty(localName = "IsPrivate")
  @Override
  public boolean isPrivate() {
    return isPrivate;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableTable(
        newValue,
        this.name,
        this.description,
        this.hidden,
        this.modifiedTime,
        this.structureModifiedTime,
        this.isPrivate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTable(
        this.id,
        newValue,
        this.description,
        this.hidden,
        this.modifiedTime,
        this.structureModifiedTime,
        this.isPrivate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableTable(
        this.id,
        this.name,
        value,
        this.hidden,
        this.modifiedTime,
        this.structureModifiedTime,
        this.isPrivate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#isHidden() hidden} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hidden
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withHidden(boolean value) {
    if (this.hidden == value) return this;
    return new ImmutableTable(
        this.id,
        this.name,
        this.description,
        value,
        this.modifiedTime,
        this.structureModifiedTime,
        this.isPrivate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getModifiedTime() modifiedTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modifiedTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withModifiedTime(String value) {
    String newValue = Objects.requireNonNull(value, "modifiedTime");
    if (this.modifiedTime.equals(newValue)) return this;
    return new ImmutableTable(
        this.id,
        this.name,
        this.description,
        this.hidden,
        newValue,
        this.structureModifiedTime,
        this.isPrivate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getStructureModifiedTime() structureModifiedTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for structureModifiedTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withStructureModifiedTime(String value) {
    String newValue = Objects.requireNonNull(value, "structureModifiedTime");
    if (this.structureModifiedTime.equals(newValue)) return this;
    return new ImmutableTable(this.id, this.name, this.description, this.hidden, this.modifiedTime, newValue, this.isPrivate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#isPrivate() private} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isPrivate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withPrivate(boolean value) {
    if (this.isPrivate == value) return this;
    return new ImmutableTable(
        this.id,
        this.name,
        this.description,
        this.hidden,
        this.modifiedTime,
        this.structureModifiedTime,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTable
        && equalTo(0, (ImmutableTable) another);
  }

  private boolean equalTo(int synthetic, ImmutableTable another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && Objects.equals(description, another.description)
        && hidden == another.hidden
        && modifiedTime.equals(another.modifiedTime)
        && structureModifiedTime.equals(another.structureModifiedTime)
        && isPrivate == another.isPrivate;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code description}, {@code hidden}, {@code modifiedTime}, {@code structureModifiedTime}, {@code isPrivate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Boolean.hashCode(hidden);
    h += (h << 5) + modifiedTime.hashCode();
    h += (h << 5) + structureModifiedTime.hashCode();
    h += (h << 5) + Boolean.hashCode(isPrivate);
    return h;
  }

  /**
   * Prints the immutable value {@code Table} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Table{"
        + "id=" + id
        + ", name=" + name
        + ", description=" + description
        + ", hidden=" + hidden
        + ", modifiedTime=" + modifiedTime
        + ", structureModifiedTime=" + structureModifiedTime
        + ", private=" + isPrivate
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Table", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Table {
    String id;
    String name;
    String description;
    boolean hidden;
    boolean hiddenIsSet;
    String modifiedTime;
    String structureModifiedTime;
    boolean isPrivate;
    boolean isPrivateIsSet;
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("description")
    @JacksonXmlProperty(localName = "Description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("hidden")
    @JacksonXmlProperty(localName = "IsHidden")
    public void setHidden(boolean hidden) {
      this.hidden = hidden;
      this.hiddenIsSet = true;
    }
    @JsonProperty("modifiedTime")
    @JacksonXmlProperty(localName = "ModifiedTime")
    public void setModifiedTime(String modifiedTime) {
      this.modifiedTime = modifiedTime;
    }
    @JsonProperty("structureModifiedTime")
    @JacksonXmlProperty(localName = "StructureModifiedTime")
    public void setStructureModifiedTime(String structureModifiedTime) {
      this.structureModifiedTime = structureModifiedTime;
    }
    @JsonProperty("private")
    @JacksonXmlProperty(localName = "IsPrivate")
    public void setPrivate(boolean isPrivate) {
      this.isPrivate = isPrivate;
      this.isPrivateIsSet = true;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isHidden() { throw new UnsupportedOperationException(); }
    @Override
    public String getModifiedTime() { throw new UnsupportedOperationException(); }
    @Override
    public String getStructureModifiedTime() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isPrivate() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTable fromJson(Json json) {
    ImmutableTable.Builder builder = ImmutableTable.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.hiddenIsSet) {
      builder.hidden(json.hidden);
    }
    if (json.modifiedTime != null) {
      builder.modifiedTime(json.modifiedTime);
    }
    if (json.structureModifiedTime != null) {
      builder.structureModifiedTime(json.structureModifiedTime);
    }
    if (json.isPrivateIsSet) {
      builder.isPrivate(json.isPrivate);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Table} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Table instance
   */
  public static ImmutableTable copyOf(Table instance) {
    if (instance instanceof ImmutableTable) {
      return (ImmutableTable) instance;
    }
    return ImmutableTable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTable ImmutableTable}.
   * <pre>
   * ImmutableTable.builder()
   *    .id(String) // required {@link Table#getId() id}
   *    .name(String) // required {@link Table#getName() name}
   *    .description(String | null) // nullable {@link Table#getDescription() description}
   *    .hidden(boolean) // required {@link Table#isHidden() hidden}
   *    .modifiedTime(String) // required {@link Table#getModifiedTime() modifiedTime}
   *    .structureModifiedTime(String) // required {@link Table#getStructureModifiedTime() structureModifiedTime}
   *    .isPrivate(boolean) // required {@link Table#isPrivate() private}
   *    .build();
   * </pre>
   * @return A new ImmutableTable builder
   */
  public static ImmutableTable.Builder builder() {
    return new ImmutableTable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTable ImmutableTable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Table", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_HIDDEN = 0x4L;
    private static final long INIT_BIT_MODIFIED_TIME = 0x8L;
    private static final long INIT_BIT_STRUCTURE_MODIFIED_TIME = 0x10L;
    private static final long INIT_BIT_IS_PRIVATE = 0x20L;
    private long initBits = 0x3fL;

    private String id;
    private String name;
    private String description;
    private boolean hidden;
    private String modifiedTime;
    private String structureModifiedTime;
    private boolean isPrivate;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Table} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Table instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      this.name(instance.getName());
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      this.hidden(instance.isHidden());
      this.modifiedTime(instance.getModifiedTime());
      this.structureModifiedTime(instance.getStructureModifiedTime());
      this.isPrivate(instance.isPrivate());
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    @JacksonXmlProperty(localName = "Description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#isHidden() hidden} attribute.
     * @param hidden The value for hidden 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("hidden")
    @JacksonXmlProperty(localName = "IsHidden")
    public final Builder hidden(boolean hidden) {
      this.hidden = hidden;
      initBits &= ~INIT_BIT_HIDDEN;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getModifiedTime() modifiedTime} attribute.
     * @param modifiedTime The value for modifiedTime 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("modifiedTime")
    @JacksonXmlProperty(localName = "ModifiedTime")
    public final Builder modifiedTime(String modifiedTime) {
      this.modifiedTime = Objects.requireNonNull(modifiedTime, "modifiedTime");
      initBits &= ~INIT_BIT_MODIFIED_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getStructureModifiedTime() structureModifiedTime} attribute.
     * @param structureModifiedTime The value for structureModifiedTime 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("structureModifiedTime")
    @JacksonXmlProperty(localName = "StructureModifiedTime")
    public final Builder structureModifiedTime(String structureModifiedTime) {
      this.structureModifiedTime = Objects.requireNonNull(structureModifiedTime, "structureModifiedTime");
      initBits &= ~INIT_BIT_STRUCTURE_MODIFIED_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#isPrivate() private} attribute.
     * @param isPrivate The value for isPrivate 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("private")
    @JacksonXmlProperty(localName = "IsPrivate")
    public final Builder isPrivate(boolean isPrivate) {
      this.isPrivate = isPrivate;
      initBits &= ~INIT_BIT_IS_PRIVATE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTable ImmutableTable}.
     * @return An immutable instance of Table
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTable build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTable(id, name, description, hidden, modifiedTime, structureModifiedTime, isPrivate);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_HIDDEN) != 0) attributes.add("hidden");
      if ((initBits & INIT_BIT_MODIFIED_TIME) != 0) attributes.add("modifiedTime");
      if ((initBits & INIT_BIT_STRUCTURE_MODIFIED_TIME) != 0) attributes.add("structureModifiedTime");
      if ((initBits & INIT_BIT_IS_PRIVATE) != 0) attributes.add("private");
      return "Cannot build Table, some of required attributes are not set " + attributes;
    }
  }
}
