package zeenea.connector.sqlserver.services.ssas.client.model.tabular;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Relationship}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRelationship.builder()}.
 */
@Generated(from = "Relationship", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableRelationship
    implements Relationship {
  private final String fromTableID;
  private final String fromColumnID;
  private final String toTableID;
  private final String toColumnID;

  private ImmutableRelationship(
      String fromTableID,
      String fromColumnID,
      String toTableID,
      String toColumnID) {
    this.fromTableID = fromTableID;
    this.fromColumnID = fromColumnID;
    this.toTableID = toTableID;
    this.toColumnID = toColumnID;
  }

  /**
   * @return The value of the {@code fromTableID} attribute
   */
  @JsonProperty("fromTableID")
  @JacksonXmlProperty(localName = "FromTableID")
  @Override
  public String getFromTableID() {
    return fromTableID;
  }

  /**
   * @return The value of the {@code fromColumnID} attribute
   */
  @JsonProperty("fromColumnID")
  @JacksonXmlProperty(localName = "FromColumnID")
  @Override
  public String getFromColumnID() {
    return fromColumnID;
  }

  /**
   * @return The value of the {@code toTableID} attribute
   */
  @JsonProperty("toTableID")
  @JacksonXmlProperty(localName = "ToTableID")
  @Override
  public String getToTableID() {
    return toTableID;
  }

  /**
   * @return The value of the {@code toColumnID} attribute
   */
  @JsonProperty("toColumnID")
  @JacksonXmlProperty(localName = "ToColumnID")
  @Override
  public String getToColumnID() {
    return toColumnID;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Relationship#getFromTableID() fromTableID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fromTableID
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelationship withFromTableID(String value) {
    String newValue = Objects.requireNonNull(value, "fromTableID");
    if (this.fromTableID.equals(newValue)) return this;
    return new ImmutableRelationship(newValue, this.fromColumnID, this.toTableID, this.toColumnID);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Relationship#getFromColumnID() fromColumnID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fromColumnID
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelationship withFromColumnID(String value) {
    String newValue = Objects.requireNonNull(value, "fromColumnID");
    if (this.fromColumnID.equals(newValue)) return this;
    return new ImmutableRelationship(this.fromTableID, newValue, this.toTableID, this.toColumnID);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Relationship#getToTableID() toTableID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toTableID
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelationship withToTableID(String value) {
    String newValue = Objects.requireNonNull(value, "toTableID");
    if (this.toTableID.equals(newValue)) return this;
    return new ImmutableRelationship(this.fromTableID, this.fromColumnID, newValue, this.toColumnID);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Relationship#getToColumnID() toColumnID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toColumnID
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelationship withToColumnID(String value) {
    String newValue = Objects.requireNonNull(value, "toColumnID");
    if (this.toColumnID.equals(newValue)) return this;
    return new ImmutableRelationship(this.fromTableID, this.fromColumnID, this.toTableID, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRelationship} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRelationship
        && equalTo(0, (ImmutableRelationship) another);
  }

  private boolean equalTo(int synthetic, ImmutableRelationship another) {
    return fromTableID.equals(another.fromTableID)
        && fromColumnID.equals(another.fromColumnID)
        && toTableID.equals(another.toTableID)
        && toColumnID.equals(another.toColumnID);
  }

  /**
   * Computes a hash code from attributes: {@code fromTableID}, {@code fromColumnID}, {@code toTableID}, {@code toColumnID}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + fromTableID.hashCode();
    h += (h << 5) + fromColumnID.hashCode();
    h += (h << 5) + toTableID.hashCode();
    h += (h << 5) + toColumnID.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Relationship} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Relationship{"
        + "fromTableID=" + fromTableID
        + ", fromColumnID=" + fromColumnID
        + ", toTableID=" + toTableID
        + ", toColumnID=" + toColumnID
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Relationship", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements Relationship {
    String fromTableID;
    String fromColumnID;
    String toTableID;
    String toColumnID;
    @JsonProperty("fromTableID")
    @JacksonXmlProperty(localName = "FromTableID")
    public void setFromTableID(String fromTableID) {
      this.fromTableID = fromTableID;
    }
    @JsonProperty("fromColumnID")
    @JacksonXmlProperty(localName = "FromColumnID")
    public void setFromColumnID(String fromColumnID) {
      this.fromColumnID = fromColumnID;
    }
    @JsonProperty("toTableID")
    @JacksonXmlProperty(localName = "ToTableID")
    public void setToTableID(String toTableID) {
      this.toTableID = toTableID;
    }
    @JsonProperty("toColumnID")
    @JacksonXmlProperty(localName = "ToColumnID")
    public void setToColumnID(String toColumnID) {
      this.toColumnID = toColumnID;
    }
    @Override
    public String getFromTableID() { throw new UnsupportedOperationException(); }
    @Override
    public String getFromColumnID() { throw new UnsupportedOperationException(); }
    @Override
    public String getToTableID() { throw new UnsupportedOperationException(); }
    @Override
    public String getToColumnID() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRelationship fromJson(Json json) {
    ImmutableRelationship.Builder builder = ImmutableRelationship.builder();
    if (json.fromTableID != null) {
      builder.fromTableID(json.fromTableID);
    }
    if (json.fromColumnID != null) {
      builder.fromColumnID(json.fromColumnID);
    }
    if (json.toTableID != null) {
      builder.toTableID(json.toTableID);
    }
    if (json.toColumnID != null) {
      builder.toColumnID(json.toColumnID);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Relationship} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Relationship instance
   */
  public static ImmutableRelationship copyOf(Relationship instance) {
    if (instance instanceof ImmutableRelationship) {
      return (ImmutableRelationship) instance;
    }
    return ImmutableRelationship.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRelationship ImmutableRelationship}.
   * <pre>
   * ImmutableRelationship.builder()
   *    .fromTableID(String) // required {@link Relationship#getFromTableID() fromTableID}
   *    .fromColumnID(String) // required {@link Relationship#getFromColumnID() fromColumnID}
   *    .toTableID(String) // required {@link Relationship#getToTableID() toTableID}
   *    .toColumnID(String) // required {@link Relationship#getToColumnID() toColumnID}
   *    .build();
   * </pre>
   * @return A new ImmutableRelationship builder
   */
  public static ImmutableRelationship.Builder builder() {
    return new ImmutableRelationship.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRelationship ImmutableRelationship}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Relationship", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_FROM_TABLE_I_D = 0x1L;
    private static final long INIT_BIT_FROM_COLUMN_I_D = 0x2L;
    private static final long INIT_BIT_TO_TABLE_I_D = 0x4L;
    private static final long INIT_BIT_TO_COLUMN_I_D = 0x8L;
    private long initBits = 0xfL;

    private String fromTableID;
    private String fromColumnID;
    private String toTableID;
    private String toColumnID;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Relationship} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Relationship instance) {
      Objects.requireNonNull(instance, "instance");
      this.fromTableID(instance.getFromTableID());
      this.fromColumnID(instance.getFromColumnID());
      this.toTableID(instance.getToTableID());
      this.toColumnID(instance.getToColumnID());
      return this;
    }

    /**
     * Initializes the value for the {@link Relationship#getFromTableID() fromTableID} attribute.
     * @param fromTableID The value for fromTableID 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("fromTableID")
    @JacksonXmlProperty(localName = "FromTableID")
    public final Builder fromTableID(String fromTableID) {
      this.fromTableID = Objects.requireNonNull(fromTableID, "fromTableID");
      initBits &= ~INIT_BIT_FROM_TABLE_I_D;
      return this;
    }

    /**
     * Initializes the value for the {@link Relationship#getFromColumnID() fromColumnID} attribute.
     * @param fromColumnID The value for fromColumnID 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("fromColumnID")
    @JacksonXmlProperty(localName = "FromColumnID")
    public final Builder fromColumnID(String fromColumnID) {
      this.fromColumnID = Objects.requireNonNull(fromColumnID, "fromColumnID");
      initBits &= ~INIT_BIT_FROM_COLUMN_I_D;
      return this;
    }

    /**
     * Initializes the value for the {@link Relationship#getToTableID() toTableID} attribute.
     * @param toTableID The value for toTableID 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("toTableID")
    @JacksonXmlProperty(localName = "ToTableID")
    public final Builder toTableID(String toTableID) {
      this.toTableID = Objects.requireNonNull(toTableID, "toTableID");
      initBits &= ~INIT_BIT_TO_TABLE_I_D;
      return this;
    }

    /**
     * Initializes the value for the {@link Relationship#getToColumnID() toColumnID} attribute.
     * @param toColumnID The value for toColumnID 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("toColumnID")
    @JacksonXmlProperty(localName = "ToColumnID")
    public final Builder toColumnID(String toColumnID) {
      this.toColumnID = Objects.requireNonNull(toColumnID, "toColumnID");
      initBits &= ~INIT_BIT_TO_COLUMN_I_D;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRelationship ImmutableRelationship}.
     * @return An immutable instance of Relationship
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRelationship build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRelationship(fromTableID, fromColumnID, toTableID, toColumnID);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FROM_TABLE_I_D) != 0) attributes.add("fromTableID");
      if ((initBits & INIT_BIT_FROM_COLUMN_I_D) != 0) attributes.add("fromColumnID");
      if ((initBits & INIT_BIT_TO_TABLE_I_D) != 0) attributes.add("toTableID");
      if ((initBits & INIT_BIT_TO_COLUMN_I_D) != 0) attributes.add("toColumnID");
      return "Cannot build Relationship, some of required attributes are not set " + attributes;
    }
  }
}
