package zeenea.connector.sqlserver.services.ssas.client.model.tabular;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Partition}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePartition.builder()}.
 */
@Generated(from = "Partition", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutablePartition
    implements Partition {
  private final String queryDefinition;
  private final String type;
  private final @Nullable String dataSourceId;

  private ImmutablePartition(
      String queryDefinition,
      String type,
      @Nullable String dataSourceId) {
    this.queryDefinition = queryDefinition;
    this.type = type;
    this.dataSourceId = dataSourceId;
  }

  /**
   * @return The value of the {@code queryDefinition} attribute
   */
  @JsonProperty("queryDefinition")
  @JacksonXmlProperty(localName = "QueryDefinition")
  @Override
  public String getQueryDefinition() {
    return queryDefinition;
  }

  /**
   * Get the type of the partition:
   * <ul>
   *   <li>1: SQL Query, the query definition contains a SQL query and the data source id will not
   *       be empty.
   *   <li>4: Power Query, the query definition contains a M script, the data source is define
   *       inside this script (i.e the data source property is null).
   * </ul>
   * @return The type of the partition.
   */
  @JsonProperty("type")
  @JacksonXmlProperty(localName = "Type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code dataSourceId} attribute
   */
  @JsonProperty("dataSourceId")
  @JacksonXmlProperty(localName = "DataSourceID")
  @Override
  public @Nullable String getDataSourceId() {
    return dataSourceId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Partition#getQueryDefinition() queryDefinition} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for queryDefinition
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePartition withQueryDefinition(String value) {
    String newValue = Objects.requireNonNull(value, "queryDefinition");
    if (this.queryDefinition.equals(newValue)) return this;
    return new ImmutablePartition(newValue, this.type, this.dataSourceId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Partition#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePartition withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutablePartition(this.queryDefinition, newValue, this.dataSourceId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Partition#getDataSourceId() dataSourceId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dataSourceId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePartition withDataSourceId(@Nullable String value) {
    if (Objects.equals(this.dataSourceId, value)) return this;
    return new ImmutablePartition(this.queryDefinition, this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePartition} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePartition
        && equalTo(0, (ImmutablePartition) another);
  }

  private boolean equalTo(int synthetic, ImmutablePartition another) {
    return queryDefinition.equals(another.queryDefinition)
        && type.equals(another.type)
        && Objects.equals(dataSourceId, another.dataSourceId);
  }

  /**
   * Computes a hash code from attributes: {@code queryDefinition}, {@code type}, {@code dataSourceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + queryDefinition.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(dataSourceId);
    return h;
  }

  /**
   * Prints the immutable value {@code Partition} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Partition{"
        + "queryDefinition=" + queryDefinition
        + ", type=" + type
        + ", dataSourceId=" + dataSourceId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Partition", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Partition {
    String queryDefinition;
    String type;
    String dataSourceId;
    @JsonProperty("queryDefinition")
    @JacksonXmlProperty(localName = "QueryDefinition")
    public void setQueryDefinition(String queryDefinition) {
      this.queryDefinition = queryDefinition;
    }
    @JsonProperty("type")
    @JacksonXmlProperty(localName = "Type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("dataSourceId")
    @JacksonXmlProperty(localName = "DataSourceID")
    public void setDataSourceId(@Nullable String dataSourceId) {
      this.dataSourceId = dataSourceId;
    }
    @Override
    public String getQueryDefinition() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getDataSourceId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePartition fromJson(Json json) {
    ImmutablePartition.Builder builder = ImmutablePartition.builder();
    if (json.queryDefinition != null) {
      builder.queryDefinition(json.queryDefinition);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.dataSourceId != null) {
      builder.dataSourceId(json.dataSourceId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Partition} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Partition instance
   */
  public static ImmutablePartition copyOf(Partition instance) {
    if (instance instanceof ImmutablePartition) {
      return (ImmutablePartition) instance;
    }
    return ImmutablePartition.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePartition ImmutablePartition}.
   * <pre>
   * ImmutablePartition.builder()
   *    .queryDefinition(String) // required {@link Partition#getQueryDefinition() queryDefinition}
   *    .type(String) // required {@link Partition#getType() type}
   *    .dataSourceId(String | null) // nullable {@link Partition#getDataSourceId() dataSourceId}
   *    .build();
   * </pre>
   * @return A new ImmutablePartition builder
   */
  public static ImmutablePartition.Builder builder() {
    return new ImmutablePartition.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePartition ImmutablePartition}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Partition", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_QUERY_DEFINITION = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private String queryDefinition;
    private String type;
    private String dataSourceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Partition} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Partition instance) {
      Objects.requireNonNull(instance, "instance");
      this.queryDefinition(instance.getQueryDefinition());
      this.type(instance.getType());
      @Nullable String dataSourceIdValue = instance.getDataSourceId();
      if (dataSourceIdValue != null) {
        dataSourceId(dataSourceIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Partition#getQueryDefinition() queryDefinition} attribute.
     * @param queryDefinition The value for queryDefinition 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("queryDefinition")
    @JacksonXmlProperty(localName = "QueryDefinition")
    public final Builder queryDefinition(String queryDefinition) {
      this.queryDefinition = Objects.requireNonNull(queryDefinition, "queryDefinition");
      initBits &= ~INIT_BIT_QUERY_DEFINITION;
      return this;
    }

    /**
     * Initializes the value for the {@link Partition#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    @JacksonXmlProperty(localName = "Type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Partition#getDataSourceId() dataSourceId} attribute.
     * @param dataSourceId The value for dataSourceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dataSourceId")
    @JacksonXmlProperty(localName = "DataSourceID")
    public final Builder dataSourceId(@Nullable String dataSourceId) {
      this.dataSourceId = dataSourceId;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePartition ImmutablePartition}.
     * @return An immutable instance of Partition
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePartition build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePartition(queryDefinition, type, dataSourceId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_QUERY_DEFINITION) != 0) attributes.add("queryDefinition");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build Partition, some of required attributes are not set " + attributes;
    }
  }
}
