package zeenea.connector.sqlserver.services.ssas.client.model.tabular;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Column}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableColumn.builder()}.
 */
@Generated(from = "Column", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableColumn
    implements Column {
  private final String iD;
  private final String tableID;
  private final String explicitName;
  private final @Nullable String description;
  private final String explicitDataType;
  private final boolean hidden;
  private final boolean unique;
  private final boolean key;
  private final boolean nullable;
  private final Long type;
  private final String modifiedTime;
  private final String structureModifiedTime;

  private ImmutableColumn(
      String iD,
      String tableID,
      String explicitName,
      @Nullable String description,
      String explicitDataType,
      boolean hidden,
      boolean unique,
      boolean key,
      boolean nullable,
      Long type,
      String modifiedTime,
      String structureModifiedTime) {
    this.iD = iD;
    this.tableID = tableID;
    this.explicitName = explicitName;
    this.description = description;
    this.explicitDataType = explicitDataType;
    this.hidden = hidden;
    this.unique = unique;
    this.key = key;
    this.nullable = nullable;
    this.type = type;
    this.modifiedTime = modifiedTime;
    this.structureModifiedTime = structureModifiedTime;
  }

  /**
   * @return The value of the {@code iD} attribute
   */
  @JsonProperty("iD")
  @JacksonXmlProperty(localName = "ID")
  @Override
  public String getID() {
    return iD;
  }

  /**
   * @return The value of the {@code tableID} attribute
   */
  @JsonProperty("tableID")
  @JacksonXmlProperty(localName = "TableID")
  @Override
  public String getTableID() {
    return tableID;
  }

  /**
   * @return The value of the {@code explicitName} attribute
   */
  @JsonProperty("explicitName")
  @JacksonXmlProperty(localName = "ExplicitName")
  @Override
  public String getExplicitName() {
    return explicitName;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @JacksonXmlProperty(localName = "Description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code explicitDataType} attribute
   */
  @JsonProperty("explicitDataType")
  @JacksonXmlProperty(localName = "ExplicitDataType")
  @Override
  public String getExplicitDataType() {
    return explicitDataType;
  }

  /**
   * @return The value of the {@code hidden} attribute
   */
  @JsonProperty("hidden")
  @JacksonXmlProperty(localName = "IsHidden")
  @Override
  public boolean isHidden() {
    return hidden;
  }

  /**
   * @return The value of the {@code unique} attribute
   */
  @JsonProperty("unique")
  @JacksonXmlProperty(localName = "IsUnique")
  @Override
  public boolean isUnique() {
    return unique;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @JsonProperty("key")
  @JacksonXmlProperty(localName = "IsKey")
  @Override
  public boolean isKey() {
    return key;
  }

  /**
   * @return The value of the {@code nullable} attribute
   */
  @JsonProperty("nullable")
  @JacksonXmlProperty(localName = "IsNullable")
  @Override
  public boolean isNullable() {
    return nullable;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @JacksonXmlProperty(localName = "Type")
  @Override
  public Long getType() {
    return type;
  }

  /**
   * @return The value of the {@code modifiedTime} attribute
   */
  @JsonProperty("modifiedTime")
  @JacksonXmlProperty(localName = "ModifiedTime")
  @Override
  public String getModifiedTime() {
    return modifiedTime;
  }

  /**
   * @return The value of the {@code structureModifiedTime} attribute
   */
  @JsonProperty("structureModifiedTime")
  @JacksonXmlProperty(localName = "StructureModifiedTime")
  @Override
  public String getStructureModifiedTime() {
    return structureModifiedTime;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getID() iD} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for iD
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withID(String value) {
    String newValue = Objects.requireNonNull(value, "iD");
    if (this.iD.equals(newValue)) return this;
    return new ImmutableColumn(
        newValue,
        this.tableID,
        this.explicitName,
        this.description,
        this.explicitDataType,
        this.hidden,
        this.unique,
        this.key,
        this.nullable,
        this.type,
        this.modifiedTime,
        this.structureModifiedTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getTableID() tableID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tableID
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withTableID(String value) {
    String newValue = Objects.requireNonNull(value, "tableID");
    if (this.tableID.equals(newValue)) return this;
    return new ImmutableColumn(
        this.iD,
        newValue,
        this.explicitName,
        this.description,
        this.explicitDataType,
        this.hidden,
        this.unique,
        this.key,
        this.nullable,
        this.type,
        this.modifiedTime,
        this.structureModifiedTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getExplicitName() explicitName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for explicitName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withExplicitName(String value) {
    String newValue = Objects.requireNonNull(value, "explicitName");
    if (this.explicitName.equals(newValue)) return this;
    return new ImmutableColumn(
        this.iD,
        this.tableID,
        newValue,
        this.description,
        this.explicitDataType,
        this.hidden,
        this.unique,
        this.key,
        this.nullable,
        this.type,
        this.modifiedTime,
        this.structureModifiedTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableColumn(
        this.iD,
        this.tableID,
        this.explicitName,
        value,
        this.explicitDataType,
        this.hidden,
        this.unique,
        this.key,
        this.nullable,
        this.type,
        this.modifiedTime,
        this.structureModifiedTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getExplicitDataType() explicitDataType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for explicitDataType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withExplicitDataType(String value) {
    String newValue = Objects.requireNonNull(value, "explicitDataType");
    if (this.explicitDataType.equals(newValue)) return this;
    return new ImmutableColumn(
        this.iD,
        this.tableID,
        this.explicitName,
        this.description,
        newValue,
        this.hidden,
        this.unique,
        this.key,
        this.nullable,
        this.type,
        this.modifiedTime,
        this.structureModifiedTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#isHidden() hidden} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hidden
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withHidden(boolean value) {
    if (this.hidden == value) return this;
    return new ImmutableColumn(
        this.iD,
        this.tableID,
        this.explicitName,
        this.description,
        this.explicitDataType,
        value,
        this.unique,
        this.key,
        this.nullable,
        this.type,
        this.modifiedTime,
        this.structureModifiedTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#isUnique() unique} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for unique
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withUnique(boolean value) {
    if (this.unique == value) return this;
    return new ImmutableColumn(
        this.iD,
        this.tableID,
        this.explicitName,
        this.description,
        this.explicitDataType,
        this.hidden,
        value,
        this.key,
        this.nullable,
        this.type,
        this.modifiedTime,
        this.structureModifiedTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#isKey() key} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withKey(boolean value) {
    if (this.key == value) return this;
    return new ImmutableColumn(
        this.iD,
        this.tableID,
        this.explicitName,
        this.description,
        this.explicitDataType,
        this.hidden,
        this.unique,
        value,
        this.nullable,
        this.type,
        this.modifiedTime,
        this.structureModifiedTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#isNullable() nullable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withNullable(boolean value) {
    if (this.nullable == value) return this;
    return new ImmutableColumn(
        this.iD,
        this.tableID,
        this.explicitName,
        this.description,
        this.explicitDataType,
        this.hidden,
        this.unique,
        this.key,
        value,
        this.type,
        this.modifiedTime,
        this.structureModifiedTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withType(Long value) {
    Long newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableColumn(
        this.iD,
        this.tableID,
        this.explicitName,
        this.description,
        this.explicitDataType,
        this.hidden,
        this.unique,
        this.key,
        this.nullable,
        newValue,
        this.modifiedTime,
        this.structureModifiedTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getModifiedTime() modifiedTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modifiedTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withModifiedTime(String value) {
    String newValue = Objects.requireNonNull(value, "modifiedTime");
    if (this.modifiedTime.equals(newValue)) return this;
    return new ImmutableColumn(
        this.iD,
        this.tableID,
        this.explicitName,
        this.description,
        this.explicitDataType,
        this.hidden,
        this.unique,
        this.key,
        this.nullable,
        this.type,
        newValue,
        this.structureModifiedTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getStructureModifiedTime() structureModifiedTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for structureModifiedTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withStructureModifiedTime(String value) {
    String newValue = Objects.requireNonNull(value, "structureModifiedTime");
    if (this.structureModifiedTime.equals(newValue)) return this;
    return new ImmutableColumn(
        this.iD,
        this.tableID,
        this.explicitName,
        this.description,
        this.explicitDataType,
        this.hidden,
        this.unique,
        this.key,
        this.nullable,
        this.type,
        this.modifiedTime,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableColumn} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableColumn
        && equalTo(0, (ImmutableColumn) another);
  }

  private boolean equalTo(int synthetic, ImmutableColumn another) {
    return iD.equals(another.iD)
        && tableID.equals(another.tableID)
        && explicitName.equals(another.explicitName)
        && Objects.equals(description, another.description)
        && explicitDataType.equals(another.explicitDataType)
        && hidden == another.hidden
        && unique == another.unique
        && key == another.key
        && nullable == another.nullable
        && type.equals(another.type)
        && modifiedTime.equals(another.modifiedTime)
        && structureModifiedTime.equals(another.structureModifiedTime);
  }

  /**
   * Computes a hash code from attributes: {@code iD}, {@code tableID}, {@code explicitName}, {@code description}, {@code explicitDataType}, {@code hidden}, {@code unique}, {@code key}, {@code nullable}, {@code type}, {@code modifiedTime}, {@code structureModifiedTime}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + iD.hashCode();
    h += (h << 5) + tableID.hashCode();
    h += (h << 5) + explicitName.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + explicitDataType.hashCode();
    h += (h << 5) + Boolean.hashCode(hidden);
    h += (h << 5) + Boolean.hashCode(unique);
    h += (h << 5) + Boolean.hashCode(key);
    h += (h << 5) + Boolean.hashCode(nullable);
    h += (h << 5) + type.hashCode();
    h += (h << 5) + modifiedTime.hashCode();
    h += (h << 5) + structureModifiedTime.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Column} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Column{"
        + "iD=" + iD
        + ", tableID=" + tableID
        + ", explicitName=" + explicitName
        + ", description=" + description
        + ", explicitDataType=" + explicitDataType
        + ", hidden=" + hidden
        + ", unique=" + unique
        + ", key=" + key
        + ", nullable=" + nullable
        + ", type=" + type
        + ", modifiedTime=" + modifiedTime
        + ", structureModifiedTime=" + structureModifiedTime
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Column", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Column {
    String iD;
    String tableID;
    String explicitName;
    String description;
    String explicitDataType;
    boolean hidden;
    boolean hiddenIsSet;
    boolean unique;
    boolean uniqueIsSet;
    boolean key;
    boolean keyIsSet;
    boolean nullable;
    boolean nullableIsSet;
    Long type;
    String modifiedTime;
    String structureModifiedTime;
    @JsonProperty("iD")
    @JacksonXmlProperty(localName = "ID")
    public void setID(String iD) {
      this.iD = iD;
    }
    @JsonProperty("tableID")
    @JacksonXmlProperty(localName = "TableID")
    public void setTableID(String tableID) {
      this.tableID = tableID;
    }
    @JsonProperty("explicitName")
    @JacksonXmlProperty(localName = "ExplicitName")
    public void setExplicitName(String explicitName) {
      this.explicitName = explicitName;
    }
    @JsonProperty("description")
    @JacksonXmlProperty(localName = "Description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("explicitDataType")
    @JacksonXmlProperty(localName = "ExplicitDataType")
    public void setExplicitDataType(String explicitDataType) {
      this.explicitDataType = explicitDataType;
    }
    @JsonProperty("hidden")
    @JacksonXmlProperty(localName = "IsHidden")
    public void setHidden(boolean hidden) {
      this.hidden = hidden;
      this.hiddenIsSet = true;
    }
    @JsonProperty("unique")
    @JacksonXmlProperty(localName = "IsUnique")
    public void setUnique(boolean unique) {
      this.unique = unique;
      this.uniqueIsSet = true;
    }
    @JsonProperty("key")
    @JacksonXmlProperty(localName = "IsKey")
    public void setKey(boolean key) {
      this.key = key;
      this.keyIsSet = true;
    }
    @JsonProperty("nullable")
    @JacksonXmlProperty(localName = "IsNullable")
    public void setNullable(boolean nullable) {
      this.nullable = nullable;
      this.nullableIsSet = true;
    }
    @JsonProperty("type")
    @JacksonXmlProperty(localName = "Type")
    public void setType(Long type) {
      this.type = type;
    }
    @JsonProperty("modifiedTime")
    @JacksonXmlProperty(localName = "ModifiedTime")
    public void setModifiedTime(String modifiedTime) {
      this.modifiedTime = modifiedTime;
    }
    @JsonProperty("structureModifiedTime")
    @JacksonXmlProperty(localName = "StructureModifiedTime")
    public void setStructureModifiedTime(String structureModifiedTime) {
      this.structureModifiedTime = structureModifiedTime;
    }
    @Override
    public String getID() { throw new UnsupportedOperationException(); }
    @Override
    public String getTableID() { throw new UnsupportedOperationException(); }
    @Override
    public String getExplicitName() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getExplicitDataType() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isHidden() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isUnique() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isKey() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isNullable() { throw new UnsupportedOperationException(); }
    @Override
    public Long getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getModifiedTime() { throw new UnsupportedOperationException(); }
    @Override
    public String getStructureModifiedTime() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableColumn fromJson(Json json) {
    ImmutableColumn.Builder builder = ImmutableColumn.builder();
    if (json.iD != null) {
      builder.iD(json.iD);
    }
    if (json.tableID != null) {
      builder.tableID(json.tableID);
    }
    if (json.explicitName != null) {
      builder.explicitName(json.explicitName);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.explicitDataType != null) {
      builder.explicitDataType(json.explicitDataType);
    }
    if (json.hiddenIsSet) {
      builder.hidden(json.hidden);
    }
    if (json.uniqueIsSet) {
      builder.unique(json.unique);
    }
    if (json.keyIsSet) {
      builder.key(json.key);
    }
    if (json.nullableIsSet) {
      builder.nullable(json.nullable);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.modifiedTime != null) {
      builder.modifiedTime(json.modifiedTime);
    }
    if (json.structureModifiedTime != null) {
      builder.structureModifiedTime(json.structureModifiedTime);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Column} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Column instance
   */
  public static ImmutableColumn copyOf(Column instance) {
    if (instance instanceof ImmutableColumn) {
      return (ImmutableColumn) instance;
    }
    return ImmutableColumn.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableColumn ImmutableColumn}.
   * <pre>
   * ImmutableColumn.builder()
   *    .iD(String) // required {@link Column#getID() iD}
   *    .tableID(String) // required {@link Column#getTableID() tableID}
   *    .explicitName(String) // required {@link Column#getExplicitName() explicitName}
   *    .description(String | null) // nullable {@link Column#getDescription() description}
   *    .explicitDataType(String) // required {@link Column#getExplicitDataType() explicitDataType}
   *    .hidden(boolean) // required {@link Column#isHidden() hidden}
   *    .unique(boolean) // required {@link Column#isUnique() unique}
   *    .key(boolean) // required {@link Column#isKey() key}
   *    .nullable(boolean) // required {@link Column#isNullable() nullable}
   *    .type(Long) // required {@link Column#getType() type}
   *    .modifiedTime(String) // required {@link Column#getModifiedTime() modifiedTime}
   *    .structureModifiedTime(String) // required {@link Column#getStructureModifiedTime() structureModifiedTime}
   *    .build();
   * </pre>
   * @return A new ImmutableColumn builder
   */
  public static ImmutableColumn.Builder builder() {
    return new ImmutableColumn.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableColumn ImmutableColumn}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Column", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_I_D = 0x1L;
    private static final long INIT_BIT_TABLE_I_D = 0x2L;
    private static final long INIT_BIT_EXPLICIT_NAME = 0x4L;
    private static final long INIT_BIT_EXPLICIT_DATA_TYPE = 0x8L;
    private static final long INIT_BIT_HIDDEN = 0x10L;
    private static final long INIT_BIT_UNIQUE = 0x20L;
    private static final long INIT_BIT_KEY = 0x40L;
    private static final long INIT_BIT_NULLABLE = 0x80L;
    private static final long INIT_BIT_TYPE = 0x100L;
    private static final long INIT_BIT_MODIFIED_TIME = 0x200L;
    private static final long INIT_BIT_STRUCTURE_MODIFIED_TIME = 0x400L;
    private long initBits = 0x7ffL;

    private String iD;
    private String tableID;
    private String explicitName;
    private String description;
    private String explicitDataType;
    private boolean hidden;
    private boolean unique;
    private boolean key;
    private boolean nullable;
    private Long type;
    private String modifiedTime;
    private String structureModifiedTime;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Column} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Column instance) {
      Objects.requireNonNull(instance, "instance");
      this.iD(instance.getID());
      this.tableID(instance.getTableID());
      this.explicitName(instance.getExplicitName());
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      this.explicitDataType(instance.getExplicitDataType());
      this.hidden(instance.isHidden());
      this.unique(instance.isUnique());
      this.key(instance.isKey());
      this.nullable(instance.isNullable());
      this.type(instance.getType());
      this.modifiedTime(instance.getModifiedTime());
      this.structureModifiedTime(instance.getStructureModifiedTime());
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getID() iD} attribute.
     * @param iD The value for iD 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("iD")
    @JacksonXmlProperty(localName = "ID")
    public final Builder iD(String iD) {
      this.iD = Objects.requireNonNull(iD, "iD");
      initBits &= ~INIT_BIT_I_D;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getTableID() tableID} attribute.
     * @param tableID The value for tableID 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tableID")
    @JacksonXmlProperty(localName = "TableID")
    public final Builder tableID(String tableID) {
      this.tableID = Objects.requireNonNull(tableID, "tableID");
      initBits &= ~INIT_BIT_TABLE_I_D;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getExplicitName() explicitName} attribute.
     * @param explicitName The value for explicitName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("explicitName")
    @JacksonXmlProperty(localName = "ExplicitName")
    public final Builder explicitName(String explicitName) {
      this.explicitName = Objects.requireNonNull(explicitName, "explicitName");
      initBits &= ~INIT_BIT_EXPLICIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    @JacksonXmlProperty(localName = "Description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getExplicitDataType() explicitDataType} attribute.
     * @param explicitDataType The value for explicitDataType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("explicitDataType")
    @JacksonXmlProperty(localName = "ExplicitDataType")
    public final Builder explicitDataType(String explicitDataType) {
      this.explicitDataType = Objects.requireNonNull(explicitDataType, "explicitDataType");
      initBits &= ~INIT_BIT_EXPLICIT_DATA_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#isHidden() hidden} attribute.
     * @param hidden The value for hidden 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("hidden")
    @JacksonXmlProperty(localName = "IsHidden")
    public final Builder hidden(boolean hidden) {
      this.hidden = hidden;
      initBits &= ~INIT_BIT_HIDDEN;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#isUnique() unique} attribute.
     * @param unique The value for unique 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("unique")
    @JacksonXmlProperty(localName = "IsUnique")
    public final Builder unique(boolean unique) {
      this.unique = unique;
      initBits &= ~INIT_BIT_UNIQUE;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#isKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("key")
    @JacksonXmlProperty(localName = "IsKey")
    public final Builder key(boolean key) {
      this.key = key;
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#isNullable() nullable} attribute.
     * @param nullable The value for nullable 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nullable")
    @JacksonXmlProperty(localName = "IsNullable")
    public final Builder nullable(boolean nullable) {
      this.nullable = nullable;
      initBits &= ~INIT_BIT_NULLABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    @JacksonXmlProperty(localName = "Type")
    public final Builder type(Long type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getModifiedTime() modifiedTime} attribute.
     * @param modifiedTime The value for modifiedTime 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("modifiedTime")
    @JacksonXmlProperty(localName = "ModifiedTime")
    public final Builder modifiedTime(String modifiedTime) {
      this.modifiedTime = Objects.requireNonNull(modifiedTime, "modifiedTime");
      initBits &= ~INIT_BIT_MODIFIED_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getStructureModifiedTime() structureModifiedTime} attribute.
     * @param structureModifiedTime The value for structureModifiedTime 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("structureModifiedTime")
    @JacksonXmlProperty(localName = "StructureModifiedTime")
    public final Builder structureModifiedTime(String structureModifiedTime) {
      this.structureModifiedTime = Objects.requireNonNull(structureModifiedTime, "structureModifiedTime");
      initBits &= ~INIT_BIT_STRUCTURE_MODIFIED_TIME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableColumn ImmutableColumn}.
     * @return An immutable instance of Column
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableColumn build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableColumn(
          iD,
          tableID,
          explicitName,
          description,
          explicitDataType,
          hidden,
          unique,
          key,
          nullable,
          type,
          modifiedTime,
          structureModifiedTime);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_I_D) != 0) attributes.add("iD");
      if ((initBits & INIT_BIT_TABLE_I_D) != 0) attributes.add("tableID");
      if ((initBits & INIT_BIT_EXPLICIT_NAME) != 0) attributes.add("explicitName");
      if ((initBits & INIT_BIT_EXPLICIT_DATA_TYPE) != 0) attributes.add("explicitDataType");
      if ((initBits & INIT_BIT_HIDDEN) != 0) attributes.add("hidden");
      if ((initBits & INIT_BIT_UNIQUE) != 0) attributes.add("unique");
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_NULLABLE) != 0) attributes.add("nullable");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_MODIFIED_TIME) != 0) attributes.add("modifiedTime");
      if ((initBits & INIT_BIT_STRUCTURE_MODIFIED_TIME) != 0) attributes.add("structureModifiedTime");
      return "Cannot build Column, some of required attributes are not set " + attributes;
    }
  }
}
