package zeenea.connector.sqlserver.services.ssas.client.model.tabular;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Address}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAddress.builder()}.
 */
@Generated(from = "Address", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableAddress
    implements Address {
  private final String server;
  private final String database;

  private ImmutableAddress(String server, String database) {
    this.server = server;
    this.database = database;
  }

  /**
   * @return The value of the {@code server} attribute
   */
  @JsonProperty("server")
  @Override
  public String getServer() {
    return server;
  }

  /**
   * @return The value of the {@code database} attribute
   */
  @JsonProperty("database")
  @Override
  public String getDatabase() {
    return database;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Address#getServer() server} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for server
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAddress withServer(String value) {
    String newValue = Objects.requireNonNull(value, "server");
    if (this.server.equals(newValue)) return this;
    return new ImmutableAddress(newValue, this.database);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Address#getDatabase() database} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for database
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAddress withDatabase(String value) {
    String newValue = Objects.requireNonNull(value, "database");
    if (this.database.equals(newValue)) return this;
    return new ImmutableAddress(this.server, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAddress} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAddress
        && equalTo(0, (ImmutableAddress) another);
  }

  private boolean equalTo(int synthetic, ImmutableAddress another) {
    return server.equals(another.server)
        && database.equals(another.database);
  }

  /**
   * Computes a hash code from attributes: {@code server}, {@code database}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + server.hashCode();
    h += (h << 5) + database.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Address} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Address{"
        + "server=" + server
        + ", database=" + database
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Address} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Address instance
   */
  public static ImmutableAddress copyOf(Address instance) {
    if (instance instanceof ImmutableAddress) {
      return (ImmutableAddress) instance;
    }
    return ImmutableAddress.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAddress ImmutableAddress}.
   * <pre>
   * ImmutableAddress.builder()
   *    .server(String) // required {@link Address#getServer() server}
   *    .database(String) // required {@link Address#getDatabase() database}
   *    .build();
   * </pre>
   * @return A new ImmutableAddress builder
   */
  public static ImmutableAddress.Builder builder() {
    return new ImmutableAddress.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAddress ImmutableAddress}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Address", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVER = 0x1L;
    private static final long INIT_BIT_DATABASE = 0x2L;
    private long initBits = 0x3L;

    private String server;
    private String database;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Address} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Address instance) {
      Objects.requireNonNull(instance, "instance");
      this.server(instance.getServer());
      this.database(instance.getDatabase());
      return this;
    }

    /**
     * Initializes the value for the {@link Address#getServer() server} attribute.
     * @param server The value for server 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("server")
    public final Builder server(String server) {
      this.server = Objects.requireNonNull(server, "server");
      initBits &= ~INIT_BIT_SERVER;
      return this;
    }

    /**
     * Initializes the value for the {@link Address#getDatabase() database} attribute.
     * @param database The value for database 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("database")
    public final Builder database(String database) {
      this.database = Objects.requireNonNull(database, "database");
      initBits &= ~INIT_BIT_DATABASE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAddress ImmutableAddress}.
     * @return An immutable instance of Address
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAddress build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAddress(server, database);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVER) != 0) attributes.add("server");
      if ((initBits & INIT_BIT_DATABASE) != 0) attributes.add("database");
      return "Cannot build Address, some of required attributes are not set " + attributes;
    }
  }
}
