package zeenea.connector.sqlserver.services.ssas.client.model.multidimensional;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Schema}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSchema.builder()}.
 */
@Generated(from = "Schema", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableSchema
    implements Schema {
  private final @Nullable JsonNode schema;

  private ImmutableSchema(@Nullable JsonNode schema) {
    this.schema = schema;
  }

  /**
   * @return The value of the {@code schema} attribute
   */
  @JsonProperty("schema")
  @JacksonXmlProperty(localName = "schema", namespace = "xs")
  @Override
  public @Nullable JsonNode getSchema() {
    return schema;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Schema#getSchema() schema} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schema (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSchema withSchema(@Nullable JsonNode value) {
    if (this.schema == value) return this;
    return new ImmutableSchema(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSchema} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSchema
        && equalTo(0, (ImmutableSchema) another);
  }

  private boolean equalTo(int synthetic, ImmutableSchema another) {
    return Objects.equals(schema, another.schema);
  }

  /**
   * Computes a hash code from attributes: {@code schema}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(schema);
    return h;
  }

  /**
   * Prints the immutable value {@code Schema} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Schema{"
        + "schema=" + schema
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Schema", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements Schema {
    JsonNode schema;
    @JsonProperty("schema")
    @JacksonXmlProperty(localName = "schema", namespace = "xs")
    public void setSchema(@Nullable JsonNode schema) {
      this.schema = schema;
    }
    @Override
    public JsonNode getSchema() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSchema fromJson(Json json) {
    ImmutableSchema.Builder builder = ImmutableSchema.builder();
    if (json.schema != null) {
      builder.schema(json.schema);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Schema} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Schema instance
   */
  public static ImmutableSchema copyOf(Schema instance) {
    if (instance instanceof ImmutableSchema) {
      return (ImmutableSchema) instance;
    }
    return ImmutableSchema.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSchema ImmutableSchema}.
   * <pre>
   * ImmutableSchema.builder()
   *    .schema(com.fasterxml.jackson.databind.JsonNode | null) // nullable {@link Schema#getSchema() schema}
   *    .build();
   * </pre>
   * @return A new ImmutableSchema builder
   */
  public static ImmutableSchema.Builder builder() {
    return new ImmutableSchema.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSchema ImmutableSchema}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Schema", generator = "Immutables")
  public static final class Builder {
    private JsonNode schema;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Schema} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Schema instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable JsonNode schemaValue = instance.getSchema();
      if (schemaValue != null) {
        schema(schemaValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Schema#getSchema() schema} attribute.
     * @param schema The value for schema (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schema")
    @JacksonXmlProperty(localName = "schema", namespace = "xs")
    public final Builder schema(@Nullable JsonNode schema) {
      this.schema = schema;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSchema ImmutableSchema}.
     * @return An immutable instance of Schema
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSchema build() {
      return new ImmutableSchema(schema);
    }
  }
}
