package zeenea.connector.sqlserver.services.ssas.client.model.multidimensional;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link ProjectCtx}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProjectCtx.builder()}.
 */
@Generated(from = "ProjectCtx", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableProjectCtx
    implements ProjectCtx {
  @NotNull
  private final Path path;

  private ImmutableProjectCtx(Path path) {
    this.path = path;
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @JsonProperty("path")
  @NotNull
  @Override
  public Path getPath() {
    return path;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProjectCtx#getPath() path} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProjectCtx withPath(Path value) {
    if (this.path == value) return this;
    Path newValue = Objects.requireNonNull(value, "path");
    return new ImmutableProjectCtx(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProjectCtx} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProjectCtx
        && equalTo(0, (ImmutableProjectCtx) another);
  }

  private boolean equalTo(int synthetic, ImmutableProjectCtx another) {
    return path.equals(another.path);
  }

  /**
   * Computes a hash code from attributes: {@code path}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + path.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProjectCtx} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProjectCtx{"
        + "path=" + path
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ProjectCtx", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ProjectCtx {
    Path path;
    @JsonProperty("path")
    public void setPath(Path path) {
      this.path = path;
    }
    @Override
    public Path getPath() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableProjectCtx fromJson(Json json) {
    ImmutableProjectCtx.Builder builder = ImmutableProjectCtx.builder();
    if (json.path != null) {
      builder.path(json.path);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ProjectCtx} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProjectCtx instance
   */
  public static ImmutableProjectCtx copyOf(ProjectCtx instance) {
    if (instance instanceof ImmutableProjectCtx) {
      return (ImmutableProjectCtx) instance;
    }
    return ImmutableProjectCtx.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProjectCtx ImmutableProjectCtx}.
   * <pre>
   * ImmutableProjectCtx.builder()
   *    .path(java.nio.file.Path) // required {@link ProjectCtx#getPath() path}
   *    .build();
   * </pre>
   * @return A new ImmutableProjectCtx builder
   */
  public static ImmutableProjectCtx.Builder builder() {
    return new ImmutableProjectCtx.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProjectCtx ImmutableProjectCtx}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProjectCtx", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PATH = 0x1L;
    private long initBits = 0x1L;

    private Path path;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProjectCtx} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProjectCtx instance) {
      Objects.requireNonNull(instance, "instance");
      this.path(instance.getPath());
      return this;
    }

    /**
     * Initializes the value for the {@link ProjectCtx#getPath() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("path")
    public final Builder path(Path path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProjectCtx ImmutableProjectCtx}.
     * @return An immutable instance of ProjectCtx
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProjectCtx build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProjectCtx(path);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      return "Cannot build ProjectCtx, some of required attributes are not set " + attributes;
    }
  }
}
