package zeenea.connector.sqlserver.services.ssas.client.model.multidimensional;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link MeasureGroup}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMeasureGroup.builder()}.
 */
@Generated(from = "MeasureGroup", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMeasureGroup
    implements MeasureGroup {
  private final @Nullable String id;
  private final @Nullable String name;
  private final @Nullable String createdDate;
  private final @Nullable String updatedDate;
  private final @Nullable String state;
  private final @Nullable List<Measure> measures;
  private final @Nullable List<Dimension> dimensions;
  private final @Nullable Source source;

  private ImmutableMeasureGroup(
      @Nullable String id,
      @Nullable String name,
      @Nullable String createdDate,
      @Nullable String updatedDate,
      @Nullable String state,
      @Nullable List<Measure> measures,
      @Nullable List<Dimension> dimensions,
      @Nullable Source source) {
    this.id = id;
    this.name = name;
    this.createdDate = createdDate;
    this.updatedDate = updatedDate;
    this.state = state;
    this.measures = measures;
    this.dimensions = dimensions;
    this.source = source;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JacksonXmlProperty(localName = "ID")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JacksonXmlProperty(localName = "Name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code createdDate} attribute
   */
  @JsonProperty("createdDate")
  @JacksonXmlProperty(localName = "CreatedTimestamp")
  @Override
  public @Nullable String getCreatedDate() {
    return createdDate;
  }

  /**
   * @return The value of the {@code updatedDate} attribute
   */
  @JsonProperty("updatedDate")
  @JacksonXmlProperty(localName = "LastSchemaUpdate")
  @Override
  public @Nullable String getUpdatedDate() {
    return updatedDate;
  }

  /**
   * @return The value of the {@code state} attribute
   */
  @JsonProperty("state")
  @JacksonXmlProperty(localName = "State")
  @Override
  public @Nullable String getState() {
    return state;
  }

  /**
   * @return The value of the {@code measures} attribute
   */
  @JsonProperty("measures")
  @JacksonXmlElementWrapper(useWrapping = true)
  @JacksonXmlProperty(localName = "Measures")
  @Override
  public @Nullable List<Measure> getMeasures() {
    return measures;
  }

  /**
   * @return The value of the {@code dimensions} attribute
   */
  @JsonProperty("dimensions")
  @JacksonXmlElementWrapper(useWrapping = true)
  @JacksonXmlProperty(localName = "Dimensions")
  @Override
  public @Nullable List<Dimension> getDimensions() {
    return dimensions;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("source")
  @JacksonXmlProperty(localName = "Source")
  @Override
  public @Nullable Source getSource() {
    return source;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MeasureGroup#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMeasureGroup withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableMeasureGroup(
        value,
        this.name,
        this.createdDate,
        this.updatedDate,
        this.state,
        this.measures,
        this.dimensions,
        this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MeasureGroup#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMeasureGroup withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableMeasureGroup(
        this.id,
        value,
        this.createdDate,
        this.updatedDate,
        this.state,
        this.measures,
        this.dimensions,
        this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MeasureGroup#getCreatedDate() createdDate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdDate (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMeasureGroup withCreatedDate(@Nullable String value) {
    if (Objects.equals(this.createdDate, value)) return this;
    return new ImmutableMeasureGroup(
        this.id,
        this.name,
        value,
        this.updatedDate,
        this.state,
        this.measures,
        this.dimensions,
        this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MeasureGroup#getUpdatedDate() updatedDate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedDate (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMeasureGroup withUpdatedDate(@Nullable String value) {
    if (Objects.equals(this.updatedDate, value)) return this;
    return new ImmutableMeasureGroup(
        this.id,
        this.name,
        this.createdDate,
        value,
        this.state,
        this.measures,
        this.dimensions,
        this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MeasureGroup#getState() state} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMeasureGroup withState(@Nullable String value) {
    if (Objects.equals(this.state, value)) return this;
    return new ImmutableMeasureGroup(
        this.id,
        this.name,
        this.createdDate,
        this.updatedDate,
        value,
        this.measures,
        this.dimensions,
        this.source);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MeasureGroup#getMeasures() measures}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMeasureGroup withMeasures(@Nullable Measure... elements) {
    if (elements == null) {
      return new ImmutableMeasureGroup(
          this.id,
          this.name,
          this.createdDate,
          this.updatedDate,
          this.state,
          null,
          this.dimensions,
          this.source);
    }
    List<Measure> newValue = List.of(elements);
    return new ImmutableMeasureGroup(
        this.id,
        this.name,
        this.createdDate,
        this.updatedDate,
        this.state,
        newValue,
        this.dimensions,
        this.source);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MeasureGroup#getMeasures() measures}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of measures elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMeasureGroup withMeasures(@Nullable Iterable<? extends Measure> elements) {
    if (this.measures == elements) return this;
    @Nullable List<Measure> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Measure>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableMeasureGroup(
        this.id,
        this.name,
        this.createdDate,
        this.updatedDate,
        this.state,
        newValue,
        this.dimensions,
        this.source);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MeasureGroup#getDimensions() dimensions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMeasureGroup withDimensions(@Nullable Dimension... elements) {
    if (elements == null) {
      return new ImmutableMeasureGroup(
          this.id,
          this.name,
          this.createdDate,
          this.updatedDate,
          this.state,
          this.measures,
          null,
          this.source);
    }
    List<Dimension> newValue = List.of(elements);
    return new ImmutableMeasureGroup(
        this.id,
        this.name,
        this.createdDate,
        this.updatedDate,
        this.state,
        this.measures,
        newValue,
        this.source);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MeasureGroup#getDimensions() dimensions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dimensions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMeasureGroup withDimensions(@Nullable Iterable<? extends Dimension> elements) {
    if (this.dimensions == elements) return this;
    @Nullable List<Dimension> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Dimension>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableMeasureGroup(
        this.id,
        this.name,
        this.createdDate,
        this.updatedDate,
        this.state,
        this.measures,
        newValue,
        this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MeasureGroup#getSource() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMeasureGroup withSource(@Nullable Source value) {
    if (this.source == value) return this;
    return new ImmutableMeasureGroup(
        this.id,
        this.name,
        this.createdDate,
        this.updatedDate,
        this.state,
        this.measures,
        this.dimensions,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMeasureGroup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMeasureGroup
        && equalTo(0, (ImmutableMeasureGroup) another);
  }

  private boolean equalTo(int synthetic, ImmutableMeasureGroup another) {
    return Objects.equals(id, another.id)
        && Objects.equals(name, another.name)
        && Objects.equals(createdDate, another.createdDate)
        && Objects.equals(updatedDate, another.updatedDate)
        && Objects.equals(state, another.state)
        && Objects.equals(measures, another.measures)
        && Objects.equals(dimensions, another.dimensions)
        && Objects.equals(source, another.source);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code createdDate}, {@code updatedDate}, {@code state}, {@code measures}, {@code dimensions}, {@code source}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(createdDate);
    h += (h << 5) + Objects.hashCode(updatedDate);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(measures);
    h += (h << 5) + Objects.hashCode(dimensions);
    h += (h << 5) + Objects.hashCode(source);
    return h;
  }

  /**
   * Prints the immutable value {@code MeasureGroup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MeasureGroup{"
        + "id=" + id
        + ", name=" + name
        + ", createdDate=" + createdDate
        + ", updatedDate=" + updatedDate
        + ", state=" + state
        + ", measures=" + measures
        + ", dimensions=" + dimensions
        + ", source=" + source
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "MeasureGroup", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements MeasureGroup {
    String id;
    String name;
    String createdDate;
    String updatedDate;
    String state;
    List<Measure> measures = null;
    List<Dimension> dimensions = null;
    Source source;
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("createdDate")
    @JacksonXmlProperty(localName = "CreatedTimestamp")
    public void setCreatedDate(@Nullable String createdDate) {
      this.createdDate = createdDate;
    }
    @JsonProperty("updatedDate")
    @JacksonXmlProperty(localName = "LastSchemaUpdate")
    public void setUpdatedDate(@Nullable String updatedDate) {
      this.updatedDate = updatedDate;
    }
    @JsonProperty("state")
    @JacksonXmlProperty(localName = "State")
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty("measures")
    @JacksonXmlElementWrapper(useWrapping = true)
    @JacksonXmlProperty(localName = "Measures")
    public void setMeasures(@Nullable List<Measure> measures) {
      this.measures = measures;
    }
    @JsonProperty("dimensions")
    @JacksonXmlElementWrapper(useWrapping = true)
    @JacksonXmlProperty(localName = "Dimensions")
    public void setDimensions(@Nullable List<Dimension> dimensions) {
      this.dimensions = dimensions;
    }
    @JsonProperty("source")
    @JacksonXmlProperty(localName = "Source")
    public void setSource(@Nullable Source source) {
      this.source = source;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatedDate() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedDate() { throw new UnsupportedOperationException(); }
    @Override
    public String getState() { throw new UnsupportedOperationException(); }
    @Override
    public List<Measure> getMeasures() { throw new UnsupportedOperationException(); }
    @Override
    public List<Dimension> getDimensions() { throw new UnsupportedOperationException(); }
    @Override
    public Source getSource() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMeasureGroup fromJson(Json json) {
    ImmutableMeasureGroup.Builder builder = ImmutableMeasureGroup.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.createdDate != null) {
      builder.createdDate(json.createdDate);
    }
    if (json.updatedDate != null) {
      builder.updatedDate(json.updatedDate);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.measures != null) {
      builder.addAllMeasures(json.measures);
    }
    if (json.dimensions != null) {
      builder.addAllDimensions(json.dimensions);
    }
    if (json.source != null) {
      builder.source(json.source);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link MeasureGroup} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MeasureGroup instance
   */
  public static ImmutableMeasureGroup copyOf(MeasureGroup instance) {
    if (instance instanceof ImmutableMeasureGroup) {
      return (ImmutableMeasureGroup) instance;
    }
    return ImmutableMeasureGroup.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMeasureGroup ImmutableMeasureGroup}.
   * <pre>
   * ImmutableMeasureGroup.builder()
   *    .id(String | null) // nullable {@link MeasureGroup#getId() id}
   *    .name(String | null) // nullable {@link MeasureGroup#getName() name}
   *    .createdDate(String | null) // nullable {@link MeasureGroup#getCreatedDate() createdDate}
   *    .updatedDate(String | null) // nullable {@link MeasureGroup#getUpdatedDate() updatedDate}
   *    .state(String | null) // nullable {@link MeasureGroup#getState() state}
   *    .measures(List&amp;lt;zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.Measure&amp;gt; | null) // nullable {@link MeasureGroup#getMeasures() measures}
   *    .dimensions(List&amp;lt;zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.Dimension&amp;gt; | null) // nullable {@link MeasureGroup#getDimensions() dimensions}
   *    .source(zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.Source | null) // nullable {@link MeasureGroup#getSource() source}
   *    .build();
   * </pre>
   * @return A new ImmutableMeasureGroup builder
   */
  public static ImmutableMeasureGroup.Builder builder() {
    return new ImmutableMeasureGroup.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMeasureGroup ImmutableMeasureGroup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MeasureGroup", generator = "Immutables")
  public static final class Builder {
    private String id;
    private String name;
    private String createdDate;
    private String updatedDate;
    private String state;
    private List<Measure> measures = null;
    private List<Dimension> dimensions = null;
    private Source source;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MeasureGroup} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MeasureGroup instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String createdDateValue = instance.getCreatedDate();
      if (createdDateValue != null) {
        createdDate(createdDateValue);
      }
      @Nullable String updatedDateValue = instance.getUpdatedDate();
      if (updatedDateValue != null) {
        updatedDate(updatedDateValue);
      }
      @Nullable String stateValue = instance.getState();
      if (stateValue != null) {
        state(stateValue);
      }
      @Nullable List<Measure> measuresValue = instance.getMeasures();
      if (measuresValue != null) {
        addAllMeasures(measuresValue);
      }
      @Nullable List<Dimension> dimensionsValue = instance.getDimensions();
      if (dimensionsValue != null) {
        addAllDimensions(dimensionsValue);
      }
      @Nullable Source sourceValue = instance.getSource();
      if (sourceValue != null) {
        source(sourceValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MeasureGroup#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link MeasureGroup#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link MeasureGroup#getCreatedDate() createdDate} attribute.
     * @param createdDate The value for createdDate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("createdDate")
    @JacksonXmlProperty(localName = "CreatedTimestamp")
    public final Builder createdDate(@Nullable String createdDate) {
      this.createdDate = createdDate;
      return this;
    }

    /**
     * Initializes the value for the {@link MeasureGroup#getUpdatedDate() updatedDate} attribute.
     * @param updatedDate The value for updatedDate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updatedDate")
    @JacksonXmlProperty(localName = "LastSchemaUpdate")
    public final Builder updatedDate(@Nullable String updatedDate) {
      this.updatedDate = updatedDate;
      return this;
    }

    /**
     * Initializes the value for the {@link MeasureGroup#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    @JacksonXmlProperty(localName = "State")
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Adds one element to {@link MeasureGroup#getMeasures() measures} list.
     * @param element A measures element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMeasures(Measure element) {
      if (this.measures == null) {
        this.measures = new ArrayList<Measure>();
      }
      this.measures.add(Objects.requireNonNull(element, "measures element"));
      return this;
    }

    /**
     * Adds elements to {@link MeasureGroup#getMeasures() measures} list.
     * @param elements An array of measures elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMeasures(Measure... elements) {
      if (this.measures == null) {
        this.measures = new ArrayList<Measure>();
      }
      for (Measure element : elements) {
        this.measures.add(Objects.requireNonNull(element, "measures element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MeasureGroup#getMeasures() measures} list.
     * @param elements An iterable of measures elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("measures")
    @JacksonXmlElementWrapper(useWrapping = true)
    @JacksonXmlProperty(localName = "Measures")
    public final Builder measures(@Nullable Iterable<? extends Measure> elements) {
      if (elements == null) {
        this.measures = null;
        return this;
      }
      this.measures = new ArrayList<Measure>();
      return addAllMeasures(elements);
    }

    /**
     * Adds elements to {@link MeasureGroup#getMeasures() measures} list.
     * @param elements An iterable of measures elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMeasures(Iterable<? extends Measure> elements) {
      Objects.requireNonNull(elements, "measures element");
      if (this.measures == null) {
        this.measures = new ArrayList<Measure>();
      }
      for (Measure element : elements) {
        this.measures.add(Objects.requireNonNull(element, "measures element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link MeasureGroup#getDimensions() dimensions} list.
     * @param element A dimensions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDimensions(Dimension element) {
      if (this.dimensions == null) {
        this.dimensions = new ArrayList<Dimension>();
      }
      this.dimensions.add(Objects.requireNonNull(element, "dimensions element"));
      return this;
    }

    /**
     * Adds elements to {@link MeasureGroup#getDimensions() dimensions} list.
     * @param elements An array of dimensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDimensions(Dimension... elements) {
      if (this.dimensions == null) {
        this.dimensions = new ArrayList<Dimension>();
      }
      for (Dimension element : elements) {
        this.dimensions.add(Objects.requireNonNull(element, "dimensions element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MeasureGroup#getDimensions() dimensions} list.
     * @param elements An iterable of dimensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dimensions")
    @JacksonXmlElementWrapper(useWrapping = true)
    @JacksonXmlProperty(localName = "Dimensions")
    public final Builder dimensions(@Nullable Iterable<? extends Dimension> elements) {
      if (elements == null) {
        this.dimensions = null;
        return this;
      }
      this.dimensions = new ArrayList<Dimension>();
      return addAllDimensions(elements);
    }

    /**
     * Adds elements to {@link MeasureGroup#getDimensions() dimensions} list.
     * @param elements An iterable of dimensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDimensions(Iterable<? extends Dimension> elements) {
      Objects.requireNonNull(elements, "dimensions element");
      if (this.dimensions == null) {
        this.dimensions = new ArrayList<Dimension>();
      }
      for (Dimension element : elements) {
        this.dimensions.add(Objects.requireNonNull(element, "dimensions element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MeasureGroup#getSource() source} attribute.
     * @param source The value for source (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("source")
    @JacksonXmlProperty(localName = "Source")
    public final Builder source(@Nullable Source source) {
      this.source = source;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMeasureGroup ImmutableMeasureGroup}.
     * @return An immutable instance of MeasureGroup
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMeasureGroup build() {
      return new ImmutableMeasureGroup(
          id,
          name,
          createdDate,
          updatedDate,
          state,
          measures == null ? null : List.copyOf(measures),
          dimensions == null ? null : List.copyOf(dimensions),
          source);
    }
  }
}
