package zeenea.connector.sqlserver.services.ssas.client.model.multidimensional;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Measure}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMeasure.builder()}.
 */
@Generated(from = "Measure", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMeasure
    implements Measure {
  private final @Nullable String id;
  private final @Nullable String name;
  private final @Nullable String aggregateFunction;
  private final @Nullable Source source;

  private ImmutableMeasure(
      @Nullable String id,
      @Nullable String name,
      @Nullable String aggregateFunction,
      @Nullable Source source) {
    this.id = id;
    this.name = name;
    this.aggregateFunction = aggregateFunction;
    this.source = source;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JacksonXmlProperty(localName = "ID")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JacksonXmlProperty(localName = "Name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code aggregateFunction} attribute
   */
  @JsonProperty("aggregateFunction")
  @JacksonXmlProperty(localName = "AggregateFunction")
  @Override
  public @Nullable String getAggregateFunction() {
    return aggregateFunction;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("source")
  @JacksonXmlProperty(localName = "Source")
  @Override
  public @Nullable Source getSource() {
    return source;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Measure#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMeasure withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableMeasure(value, this.name, this.aggregateFunction, this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Measure#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMeasure withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableMeasure(this.id, value, this.aggregateFunction, this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Measure#getAggregateFunction() aggregateFunction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for aggregateFunction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMeasure withAggregateFunction(@Nullable String value) {
    if (Objects.equals(this.aggregateFunction, value)) return this;
    return new ImmutableMeasure(this.id, this.name, value, this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Measure#getSource() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMeasure withSource(@Nullable Source value) {
    if (this.source == value) return this;
    return new ImmutableMeasure(this.id, this.name, this.aggregateFunction, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMeasure} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMeasure
        && equalTo(0, (ImmutableMeasure) another);
  }

  private boolean equalTo(int synthetic, ImmutableMeasure another) {
    return Objects.equals(id, another.id)
        && Objects.equals(name, another.name)
        && Objects.equals(aggregateFunction, another.aggregateFunction)
        && Objects.equals(source, another.source);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code aggregateFunction}, {@code source}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(aggregateFunction);
    h += (h << 5) + Objects.hashCode(source);
    return h;
  }

  /**
   * Prints the immutable value {@code Measure} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Measure{"
        + "id=" + id
        + ", name=" + name
        + ", aggregateFunction=" + aggregateFunction
        + ", source=" + source
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Measure", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements Measure {
    String id;
    String name;
    String aggregateFunction;
    Source source;
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("aggregateFunction")
    @JacksonXmlProperty(localName = "AggregateFunction")
    public void setAggregateFunction(@Nullable String aggregateFunction) {
      this.aggregateFunction = aggregateFunction;
    }
    @JsonProperty("source")
    @JacksonXmlProperty(localName = "Source")
    public void setSource(@Nullable Source source) {
      this.source = source;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getAggregateFunction() { throw new UnsupportedOperationException(); }
    @Override
    public Source getSource() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMeasure fromJson(Json json) {
    ImmutableMeasure.Builder builder = ImmutableMeasure.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.aggregateFunction != null) {
      builder.aggregateFunction(json.aggregateFunction);
    }
    if (json.source != null) {
      builder.source(json.source);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Measure} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Measure instance
   */
  public static ImmutableMeasure copyOf(Measure instance) {
    if (instance instanceof ImmutableMeasure) {
      return (ImmutableMeasure) instance;
    }
    return ImmutableMeasure.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMeasure ImmutableMeasure}.
   * <pre>
   * ImmutableMeasure.builder()
   *    .id(String | null) // nullable {@link Measure#getId() id}
   *    .name(String | null) // nullable {@link Measure#getName() name}
   *    .aggregateFunction(String | null) // nullable {@link Measure#getAggregateFunction() aggregateFunction}
   *    .source(zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.Source | null) // nullable {@link Measure#getSource() source}
   *    .build();
   * </pre>
   * @return A new ImmutableMeasure builder
   */
  public static ImmutableMeasure.Builder builder() {
    return new ImmutableMeasure.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMeasure ImmutableMeasure}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Measure", generator = "Immutables")
  public static final class Builder {
    private String id;
    private String name;
    private String aggregateFunction;
    private Source source;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Measure} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Measure instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String aggregateFunctionValue = instance.getAggregateFunction();
      if (aggregateFunctionValue != null) {
        aggregateFunction(aggregateFunctionValue);
      }
      @Nullable Source sourceValue = instance.getSource();
      if (sourceValue != null) {
        source(sourceValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Measure#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Measure#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Measure#getAggregateFunction() aggregateFunction} attribute.
     * @param aggregateFunction The value for aggregateFunction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("aggregateFunction")
    @JacksonXmlProperty(localName = "AggregateFunction")
    public final Builder aggregateFunction(@Nullable String aggregateFunction) {
      this.aggregateFunction = aggregateFunction;
      return this;
    }

    /**
     * Initializes the value for the {@link Measure#getSource() source} attribute.
     * @param source The value for source (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("source")
    @JacksonXmlProperty(localName = "Source")
    public final Builder source(@Nullable Source source) {
      this.source = source;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMeasure ImmutableMeasure}.
     * @return An immutable instance of Measure
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMeasure build() {
      return new ImmutableMeasure(id, name, aggregateFunction, source);
    }
  }
}
