package zeenea.connector.sqlserver.services.ssas.client.model.multidimensional;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link KeyColumn}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableKeyColumn.builder()}.
 */
@Generated(from = "KeyColumn", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableKeyColumn
    implements KeyColumn {
  private final @Nullable String dataType;
  private final @Nullable Source source;

  private ImmutableKeyColumn(
      @Nullable String dataType,
      @Nullable Source source) {
    this.dataType = dataType;
    this.source = source;
  }

  /**
   * @return The value of the {@code dataType} attribute
   */
  @JsonProperty("dataType")
  @JacksonXmlProperty(localName = "DataType")
  @Override
  public @Nullable String getDataType() {
    return dataType;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("source")
  @JacksonXmlProperty(localName = "Source")
  @Override
  public @Nullable Source getSource() {
    return source;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KeyColumn#getDataType() dataType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dataType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableKeyColumn withDataType(@Nullable String value) {
    if (Objects.equals(this.dataType, value)) return this;
    return new ImmutableKeyColumn(value, this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KeyColumn#getSource() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableKeyColumn withSource(@Nullable Source value) {
    if (this.source == value) return this;
    return new ImmutableKeyColumn(this.dataType, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableKeyColumn} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableKeyColumn
        && equalTo(0, (ImmutableKeyColumn) another);
  }

  private boolean equalTo(int synthetic, ImmutableKeyColumn another) {
    return Objects.equals(dataType, another.dataType)
        && Objects.equals(source, another.source);
  }

  /**
   * Computes a hash code from attributes: {@code dataType}, {@code source}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(dataType);
    h += (h << 5) + Objects.hashCode(source);
    return h;
  }

  /**
   * Prints the immutable value {@code KeyColumn} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "KeyColumn{"
        + "dataType=" + dataType
        + ", source=" + source
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "KeyColumn", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements KeyColumn {
    String dataType;
    Source source;
    @JsonProperty("dataType")
    @JacksonXmlProperty(localName = "DataType")
    public void setDataType(@Nullable String dataType) {
      this.dataType = dataType;
    }
    @JsonProperty("source")
    @JacksonXmlProperty(localName = "Source")
    public void setSource(@Nullable Source source) {
      this.source = source;
    }
    @Override
    public String getDataType() { throw new UnsupportedOperationException(); }
    @Override
    public Source getSource() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableKeyColumn fromJson(Json json) {
    ImmutableKeyColumn.Builder builder = ImmutableKeyColumn.builder();
    if (json.dataType != null) {
      builder.dataType(json.dataType);
    }
    if (json.source != null) {
      builder.source(json.source);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link KeyColumn} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable KeyColumn instance
   */
  public static ImmutableKeyColumn copyOf(KeyColumn instance) {
    if (instance instanceof ImmutableKeyColumn) {
      return (ImmutableKeyColumn) instance;
    }
    return ImmutableKeyColumn.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableKeyColumn ImmutableKeyColumn}.
   * <pre>
   * ImmutableKeyColumn.builder()
   *    .dataType(String | null) // nullable {@link KeyColumn#getDataType() dataType}
   *    .source(zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.Source | null) // nullable {@link KeyColumn#getSource() source}
   *    .build();
   * </pre>
   * @return A new ImmutableKeyColumn builder
   */
  public static ImmutableKeyColumn.Builder builder() {
    return new ImmutableKeyColumn.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableKeyColumn ImmutableKeyColumn}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "KeyColumn", generator = "Immutables")
  public static final class Builder {
    private String dataType;
    private Source source;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code KeyColumn} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(KeyColumn instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String dataTypeValue = instance.getDataType();
      if (dataTypeValue != null) {
        dataType(dataTypeValue);
      }
      @Nullable Source sourceValue = instance.getSource();
      if (sourceValue != null) {
        source(sourceValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link KeyColumn#getDataType() dataType} attribute.
     * @param dataType The value for dataType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dataType")
    @JacksonXmlProperty(localName = "DataType")
    public final Builder dataType(@Nullable String dataType) {
      this.dataType = dataType;
      return this;
    }

    /**
     * Initializes the value for the {@link KeyColumn#getSource() source} attribute.
     * @param source The value for source (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("source")
    @JacksonXmlProperty(localName = "Source")
    public final Builder source(@Nullable Source source) {
      this.source = source;
      return this;
    }

    /**
     * Builds a new {@link ImmutableKeyColumn ImmutableKeyColumn}.
     * @return An immutable instance of KeyColumn
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableKeyColumn build() {
      return new ImmutableKeyColumn(dataType, source);
    }
  }
}
