package zeenea.connector.sqlserver.services.ssas.client.model.multidimensional;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Dimension}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDimension.builder()}.
 */
@Generated(from = "Dimension", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDimension
    implements Dimension {
  private final @Nullable String id;
  private final @Nullable String name;
  private final @Nullable String dimensionId;
  private final @Nullable String cubeDimensionId;
  private final @Nullable List<Attribute> attributes;

  private ImmutableDimension(
      @Nullable String id,
      @Nullable String name,
      @Nullable String dimensionId,
      @Nullable String cubeDimensionId,
      @Nullable List<Attribute> attributes) {
    this.id = id;
    this.name = name;
    this.dimensionId = dimensionId;
    this.cubeDimensionId = cubeDimensionId;
    this.attributes = attributes;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JacksonXmlProperty(localName = "ID")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JacksonXmlProperty(localName = "Name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code dimensionId} attribute
   */
  @JsonProperty("dimensionId")
  @JacksonXmlProperty(localName = "DimensionID")
  @Override
  public @Nullable String getDimensionId() {
    return dimensionId;
  }

  /**
   * @return The value of the {@code cubeDimensionId} attribute
   */
  @JsonProperty("cubeDimensionId")
  @JacksonXmlProperty(localName = "CubeDimensionID")
  @Override
  public @Nullable String getCubeDimensionId() {
    return cubeDimensionId;
  }

  /**
   * @return The value of the {@code attributes} attribute
   */
  @JsonProperty("attributes")
  @JacksonXmlElementWrapper(useWrapping = true)
  @JacksonXmlProperty(localName = "Attributes")
  @Override
  public @Nullable List<Attribute> getAttributes() {
    return attributes;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Dimension#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDimension withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableDimension(value, this.name, this.dimensionId, this.cubeDimensionId, this.attributes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Dimension#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDimension withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableDimension(this.id, value, this.dimensionId, this.cubeDimensionId, this.attributes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Dimension#getDimensionId() dimensionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dimensionId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDimension withDimensionId(@Nullable String value) {
    if (Objects.equals(this.dimensionId, value)) return this;
    return new ImmutableDimension(this.id, this.name, value, this.cubeDimensionId, this.attributes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Dimension#getCubeDimensionId() cubeDimensionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cubeDimensionId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDimension withCubeDimensionId(@Nullable String value) {
    if (Objects.equals(this.cubeDimensionId, value)) return this;
    return new ImmutableDimension(this.id, this.name, this.dimensionId, value, this.attributes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Dimension#getAttributes() attributes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDimension withAttributes(@Nullable Attribute... elements) {
    if (elements == null) {
      return new ImmutableDimension(this.id, this.name, this.dimensionId, this.cubeDimensionId, null);
    }
    List<Attribute> newValue = List.of(elements);
    return new ImmutableDimension(this.id, this.name, this.dimensionId, this.cubeDimensionId, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Dimension#getAttributes() attributes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of attributes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDimension withAttributes(@Nullable Iterable<? extends Attribute> elements) {
    if (this.attributes == elements) return this;
    @Nullable List<Attribute> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Attribute>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDimension(this.id, this.name, this.dimensionId, this.cubeDimensionId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDimension} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDimension
        && equalTo(0, (ImmutableDimension) another);
  }

  private boolean equalTo(int synthetic, ImmutableDimension another) {
    return Objects.equals(id, another.id)
        && Objects.equals(name, another.name)
        && Objects.equals(dimensionId, another.dimensionId)
        && Objects.equals(cubeDimensionId, another.cubeDimensionId)
        && Objects.equals(attributes, another.attributes);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code dimensionId}, {@code cubeDimensionId}, {@code attributes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(dimensionId);
    h += (h << 5) + Objects.hashCode(cubeDimensionId);
    h += (h << 5) + Objects.hashCode(attributes);
    return h;
  }

  /**
   * Prints the immutable value {@code Dimension} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Dimension{"
        + "id=" + id
        + ", name=" + name
        + ", dimensionId=" + dimensionId
        + ", cubeDimensionId=" + cubeDimensionId
        + ", attributes=" + attributes
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Dimension", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements Dimension {
    String id;
    String name;
    String dimensionId;
    String cubeDimensionId;
    List<Attribute> attributes = null;
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("dimensionId")
    @JacksonXmlProperty(localName = "DimensionID")
    public void setDimensionId(@Nullable String dimensionId) {
      this.dimensionId = dimensionId;
    }
    @JsonProperty("cubeDimensionId")
    @JacksonXmlProperty(localName = "CubeDimensionID")
    public void setCubeDimensionId(@Nullable String cubeDimensionId) {
      this.cubeDimensionId = cubeDimensionId;
    }
    @JsonProperty("attributes")
    @JacksonXmlElementWrapper(useWrapping = true)
    @JacksonXmlProperty(localName = "Attributes")
    public void setAttributes(@Nullable List<Attribute> attributes) {
      this.attributes = attributes;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getDimensionId() { throw new UnsupportedOperationException(); }
    @Override
    public String getCubeDimensionId() { throw new UnsupportedOperationException(); }
    @Override
    public List<Attribute> getAttributes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDimension fromJson(Json json) {
    ImmutableDimension.Builder builder = ImmutableDimension.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.dimensionId != null) {
      builder.dimensionId(json.dimensionId);
    }
    if (json.cubeDimensionId != null) {
      builder.cubeDimensionId(json.cubeDimensionId);
    }
    if (json.attributes != null) {
      builder.addAllAttributes(json.attributes);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Dimension} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Dimension instance
   */
  public static ImmutableDimension copyOf(Dimension instance) {
    if (instance instanceof ImmutableDimension) {
      return (ImmutableDimension) instance;
    }
    return ImmutableDimension.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDimension ImmutableDimension}.
   * <pre>
   * ImmutableDimension.builder()
   *    .id(String | null) // nullable {@link Dimension#getId() id}
   *    .name(String | null) // nullable {@link Dimension#getName() name}
   *    .dimensionId(String | null) // nullable {@link Dimension#getDimensionId() dimensionId}
   *    .cubeDimensionId(String | null) // nullable {@link Dimension#getCubeDimensionId() cubeDimensionId}
   *    .attributes(List&amp;lt;zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.Attribute&amp;gt; | null) // nullable {@link Dimension#getAttributes() attributes}
   *    .build();
   * </pre>
   * @return A new ImmutableDimension builder
   */
  public static ImmutableDimension.Builder builder() {
    return new ImmutableDimension.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDimension ImmutableDimension}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Dimension", generator = "Immutables")
  public static final class Builder {
    private String id;
    private String name;
    private String dimensionId;
    private String cubeDimensionId;
    private List<Attribute> attributes = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Dimension} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Dimension instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String dimensionIdValue = instance.getDimensionId();
      if (dimensionIdValue != null) {
        dimensionId(dimensionIdValue);
      }
      @Nullable String cubeDimensionIdValue = instance.getCubeDimensionId();
      if (cubeDimensionIdValue != null) {
        cubeDimensionId(cubeDimensionIdValue);
      }
      @Nullable List<Attribute> attributesValue = instance.getAttributes();
      if (attributesValue != null) {
        addAllAttributes(attributesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Dimension#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Dimension#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Dimension#getDimensionId() dimensionId} attribute.
     * @param dimensionId The value for dimensionId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dimensionId")
    @JacksonXmlProperty(localName = "DimensionID")
    public final Builder dimensionId(@Nullable String dimensionId) {
      this.dimensionId = dimensionId;
      return this;
    }

    /**
     * Initializes the value for the {@link Dimension#getCubeDimensionId() cubeDimensionId} attribute.
     * @param cubeDimensionId The value for cubeDimensionId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("cubeDimensionId")
    @JacksonXmlProperty(localName = "CubeDimensionID")
    public final Builder cubeDimensionId(@Nullable String cubeDimensionId) {
      this.cubeDimensionId = cubeDimensionId;
      return this;
    }

    /**
     * Adds one element to {@link Dimension#getAttributes() attributes} list.
     * @param element A attributes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAttributes(Attribute element) {
      if (this.attributes == null) {
        this.attributes = new ArrayList<Attribute>();
      }
      this.attributes.add(Objects.requireNonNull(element, "attributes element"));
      return this;
    }

    /**
     * Adds elements to {@link Dimension#getAttributes() attributes} list.
     * @param elements An array of attributes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAttributes(Attribute... elements) {
      if (this.attributes == null) {
        this.attributes = new ArrayList<Attribute>();
      }
      for (Attribute element : elements) {
        this.attributes.add(Objects.requireNonNull(element, "attributes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Dimension#getAttributes() attributes} list.
     * @param elements An iterable of attributes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("attributes")
    @JacksonXmlElementWrapper(useWrapping = true)
    @JacksonXmlProperty(localName = "Attributes")
    public final Builder attributes(@Nullable Iterable<? extends Attribute> elements) {
      if (elements == null) {
        this.attributes = null;
        return this;
      }
      this.attributes = new ArrayList<Attribute>();
      return addAllAttributes(elements);
    }

    /**
     * Adds elements to {@link Dimension#getAttributes() attributes} list.
     * @param elements An iterable of attributes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAttributes(Iterable<? extends Attribute> elements) {
      Objects.requireNonNull(elements, "attributes element");
      if (this.attributes == null) {
        this.attributes = new ArrayList<Attribute>();
      }
      for (Attribute element : elements) {
        this.attributes.add(Objects.requireNonNull(element, "attributes element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDimension ImmutableDimension}.
     * @return An immutable instance of Dimension
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDimension build() {
      return new ImmutableDimension(
          id,
          name,
          dimensionId,
          cubeDimensionId,
          attributes == null ? null : List.copyOf(attributes));
    }
  }
}
