package zeenea.connector.sqlserver.services.ssas.client.model.multidimensional;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.sqlserver.services.ssas.client.model.DataSource;

/**
 * Immutable implementation of {@link Database}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDatabase.builder()}.
 */
@Generated(from = "Database", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDatabase
    implements Database {
  private final @Nullable String id;
  @NotNull
  private final String name;
  private final List<Cube> cubes;
  private final List<DataSource> dataSources;
  private final List<DataSourceView> dataSourceViews;

  private ImmutableDatabase(
      @Nullable String id,
      String name,
      List<Cube> cubes,
      List<DataSource> dataSources,
      List<DataSourceView> dataSourceViews) {
    this.id = id;
    this.name = name;
    this.cubes = cubes;
    this.dataSources = dataSources;
    this.dataSourceViews = dataSourceViews;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JacksonXmlProperty(localName = "ID")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JacksonXmlProperty(localName = "Name")
  @NotNull
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code cubes} attribute
   */
  @JsonProperty("cubes")
  @JacksonXmlElementWrapper(localName = "Cubes")
  @Override
  public List<Cube> getCubes() {
    return cubes;
  }

  /**
   * @return The value of the {@code dataSources} attribute
   */
  @JsonProperty("dataSources")
  @JacksonXmlElementWrapper(localName = "DataSources")
  @Override
  public List<DataSource> getDataSources() {
    return dataSources;
  }

  /**
   * @return The value of the {@code dataSourceViews} attribute
   */
  @JsonProperty("dataSourceViews")
  @JacksonXmlElementWrapper(localName = "DataSourceViews")
  @Override
  public List<DataSourceView> getDataSourceViews() {
    return dataSourceViews;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Database#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDatabase withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableDatabase(value, this.name, this.cubes, this.dataSources, this.dataSourceViews);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Database#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDatabase withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableDatabase(this.id, newValue, this.cubes, this.dataSources, this.dataSourceViews);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Database#getCubes() cubes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDatabase withCubes(Cube... elements) {
    List<Cube> newValue = List.of(elements);
    return new ImmutableDatabase(this.id, this.name, newValue, this.dataSources, this.dataSourceViews);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Database#getCubes() cubes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of cubes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDatabase withCubes(Iterable<? extends Cube> elements) {
    if (this.cubes == elements) return this;
    List<Cube> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Cube>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDatabase(this.id, this.name, newValue, this.dataSources, this.dataSourceViews);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Database#getDataSources() dataSources}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDatabase withDataSources(DataSource... elements) {
    List<DataSource> newValue = List.of(elements);
    return new ImmutableDatabase(this.id, this.name, this.cubes, newValue, this.dataSourceViews);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Database#getDataSources() dataSources}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dataSources elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDatabase withDataSources(Iterable<? extends DataSource> elements) {
    if (this.dataSources == elements) return this;
    List<DataSource> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends DataSource>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDatabase(this.id, this.name, this.cubes, newValue, this.dataSourceViews);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Database#getDataSourceViews() dataSourceViews}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDatabase withDataSourceViews(DataSourceView... elements) {
    List<DataSourceView> newValue = List.of(elements);
    return new ImmutableDatabase(this.id, this.name, this.cubes, this.dataSources, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Database#getDataSourceViews() dataSourceViews}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dataSourceViews elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDatabase withDataSourceViews(Iterable<? extends DataSourceView> elements) {
    if (this.dataSourceViews == elements) return this;
    List<DataSourceView> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends DataSourceView>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDatabase(this.id, this.name, this.cubes, this.dataSources, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDatabase} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDatabase
        && equalTo(0, (ImmutableDatabase) another);
  }

  private boolean equalTo(int synthetic, ImmutableDatabase another) {
    return Objects.equals(id, another.id)
        && name.equals(another.name)
        && cubes.equals(another.cubes)
        && dataSources.equals(another.dataSources)
        && dataSourceViews.equals(another.dataSourceViews);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code cubes}, {@code dataSources}, {@code dataSourceViews}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + cubes.hashCode();
    h += (h << 5) + dataSources.hashCode();
    h += (h << 5) + dataSourceViews.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Database} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Database{"
        + "id=" + id
        + ", name=" + name
        + ", cubes=" + cubes
        + ", dataSources=" + dataSources
        + ", dataSourceViews=" + dataSourceViews
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Database", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements Database {
    String id;
    String name;
    List<Cube> cubes = List.of();
    List<DataSource> dataSources = List.of();
    List<DataSourceView> dataSourceViews = List.of();
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("cubes")
    @JacksonXmlElementWrapper(localName = "Cubes")
    public void setCubes(List<Cube> cubes) {
      this.cubes = cubes;
    }
    @JsonProperty("dataSources")
    @JacksonXmlElementWrapper(localName = "DataSources")
    public void setDataSources(List<DataSource> dataSources) {
      this.dataSources = dataSources;
    }
    @JsonProperty("dataSourceViews")
    @JacksonXmlElementWrapper(localName = "DataSourceViews")
    public void setDataSourceViews(List<DataSourceView> dataSourceViews) {
      this.dataSourceViews = dataSourceViews;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public List<Cube> getCubes() { throw new UnsupportedOperationException(); }
    @Override
    public List<DataSource> getDataSources() { throw new UnsupportedOperationException(); }
    @Override
    public List<DataSourceView> getDataSourceViews() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDatabase fromJson(Json json) {
    ImmutableDatabase.Builder builder = ImmutableDatabase.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.cubes != null) {
      builder.addAllCubes(json.cubes);
    }
    if (json.dataSources != null) {
      builder.addAllDataSources(json.dataSources);
    }
    if (json.dataSourceViews != null) {
      builder.addAllDataSourceViews(json.dataSourceViews);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Database} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Database instance
   */
  public static ImmutableDatabase copyOf(Database instance) {
    if (instance instanceof ImmutableDatabase) {
      return (ImmutableDatabase) instance;
    }
    return ImmutableDatabase.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDatabase ImmutableDatabase}.
   * <pre>
   * ImmutableDatabase.builder()
   *    .id(String | null) // nullable {@link Database#getId() id}
   *    .name(String) // required {@link Database#getName() name}
   *    .addCubes|addAllCubes(zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.Cube) // {@link Database#getCubes() cubes} elements
   *    .addDataSources|addAllDataSources(zeenea.connector.sqlserver.services.ssas.client.model.DataSource) // {@link Database#getDataSources() dataSources} elements
   *    .addDataSourceViews|addAllDataSourceViews(zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.DataSourceView) // {@link Database#getDataSourceViews() dataSourceViews} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDatabase builder
   */
  public static ImmutableDatabase.Builder builder() {
    return new ImmutableDatabase.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDatabase ImmutableDatabase}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Database", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String id;
    private String name;
    private List<Cube> cubes = new ArrayList<Cube>();
    private List<DataSource> dataSources = new ArrayList<DataSource>();
    private List<DataSourceView> dataSourceViews = new ArrayList<DataSourceView>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Database} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Database instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      this.name(instance.getName());
      addAllCubes(instance.getCubes());
      addAllDataSources(instance.getDataSources());
      addAllDataSourceViews(instance.getDataSourceViews());
      return this;
    }

    /**
     * Initializes the value for the {@link Database#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Database#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link Database#getCubes() cubes} list.
     * @param element A cubes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCubes(Cube element) {
      this.cubes.add(Objects.requireNonNull(element, "cubes element"));
      return this;
    }

    /**
     * Adds elements to {@link Database#getCubes() cubes} list.
     * @param elements An array of cubes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCubes(Cube... elements) {
      for (Cube element : elements) {
        this.cubes.add(Objects.requireNonNull(element, "cubes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Database#getCubes() cubes} list.
     * @param elements An iterable of cubes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("cubes")
    @JacksonXmlElementWrapper(localName = "Cubes")
    public final Builder cubes(Iterable<? extends Cube> elements) {
      this.cubes.clear();
      return addAllCubes(elements);
    }

    /**
     * Adds elements to {@link Database#getCubes() cubes} list.
     * @param elements An iterable of cubes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllCubes(Iterable<? extends Cube> elements) {
      for (Cube element : elements) {
        this.cubes.add(Objects.requireNonNull(element, "cubes element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Database#getDataSources() dataSources} list.
     * @param element A dataSources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDataSources(DataSource element) {
      this.dataSources.add(Objects.requireNonNull(element, "dataSources element"));
      return this;
    }

    /**
     * Adds elements to {@link Database#getDataSources() dataSources} list.
     * @param elements An array of dataSources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDataSources(DataSource... elements) {
      for (DataSource element : elements) {
        this.dataSources.add(Objects.requireNonNull(element, "dataSources element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Database#getDataSources() dataSources} list.
     * @param elements An iterable of dataSources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dataSources")
    @JacksonXmlElementWrapper(localName = "DataSources")
    public final Builder dataSources(Iterable<? extends DataSource> elements) {
      this.dataSources.clear();
      return addAllDataSources(elements);
    }

    /**
     * Adds elements to {@link Database#getDataSources() dataSources} list.
     * @param elements An iterable of dataSources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDataSources(Iterable<? extends DataSource> elements) {
      for (DataSource element : elements) {
        this.dataSources.add(Objects.requireNonNull(element, "dataSources element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Database#getDataSourceViews() dataSourceViews} list.
     * @param element A dataSourceViews element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDataSourceViews(DataSourceView element) {
      this.dataSourceViews.add(Objects.requireNonNull(element, "dataSourceViews element"));
      return this;
    }

    /**
     * Adds elements to {@link Database#getDataSourceViews() dataSourceViews} list.
     * @param elements An array of dataSourceViews elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDataSourceViews(DataSourceView... elements) {
      for (DataSourceView element : elements) {
        this.dataSourceViews.add(Objects.requireNonNull(element, "dataSourceViews element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Database#getDataSourceViews() dataSourceViews} list.
     * @param elements An iterable of dataSourceViews elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dataSourceViews")
    @JacksonXmlElementWrapper(localName = "DataSourceViews")
    public final Builder dataSourceViews(Iterable<? extends DataSourceView> elements) {
      this.dataSourceViews.clear();
      return addAllDataSourceViews(elements);
    }

    /**
     * Adds elements to {@link Database#getDataSourceViews() dataSourceViews} list.
     * @param elements An iterable of dataSourceViews elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDataSourceViews(Iterable<? extends DataSourceView> elements) {
      for (DataSourceView element : elements) {
        this.dataSourceViews.add(Objects.requireNonNull(element, "dataSourceViews element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDatabase ImmutableDatabase}.
     * @return An immutable instance of Database
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDatabase build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDatabase(
          id,
          name,
          List.copyOf(cubes),
          List.copyOf(dataSources),
          List.copyOf(dataSourceViews));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Database, some of required attributes are not set " + attributes;
    }
  }
}
