package zeenea.connector.sqlserver.services.ssas.client.model.multidimensional;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link DataSourceView}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDataSourceView.builder()}.
 */
@Generated(from = "DataSourceView", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDataSourceView
    implements DataSourceView {
  @NotNull
  private final String id;
  private final @Nullable String name;
  @NotNull
  private final String datasourceId;
  private final @Nullable Schema schema;

  private ImmutableDataSourceView(
      String id,
      @Nullable String name,
      String datasourceId,
      @Nullable Schema schema) {
    this.id = id;
    this.name = name;
    this.datasourceId = datasourceId;
    this.schema = schema;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JacksonXmlProperty(localName = "ID")
  @NotNull
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JacksonXmlProperty(localName = "Name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code datasourceId} attribute
   */
  @JsonProperty("datasourceId")
  @JacksonXmlProperty(localName = "DataSourceID")
  @NotNull
  @Override
  public String getDatasourceId() {
    return datasourceId;
  }

  /**
   * @return The value of the {@code schema} attribute
   */
  @JsonProperty("schema")
  @JacksonXmlProperty(localName = "Schema")
  @Override
  public @Nullable Schema getSchema() {
    return schema;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSourceView#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSourceView withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableDataSourceView(newValue, this.name, this.datasourceId, this.schema);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSourceView#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSourceView withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableDataSourceView(this.id, value, this.datasourceId, this.schema);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSourceView#getDatasourceId() datasourceId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for datasourceId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSourceView withDatasourceId(String value) {
    String newValue = Objects.requireNonNull(value, "datasourceId");
    if (this.datasourceId.equals(newValue)) return this;
    return new ImmutableDataSourceView(this.id, this.name, newValue, this.schema);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSourceView#getSchema() schema} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schema (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSourceView withSchema(@Nullable Schema value) {
    if (this.schema == value) return this;
    return new ImmutableDataSourceView(this.id, this.name, this.datasourceId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDataSourceView} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDataSourceView
        && equalTo(0, (ImmutableDataSourceView) another);
  }

  private boolean equalTo(int synthetic, ImmutableDataSourceView another) {
    return id.equals(another.id)
        && Objects.equals(name, another.name)
        && datasourceId.equals(another.datasourceId)
        && Objects.equals(schema, another.schema);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code datasourceId}, {@code schema}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + datasourceId.hashCode();
    h += (h << 5) + Objects.hashCode(schema);
    return h;
  }

  /**
   * Prints the immutable value {@code DataSourceView} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DataSourceView{"
        + "id=" + id
        + ", name=" + name
        + ", datasourceId=" + datasourceId
        + ", schema=" + schema
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DataSourceView", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements DataSourceView {
    String id;
    String name;
    String datasourceId;
    Schema schema;
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("datasourceId")
    @JacksonXmlProperty(localName = "DataSourceID")
    public void setDatasourceId(String datasourceId) {
      this.datasourceId = datasourceId;
    }
    @JsonProperty("schema")
    @JacksonXmlProperty(localName = "Schema")
    public void setSchema(@Nullable Schema schema) {
      this.schema = schema;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getDatasourceId() { throw new UnsupportedOperationException(); }
    @Override
    public Schema getSchema() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDataSourceView fromJson(Json json) {
    ImmutableDataSourceView.Builder builder = ImmutableDataSourceView.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.datasourceId != null) {
      builder.datasourceId(json.datasourceId);
    }
    if (json.schema != null) {
      builder.schema(json.schema);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DataSourceView} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DataSourceView instance
   */
  public static ImmutableDataSourceView copyOf(DataSourceView instance) {
    if (instance instanceof ImmutableDataSourceView) {
      return (ImmutableDataSourceView) instance;
    }
    return ImmutableDataSourceView.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDataSourceView ImmutableDataSourceView}.
   * <pre>
   * ImmutableDataSourceView.builder()
   *    .id(String) // required {@link DataSourceView#getId() id}
   *    .name(String | null) // nullable {@link DataSourceView#getName() name}
   *    .datasourceId(String) // required {@link DataSourceView#getDatasourceId() datasourceId}
   *    .schema(zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.Schema | null) // nullable {@link DataSourceView#getSchema() schema}
   *    .build();
   * </pre>
   * @return A new ImmutableDataSourceView builder
   */
  public static ImmutableDataSourceView.Builder builder() {
    return new ImmutableDataSourceView.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDataSourceView ImmutableDataSourceView}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DataSourceView", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_DATASOURCE_ID = 0x2L;
    private long initBits = 0x3L;

    private String id;
    private String name;
    private String datasourceId;
    private Schema schema;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DataSourceView} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DataSourceView instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      this.datasourceId(instance.getDatasourceId());
      @Nullable Schema schemaValue = instance.getSchema();
      if (schemaValue != null) {
        schema(schemaValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DataSourceView#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DataSourceView#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link DataSourceView#getDatasourceId() datasourceId} attribute.
     * @param datasourceId The value for datasourceId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("datasourceId")
    @JacksonXmlProperty(localName = "DataSourceID")
    public final Builder datasourceId(String datasourceId) {
      this.datasourceId = Objects.requireNonNull(datasourceId, "datasourceId");
      initBits &= ~INIT_BIT_DATASOURCE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DataSourceView#getSchema() schema} attribute.
     * @param schema The value for schema (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schema")
    @JacksonXmlProperty(localName = "Schema")
    public final Builder schema(@Nullable Schema schema) {
      this.schema = schema;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDataSourceView ImmutableDataSourceView}.
     * @return An immutable instance of DataSourceView
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDataSourceView build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDataSourceView(id, name, datasourceId, schema);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_DATASOURCE_ID) != 0) attributes.add("datasourceId");
      return "Cannot build DataSourceView, some of required attributes are not set " + attributes;
    }
  }
}
