package zeenea.connector.sqlserver.services.ssas.client.model.multidimensional;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Attribute}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAttribute.builder()}.
 */
@Generated(from = "Attribute", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableAttribute
    implements Attribute {
  private final @Nullable String id;
  private final @Nullable List<KeyColumn> keyColumns;

  private ImmutableAttribute(
      @Nullable String id,
      @Nullable List<KeyColumn> keyColumns) {
    this.id = id;
    this.keyColumns = keyColumns;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JacksonXmlProperty(localName = "AttributeID")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code keyColumns} attribute
   */
  @JsonProperty("keyColumns")
  @JacksonXmlElementWrapper(useWrapping = true)
  @JacksonXmlProperty(localName = "KeyColumns")
  @Override
  public @Nullable List<KeyColumn> getKeyColumns() {
    return keyColumns;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Attribute#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttribute withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableAttribute(value, this.keyColumns);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Attribute#getKeyColumns() keyColumns}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAttribute withKeyColumns(@Nullable KeyColumn... elements) {
    if (elements == null) {
      return new ImmutableAttribute(this.id, null);
    }
    List<KeyColumn> newValue = List.of(elements);
    return new ImmutableAttribute(this.id, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Attribute#getKeyColumns() keyColumns}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of keyColumns elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAttribute withKeyColumns(@Nullable Iterable<? extends KeyColumn> elements) {
    if (this.keyColumns == elements) return this;
    @Nullable List<KeyColumn> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends KeyColumn>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableAttribute(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAttribute} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAttribute
        && equalTo(0, (ImmutableAttribute) another);
  }

  private boolean equalTo(int synthetic, ImmutableAttribute another) {
    return Objects.equals(id, another.id)
        && Objects.equals(keyColumns, another.keyColumns);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code keyColumns}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(keyColumns);
    return h;
  }

  /**
   * Prints the immutable value {@code Attribute} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Attribute{"
        + "id=" + id
        + ", keyColumns=" + keyColumns
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Attribute", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements Attribute {
    String id;
    List<KeyColumn> keyColumns = null;
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "AttributeID")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("keyColumns")
    @JacksonXmlElementWrapper(useWrapping = true)
    @JacksonXmlProperty(localName = "KeyColumns")
    public void setKeyColumns(@Nullable List<KeyColumn> keyColumns) {
      this.keyColumns = keyColumns;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public List<KeyColumn> getKeyColumns() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAttribute fromJson(Json json) {
    ImmutableAttribute.Builder builder = ImmutableAttribute.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.keyColumns != null) {
      builder.addAllKeyColumns(json.keyColumns);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Attribute} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Attribute instance
   */
  public static ImmutableAttribute copyOf(Attribute instance) {
    if (instance instanceof ImmutableAttribute) {
      return (ImmutableAttribute) instance;
    }
    return ImmutableAttribute.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAttribute ImmutableAttribute}.
   * <pre>
   * ImmutableAttribute.builder()
   *    .id(String | null) // nullable {@link Attribute#getId() id}
   *    .keyColumns(List&amp;lt;zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.KeyColumn&amp;gt; | null) // nullable {@link Attribute#getKeyColumns() keyColumns}
   *    .build();
   * </pre>
   * @return A new ImmutableAttribute builder
   */
  public static ImmutableAttribute.Builder builder() {
    return new ImmutableAttribute.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAttribute ImmutableAttribute}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Attribute", generator = "Immutables")
  public static final class Builder {
    private String id;
    private List<KeyColumn> keyColumns = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Attribute} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Attribute instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable List<KeyColumn> keyColumnsValue = instance.getKeyColumns();
      if (keyColumnsValue != null) {
        addAllKeyColumns(keyColumnsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Attribute#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "AttributeID")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Adds one element to {@link Attribute#getKeyColumns() keyColumns} list.
     * @param element A keyColumns element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addKeyColumns(KeyColumn element) {
      if (this.keyColumns == null) {
        this.keyColumns = new ArrayList<KeyColumn>();
      }
      this.keyColumns.add(Objects.requireNonNull(element, "keyColumns element"));
      return this;
    }

    /**
     * Adds elements to {@link Attribute#getKeyColumns() keyColumns} list.
     * @param elements An array of keyColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addKeyColumns(KeyColumn... elements) {
      if (this.keyColumns == null) {
        this.keyColumns = new ArrayList<KeyColumn>();
      }
      for (KeyColumn element : elements) {
        this.keyColumns.add(Objects.requireNonNull(element, "keyColumns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Attribute#getKeyColumns() keyColumns} list.
     * @param elements An iterable of keyColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("keyColumns")
    @JacksonXmlElementWrapper(useWrapping = true)
    @JacksonXmlProperty(localName = "KeyColumns")
    public final Builder keyColumns(@Nullable Iterable<? extends KeyColumn> elements) {
      if (elements == null) {
        this.keyColumns = null;
        return this;
      }
      this.keyColumns = new ArrayList<KeyColumn>();
      return addAllKeyColumns(elements);
    }

    /**
     * Adds elements to {@link Attribute#getKeyColumns() keyColumns} list.
     * @param elements An iterable of keyColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllKeyColumns(Iterable<? extends KeyColumn> elements) {
      Objects.requireNonNull(elements, "keyColumns element");
      if (this.keyColumns == null) {
        this.keyColumns = new ArrayList<KeyColumn>();
      }
      for (KeyColumn element : elements) {
        this.keyColumns.add(Objects.requireNonNull(element, "keyColumns element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableAttribute ImmutableAttribute}.
     * @return An immutable instance of Attribute
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAttribute build() {
      return new ImmutableAttribute(id, keyColumns == null ? null : List.copyOf(keyColumns));
    }
  }
}
