package zeenea.connector.sqlserver.services.ssas.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SoapResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSoapResponse.builder()}.
 */
@Generated(from = "SoapResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableSoapResponse<T>
    implements SoapResponse<T> {
  private final ResponseBody<T> responseBody;

  private ImmutableSoapResponse(ResponseBody<T> responseBody) {
    this.responseBody = responseBody;
  }

  /**
   * @return The value of the {@code responseBody} attribute
   */
  @JsonProperty("responseBody")
  @JacksonXmlProperty(namespace = "soap", localName = "Body")
  @Override
  public ResponseBody<T> getResponseBody() {
    return responseBody;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SoapResponse#getResponseBody() responseBody} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for responseBody
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSoapResponse<T> withResponseBody(ResponseBody<T> value) {
    if (this.responseBody == value) return this;
    ResponseBody<T> newValue = Objects.requireNonNull(value, "responseBody");
    return new ImmutableSoapResponse<>(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSoapResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSoapResponse<?>
        && equalTo(0, (ImmutableSoapResponse<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableSoapResponse<?> another) {
    return responseBody.equals(another.responseBody);
  }

  /**
   * Computes a hash code from attributes: {@code responseBody}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + responseBody.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SoapResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SoapResponse{"
        + "responseBody=" + responseBody
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link SoapResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable SoapResponse instance
   */
  public static <T> ImmutableSoapResponse<T> copyOf(SoapResponse<T> instance) {
    if (instance instanceof ImmutableSoapResponse<?>) {
      return (ImmutableSoapResponse<T>) instance;
    }
    return ImmutableSoapResponse.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSoapResponse ImmutableSoapResponse}.
   * <pre>
   * ImmutableSoapResponse.&amp;lt;T&amp;gt;builder()
   *    .responseBody(zeenea.connector.sqlserver.services.ssas.client.model.ResponseBody&amp;lt;T&amp;gt;) // required {@link SoapResponse#getResponseBody() responseBody}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableSoapResponse builder
   */
  public static <T> ImmutableSoapResponse.Builder<T> builder() {
    return new ImmutableSoapResponse.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableSoapResponse ImmutableSoapResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SoapResponse", generator = "Immutables")
  @JacksonXmlRootElement(namespace = "soap", localName = "Envelope")
  public static final class Builder<T> {
    private static final long INIT_BIT_RESPONSE_BODY = 0x1L;
    private long initBits = 0x1L;

    private ResponseBody<T> responseBody;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SoapResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(SoapResponse<T> instance) {
      Objects.requireNonNull(instance, "instance");
      this.responseBody(instance.getResponseBody());
      return this;
    }

    /**
     * Initializes the value for the {@link SoapResponse#getResponseBody() responseBody} attribute.
     * @param responseBody The value for responseBody 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("responseBody")
    @JacksonXmlProperty(namespace = "soap", localName = "Body")
    public final Builder<T> responseBody(ResponseBody<T> responseBody) {
      this.responseBody = Objects.requireNonNull(responseBody, "responseBody");
      initBits &= ~INIT_BIT_RESPONSE_BODY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSoapResponse ImmutableSoapResponse}.
     * @return An immutable instance of SoapResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSoapResponse<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSoapResponse<>(responseBody);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RESPONSE_BODY) != 0) attributes.add("responseBody");
      return "Cannot build SoapResponse, some of required attributes are not set " + attributes;
    }
  }
}
