package zeenea.connector.sqlserver.services.ssas.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Return}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReturn.builder()}.
 */
@Generated(from = "Return", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableReturn<T>
    implements Return<T> {
  private final List<T> rows;

  private ImmutableReturn(List<T> rows) {
    this.rows = rows;
  }

  /**
   * @return The value of the {@code rows} attribute
   */
  @JsonProperty("rows")
  @JacksonXmlElementWrapper(localName = "root")
  @Override
  public List<T> getRows() {
    return rows;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Return#getRows() rows}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableReturn<T> withRows(T... elements) {
    List<T> newValue = List.of(elements);
    return new ImmutableReturn<>(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Return#getRows() rows}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of rows elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReturn<T> withRows(Iterable<? extends T> elements) {
    if (this.rows == elements) return this;
    List<T> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends T>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableReturn<>(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReturn} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReturn<?>
        && equalTo(0, (ImmutableReturn<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableReturn<?> another) {
    return rows.equals(another.rows);
  }

  /**
   * Computes a hash code from attributes: {@code rows}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + rows.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Return} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Return{"
        + "rows=" + rows
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Return} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable Return instance
   */
  public static <T> ImmutableReturn<T> copyOf(Return<T> instance) {
    if (instance instanceof ImmutableReturn<?>) {
      return (ImmutableReturn<T>) instance;
    }
    return ImmutableReturn.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReturn ImmutableReturn}.
   * <pre>
   * ImmutableReturn.&amp;lt;T&amp;gt;builder()
   *    .addRows|addAllRows(T) // {@link Return#getRows() rows} elements
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableReturn builder
   */
  public static <T> ImmutableReturn.Builder<T> builder() {
    return new ImmutableReturn.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableReturn ImmutableReturn}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Return", generator = "Immutables")
  @JacksonXmlRootElement(localName = "return")
  public static final class Builder<T> {
    private List<T> rows = new ArrayList<T>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Return} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(Return<T> instance) {
      Objects.requireNonNull(instance, "instance");
      addAllRows(instance.getRows());
      return this;
    }

    /**
     * Adds one element to {@link Return#getRows() rows} list.
     * @param element A rows element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addRows(T element) {
      this.rows.add(Objects.requireNonNull(element, "rows element"));
      return this;
    }

    /**
     * Adds elements to {@link Return#getRows() rows} list.
     * @param elements An array of rows elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<T> addRows(T... elements) {
      for (T element : elements) {
        this.rows.add(Objects.requireNonNull(element, "rows element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Return#getRows() rows} list.
     * @param elements An iterable of rows elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rows")
    @JacksonXmlElementWrapper(localName = "root")
    public final Builder<T> rows(Iterable<? extends T> elements) {
      this.rows.clear();
      return addAllRows(elements);
    }

    /**
     * Adds elements to {@link Return#getRows() rows} list.
     * @param elements An iterable of rows elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addAllRows(Iterable<? extends T> elements) {
      for (T element : elements) {
        this.rows.add(Objects.requireNonNull(element, "rows element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableReturn ImmutableReturn}.
     * @return An immutable instance of Return
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReturn<T> build() {
      return new ImmutableReturn<>(List.copyOf(rows));
    }
  }
}
