package zeenea.connector.sqlserver.services.ssas.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Restrictions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRestrictions.builder()}.
 */
@Generated(from = "Restrictions", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableRestrictions
    implements Restrictions {
  private final @Nullable RestrictionList restrictionList;

  private ImmutableRestrictions(
      @Nullable RestrictionList restrictionList) {
    this.restrictionList = restrictionList;
  }

  /**
   * @return The value of the {@code restrictionList} attribute
   */
  @JsonProperty("restrictionList")
  @JacksonXmlProperty(localName = "RestrictionList")
  @Override
  public @Nullable RestrictionList getRestrictionList() {
    return restrictionList;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Restrictions#getRestrictionList() restrictionList} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for restrictionList (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRestrictions withRestrictionList(@Nullable RestrictionList value) {
    if (this.restrictionList == value) return this;
    return new ImmutableRestrictions(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRestrictions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRestrictions
        && equalTo(0, (ImmutableRestrictions) another);
  }

  private boolean equalTo(int synthetic, ImmutableRestrictions another) {
    return Objects.equals(restrictionList, another.restrictionList);
  }

  /**
   * Computes a hash code from attributes: {@code restrictionList}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(restrictionList);
    return h;
  }

  /**
   * Prints the immutable value {@code Restrictions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Restrictions{"
        + "restrictionList=" + restrictionList
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Restrictions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Restrictions instance
   */
  public static ImmutableRestrictions copyOf(Restrictions instance) {
    if (instance instanceof ImmutableRestrictions) {
      return (ImmutableRestrictions) instance;
    }
    return ImmutableRestrictions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRestrictions ImmutableRestrictions}.
   * <pre>
   * ImmutableRestrictions.builder()
   *    .restrictionList(zeenea.connector.sqlserver.services.ssas.client.model.RestrictionList | null) // nullable {@link Restrictions#getRestrictionList() restrictionList}
   *    .build();
   * </pre>
   * @return A new ImmutableRestrictions builder
   */
  public static ImmutableRestrictions.Builder builder() {
    return new ImmutableRestrictions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRestrictions ImmutableRestrictions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Restrictions", generator = "Immutables")
  @JacksonXmlRootElement(localName = "Restrictions")
  public static final class Builder {
    private RestrictionList restrictionList;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Restrictions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Restrictions instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable RestrictionList restrictionListValue = instance.getRestrictionList();
      if (restrictionListValue != null) {
        restrictionList(restrictionListValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Restrictions#getRestrictionList() restrictionList} attribute.
     * @param restrictionList The value for restrictionList (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("restrictionList")
    @JacksonXmlProperty(localName = "RestrictionList")
    public final Builder restrictionList(@Nullable RestrictionList restrictionList) {
      this.restrictionList = restrictionList;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRestrictions ImmutableRestrictions}.
     * @return An immutable instance of Restrictions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRestrictions build() {
      return new ImmutableRestrictions(restrictionList);
    }
  }
}
