package zeenea.connector.sqlserver.services.ssas.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PropertyList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePropertyList.builder()}.
 */
@Generated(from = "PropertyList", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutablePropertyList
    implements PropertyList {
  private final String content;

  private ImmutablePropertyList(String content) {
    this.content = content;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty("content")
  @JacksonXmlProperty(localName = "Content")
  @Override
  public String getContent() {
    return content;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PropertyList#getContent() content} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePropertyList withContent(String value) {
    String newValue = Objects.requireNonNull(value, "content");
    if (this.content.equals(newValue)) return this;
    return new ImmutablePropertyList(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePropertyList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePropertyList
        && equalTo(0, (ImmutablePropertyList) another);
  }

  private boolean equalTo(int synthetic, ImmutablePropertyList another) {
    return content.equals(another.content);
  }

  /**
   * Computes a hash code from attributes: {@code content}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + content.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PropertyList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PropertyList{"
        + "content=" + content
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link PropertyList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PropertyList instance
   */
  public static ImmutablePropertyList copyOf(PropertyList instance) {
    if (instance instanceof ImmutablePropertyList) {
      return (ImmutablePropertyList) instance;
    }
    return ImmutablePropertyList.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePropertyList ImmutablePropertyList}.
   * <pre>
   * ImmutablePropertyList.builder()
   *    .content(String) // required {@link PropertyList#getContent() content}
   *    .build();
   * </pre>
   * @return A new ImmutablePropertyList builder
   */
  public static ImmutablePropertyList.Builder builder() {
    return new ImmutablePropertyList.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePropertyList ImmutablePropertyList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PropertyList", generator = "Immutables")
  @JacksonXmlRootElement(localName = "PropertyList")
  public static final class Builder {
    private static final long INIT_BIT_CONTENT = 0x1L;
    private long initBits = 0x1L;

    private String content;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PropertyList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PropertyList instance) {
      Objects.requireNonNull(instance, "instance");
      this.content(instance.getContent());
      return this;
    }

    /**
     * Initializes the value for the {@link PropertyList#getContent() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("content")
    @JacksonXmlProperty(localName = "Content")
    public final Builder content(String content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePropertyList ImmutablePropertyList}.
     * @return An immutable instance of PropertyList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePropertyList build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePropertyList(content);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      return "Cannot build PropertyList, some of required attributes are not set " + attributes;
    }
  }
}
