package zeenea.connector.sqlserver.services.ssas.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Properties}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProperties.builder()}.
 */
@Generated(from = "Properties", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableProperties
    implements Properties {
  private final PropertyList propertyList;

  private ImmutableProperties(PropertyList propertyList) {
    this.propertyList = propertyList;
  }

  /**
   * @return The value of the {@code propertyList} attribute
   */
  @JsonProperty("propertyList")
  @JacksonXmlProperty(localName = "PropertyList")
  @Override
  public PropertyList getPropertyList() {
    return propertyList;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Properties#getPropertyList() propertyList} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for propertyList
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProperties withPropertyList(PropertyList value) {
    if (this.propertyList == value) return this;
    PropertyList newValue = Objects.requireNonNull(value, "propertyList");
    return new ImmutableProperties(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProperties} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProperties
        && equalTo(0, (ImmutableProperties) another);
  }

  private boolean equalTo(int synthetic, ImmutableProperties another) {
    return propertyList.equals(another.propertyList);
  }

  /**
   * Computes a hash code from attributes: {@code propertyList}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + propertyList.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Properties} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Properties{"
        + "propertyList=" + propertyList
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Properties} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Properties instance
   */
  public static ImmutableProperties copyOf(Properties instance) {
    if (instance instanceof ImmutableProperties) {
      return (ImmutableProperties) instance;
    }
    return ImmutableProperties.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProperties ImmutableProperties}.
   * <pre>
   * ImmutableProperties.builder()
   *    .propertyList(zeenea.connector.sqlserver.services.ssas.client.model.PropertyList) // required {@link Properties#getPropertyList() propertyList}
   *    .build();
   * </pre>
   * @return A new ImmutableProperties builder
   */
  public static ImmutableProperties.Builder builder() {
    return new ImmutableProperties.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProperties ImmutableProperties}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Properties", generator = "Immutables")
  @JacksonXmlRootElement(localName = "Properties")
  public static final class Builder {
    private static final long INIT_BIT_PROPERTY_LIST = 0x1L;
    private long initBits = 0x1L;

    private PropertyList propertyList;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Properties} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Properties instance) {
      Objects.requireNonNull(instance, "instance");
      this.propertyList(instance.getPropertyList());
      return this;
    }

    /**
     * Initializes the value for the {@link Properties#getPropertyList() propertyList} attribute.
     * @param propertyList The value for propertyList 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("propertyList")
    @JacksonXmlProperty(localName = "PropertyList")
    public final Builder propertyList(PropertyList propertyList) {
      this.propertyList = Objects.requireNonNull(propertyList, "propertyList");
      initBits &= ~INIT_BIT_PROPERTY_LIST;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProperties ImmutableProperties}.
     * @return An immutable instance of Properties
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProperties build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProperties(propertyList);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROPERTY_LIST) != 0) attributes.add("propertyList");
      return "Cannot build Properties, some of required attributes are not set " + attributes;
    }
  }
}
