package zeenea.connector.sqlserver.services.ssas.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Error}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableError.builder()}.
 */
@Generated(from = "Error", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableError implements Error {
  private final @Nullable String code;
  private final @Nullable String description;
  private final @Nullable String source;
  private final @Nullable String helpFile;

  private ImmutableError(
      @Nullable String code,
      @Nullable String description,
      @Nullable String source,
      @Nullable String helpFile) {
    this.code = code;
    this.description = description;
    this.source = source;
    this.helpFile = helpFile;
  }

  /**
   * @return The value of the {@code code} attribute
   */
  @JsonProperty("code")
  @JacksonXmlProperty(localName = "ErrorCode", isAttribute = true)
  @Override
  public @Nullable String getCode() {
    return code;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @JacksonXmlProperty(localName = "Description", isAttribute = true)
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("source")
  @JacksonXmlProperty(localName = "Source", isAttribute = true)
  @Override
  public @Nullable String getSource() {
    return source;
  }

  /**
   * @return The value of the {@code helpFile} attribute
   */
  @JsonProperty("helpFile")
  @JacksonXmlProperty(localName = "HelpFile", isAttribute = true)
  @Override
  public @Nullable String getHelpFile() {
    return helpFile;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Error#getCode() code} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for code (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableError withCode(@Nullable String value) {
    if (Objects.equals(this.code, value)) return this;
    return new ImmutableError(value, this.description, this.source, this.helpFile);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Error#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableError withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableError(this.code, value, this.source, this.helpFile);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Error#getSource() source} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableError withSource(@Nullable String value) {
    if (Objects.equals(this.source, value)) return this;
    return new ImmutableError(this.code, this.description, value, this.helpFile);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Error#getHelpFile() helpFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for helpFile (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableError withHelpFile(@Nullable String value) {
    if (Objects.equals(this.helpFile, value)) return this;
    return new ImmutableError(this.code, this.description, this.source, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableError} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableError
        && equalTo(0, (ImmutableError) another);
  }

  private boolean equalTo(int synthetic, ImmutableError another) {
    return Objects.equals(code, another.code)
        && Objects.equals(description, another.description)
        && Objects.equals(source, another.source)
        && Objects.equals(helpFile, another.helpFile);
  }

  /**
   * Computes a hash code from attributes: {@code code}, {@code description}, {@code source}, {@code helpFile}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(code);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(source);
    h += (h << 5) + Objects.hashCode(helpFile);
    return h;
  }

  /**
   * Prints the immutable value {@code Error} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Error{"
        + "code=" + code
        + ", description=" + description
        + ", source=" + source
        + ", helpFile=" + helpFile
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Error} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Error instance
   */
  public static ImmutableError copyOf(Error instance) {
    if (instance instanceof ImmutableError) {
      return (ImmutableError) instance;
    }
    return ImmutableError.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableError ImmutableError}.
   * <pre>
   * ImmutableError.builder()
   *    .code(String | null) // nullable {@link Error#getCode() code}
   *    .description(String | null) // nullable {@link Error#getDescription() description}
   *    .source(String | null) // nullable {@link Error#getSource() source}
   *    .helpFile(String | null) // nullable {@link Error#getHelpFile() helpFile}
   *    .build();
   * </pre>
   * @return A new ImmutableError builder
   */
  public static ImmutableError.Builder builder() {
    return new ImmutableError.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableError ImmutableError}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Error", generator = "Immutables")
  @JacksonXmlRootElement(localName = "Error")
  public static final class Builder {
    private String code;
    private String description;
    private String source;
    private String helpFile;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Error} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Error instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String codeValue = instance.getCode();
      if (codeValue != null) {
        code(codeValue);
      }
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      @Nullable String sourceValue = instance.getSource();
      if (sourceValue != null) {
        source(sourceValue);
      }
      @Nullable String helpFileValue = instance.getHelpFile();
      if (helpFileValue != null) {
        helpFile(helpFileValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getCode() code} attribute.
     * @param code The value for code (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("code")
    @JacksonXmlProperty(localName = "ErrorCode", isAttribute = true)
    public final Builder code(@Nullable String code) {
      this.code = code;
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    @JacksonXmlProperty(localName = "Description", isAttribute = true)
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getSource() source} attribute.
     * @param source The value for source (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("source")
    @JacksonXmlProperty(localName = "Source", isAttribute = true)
    public final Builder source(@Nullable String source) {
      this.source = source;
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getHelpFile() helpFile} attribute.
     * @param helpFile The value for helpFile (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("helpFile")
    @JacksonXmlProperty(localName = "HelpFile", isAttribute = true)
    public final Builder helpFile(@Nullable String helpFile) {
      this.helpFile = helpFile;
      return this;
    }

    /**
     * Builds a new {@link ImmutableError ImmutableError}.
     * @return An immutable instance of Error
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableError build() {
      return new ImmutableError(code, description, source, helpFile);
    }
  }
}
