package zeenea.connector.sqlserver.services.ssas.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link DiscoverResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDiscoverResponse.builder()}.
 */
@Generated(from = "DiscoverResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDiscoverResponse<T>
    implements DiscoverResponse<T> {
  private final @Nullable Return<T> getReturn;

  private ImmutableDiscoverResponse(
      @Nullable Return<T> getReturn) {
    this.getReturn = getReturn;
  }

  /**
   * @return The value of the {@code getReturn} attribute
   */
  @JsonProperty("return")
  @JacksonXmlProperty(localName = "return")
  @Override
  public @Nullable Return<T> getReturn() {
    return getReturn;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DiscoverResponse#getReturn() return} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for getReturn (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiscoverResponse<T> withReturn(@Nullable Return<T> value) {
    if (this.getReturn == value) return this;
    return new ImmutableDiscoverResponse<>(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDiscoverResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDiscoverResponse<?>
        && equalTo(0, (ImmutableDiscoverResponse<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableDiscoverResponse<?> another) {
    return Objects.equals(getReturn, another.getReturn);
  }

  /**
   * Computes a hash code from attributes: {@code getReturn}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(getReturn);
    return h;
  }

  /**
   * Prints the immutable value {@code DiscoverResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DiscoverResponse{"
        + "return=" + getReturn
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DiscoverResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable DiscoverResponse instance
   */
  public static <T> ImmutableDiscoverResponse<T> copyOf(DiscoverResponse<T> instance) {
    if (instance instanceof ImmutableDiscoverResponse<?>) {
      return (ImmutableDiscoverResponse<T>) instance;
    }
    return ImmutableDiscoverResponse.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDiscoverResponse ImmutableDiscoverResponse}.
   * <pre>
   * ImmutableDiscoverResponse.&amp;lt;T&amp;gt;builder()
   *    .getReturn(zeenea.connector.sqlserver.services.ssas.client.model.Return&amp;lt;T&amp;gt; | null) // nullable {@link DiscoverResponse#getReturn() return}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableDiscoverResponse builder
   */
  public static <T> ImmutableDiscoverResponse.Builder<T> builder() {
    return new ImmutableDiscoverResponse.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableDiscoverResponse ImmutableDiscoverResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DiscoverResponse", generator = "Immutables")
  @JacksonXmlRootElement(localName = "DiscoverResponse")
  public static final class Builder<T> {
    private Return<T> getReturn;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DiscoverResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(DiscoverResponse<T> instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Return<T> getReturnValue = instance.getReturn();
      if (getReturnValue != null) {
        getReturn(getReturnValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DiscoverResponse#getReturn() return} attribute.
     * @param getReturn The value for getReturn (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("return")
    @JacksonXmlProperty(localName = "return")
    public final Builder<T> getReturn(@Nullable Return<T> getReturn) {
      this.getReturn = getReturn;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDiscoverResponse ImmutableDiscoverResponse}.
     * @return An immutable instance of DiscoverResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDiscoverResponse<T> build() {
      return new ImmutableDiscoverResponse<>(getReturn);
    }
  }
}
