package zeenea.connector.sqlserver.services.ssas.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Discover}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDiscover.builder()}.
 */
@Generated(from = "Discover", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDiscover implements Discover {
  private final String requestType;
  private final Restrictions restrictions;
  private final Properties properties;

  private ImmutableDiscover(
      String requestType,
      Restrictions restrictions,
      Properties properties) {
    this.requestType = requestType;
    this.restrictions = restrictions;
    this.properties = properties;
  }

  /**
   * @return The value of the {@code requestType} attribute
   */
  @JsonProperty("requestType")
  @JacksonXmlProperty(localName = "RequestType")
  @Override
  public String getRequestType() {
    return requestType;
  }

  /**
   * @return The value of the {@code restrictions} attribute
   */
  @JsonProperty("restrictions")
  @JacksonXmlProperty(localName = "Restrictions")
  @Override
  public Restrictions getRestrictions() {
    return restrictions;
  }

  /**
   * @return The value of the {@code properties} attribute
   */
  @JsonProperty("properties")
  @JacksonXmlProperty(localName = "Properties")
  @Override
  public Properties getProperties() {
    return properties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Discover#getRequestType() requestType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for requestType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiscover withRequestType(String value) {
    String newValue = Objects.requireNonNull(value, "requestType");
    if (this.requestType.equals(newValue)) return this;
    return new ImmutableDiscover(newValue, this.restrictions, this.properties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Discover#getRestrictions() restrictions} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for restrictions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiscover withRestrictions(Restrictions value) {
    if (this.restrictions == value) return this;
    Restrictions newValue = Objects.requireNonNull(value, "restrictions");
    return new ImmutableDiscover(this.requestType, newValue, this.properties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Discover#getProperties() properties} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for properties
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiscover withProperties(Properties value) {
    if (this.properties == value) return this;
    Properties newValue = Objects.requireNonNull(value, "properties");
    return new ImmutableDiscover(this.requestType, this.restrictions, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDiscover} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDiscover
        && equalTo(0, (ImmutableDiscover) another);
  }

  private boolean equalTo(int synthetic, ImmutableDiscover another) {
    return requestType.equals(another.requestType)
        && restrictions.equals(another.restrictions)
        && properties.equals(another.properties);
  }

  /**
   * Computes a hash code from attributes: {@code requestType}, {@code restrictions}, {@code properties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + requestType.hashCode();
    h += (h << 5) + restrictions.hashCode();
    h += (h << 5) + properties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Discover} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Discover{"
        + "requestType=" + requestType
        + ", restrictions=" + restrictions
        + ", properties=" + properties
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Discover} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Discover instance
   */
  public static ImmutableDiscover copyOf(Discover instance) {
    if (instance instanceof ImmutableDiscover) {
      return (ImmutableDiscover) instance;
    }
    return ImmutableDiscover.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDiscover ImmutableDiscover}.
   * <pre>
   * ImmutableDiscover.builder()
   *    .requestType(String) // required {@link Discover#getRequestType() requestType}
   *    .restrictions(zeenea.connector.sqlserver.services.ssas.client.model.Restrictions) // required {@link Discover#getRestrictions() restrictions}
   *    .properties(zeenea.connector.sqlserver.services.ssas.client.model.Properties) // required {@link Discover#getProperties() properties}
   *    .build();
   * </pre>
   * @return A new ImmutableDiscover builder
   */
  public static ImmutableDiscover.Builder builder() {
    return new ImmutableDiscover.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDiscover ImmutableDiscover}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Discover", generator = "Immutables")
  @JacksonXmlRootElement(localName = "Discover")
  public static final class Builder {
    private static final long INIT_BIT_REQUEST_TYPE = 0x1L;
    private static final long INIT_BIT_RESTRICTIONS = 0x2L;
    private static final long INIT_BIT_PROPERTIES = 0x4L;
    private long initBits = 0x7L;

    private String requestType;
    private Restrictions restrictions;
    private Properties properties;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Discover} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Discover instance) {
      Objects.requireNonNull(instance, "instance");
      this.requestType(instance.getRequestType());
      this.restrictions(instance.getRestrictions());
      this.properties(instance.getProperties());
      return this;
    }

    /**
     * Initializes the value for the {@link Discover#getRequestType() requestType} attribute.
     * @param requestType The value for requestType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("requestType")
    @JacksonXmlProperty(localName = "RequestType")
    public final Builder requestType(String requestType) {
      this.requestType = Objects.requireNonNull(requestType, "requestType");
      initBits &= ~INIT_BIT_REQUEST_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Discover#getRestrictions() restrictions} attribute.
     * @param restrictions The value for restrictions 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("restrictions")
    @JacksonXmlProperty(localName = "Restrictions")
    public final Builder restrictions(Restrictions restrictions) {
      this.restrictions = Objects.requireNonNull(restrictions, "restrictions");
      initBits &= ~INIT_BIT_RESTRICTIONS;
      return this;
    }

    /**
     * Initializes the value for the {@link Discover#getProperties() properties} attribute.
     * @param properties The value for properties 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("properties")
    @JacksonXmlProperty(localName = "Properties")
    public final Builder properties(Properties properties) {
      this.properties = Objects.requireNonNull(properties, "properties");
      initBits &= ~INIT_BIT_PROPERTIES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDiscover ImmutableDiscover}.
     * @return An immutable instance of Discover
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDiscover build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDiscover(requestType, restrictions, properties);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REQUEST_TYPE) != 0) attributes.add("requestType");
      if ((initBits & INIT_BIT_RESTRICTIONS) != 0) attributes.add("restrictions");
      if ((initBits & INIT_BIT_PROPERTIES) != 0) attributes.add("properties");
      return "Cannot build Discover, some of required attributes are not set " + attributes;
    }
  }
}
