package zeenea.connector.sqlserver.services.ssas.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link DataSource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDataSource.builder()}.
 */
@Generated(from = "DataSource", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDataSource
    implements DataSource {
  @NotNull
  private final String id;
  private final @Nullable String name;
  private final @Nullable String type;
  private final @Nullable String connectionString;
  private final @Nullable String connectionDetails;

  private ImmutableDataSource(
      String id,
      @Nullable String name,
      @Nullable String type,
      @Nullable String connectionString,
      @Nullable String connectionDetails) {
    this.id = id;
    this.name = name;
    this.type = type;
    this.connectionString = connectionString;
    this.connectionDetails = connectionDetails;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JacksonXmlProperty(localName = "ID")
  @NotNull
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JacksonXmlProperty(localName = "Name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @JacksonXmlProperty(localName = "Type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * @return The value of the {@code connectionString} attribute
   */
  @JsonProperty("connectionString")
  @JacksonXmlProperty(localName = "ConnectionString")
  @Override
  public @Nullable String getConnectionString() {
    return connectionString;
  }

  /**
   * @return The value of the {@code connectionDetails} attribute
   */
  @JsonProperty("connectionDetails")
  @JacksonXmlProperty(localName = "ConnectionDetails")
  @Override
  public @Nullable String getConnectionDetails() {
    return connectionDetails;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSource#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSource withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableDataSource(newValue, this.name, this.type, this.connectionString, this.connectionDetails);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSource#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSource withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableDataSource(this.id, value, this.type, this.connectionString, this.connectionDetails);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSource#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSource withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableDataSource(this.id, this.name, value, this.connectionString, this.connectionDetails);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSource#getConnectionString() connectionString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectionString (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSource withConnectionString(@Nullable String value) {
    if (Objects.equals(this.connectionString, value)) return this;
    return new ImmutableDataSource(this.id, this.name, this.type, value, this.connectionDetails);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSource#getConnectionDetails() connectionDetails} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectionDetails (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSource withConnectionDetails(@Nullable String value) {
    if (Objects.equals(this.connectionDetails, value)) return this;
    return new ImmutableDataSource(this.id, this.name, this.type, this.connectionString, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDataSource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDataSource
        && equalTo(0, (ImmutableDataSource) another);
  }

  private boolean equalTo(int synthetic, ImmutableDataSource another) {
    return id.equals(another.id)
        && Objects.equals(name, another.name)
        && Objects.equals(type, another.type)
        && Objects.equals(connectionString, another.connectionString)
        && Objects.equals(connectionDetails, another.connectionDetails);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code type}, {@code connectionString}, {@code connectionDetails}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(connectionString);
    h += (h << 5) + Objects.hashCode(connectionDetails);
    return h;
  }

  /**
   * Prints the immutable value {@code DataSource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DataSource{"
        + "id=" + id
        + ", name=" + name
        + ", type=" + type
        + ", connectionString=" + connectionString
        + ", connectionDetails=" + connectionDetails
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DataSource", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DataSource {
    String id;
    String name;
    String type;
    String connectionString;
    String connectionDetails;
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("type")
    @JacksonXmlProperty(localName = "Type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty("connectionString")
    @JacksonXmlProperty(localName = "ConnectionString")
    public void setConnectionString(@Nullable String connectionString) {
      this.connectionString = connectionString;
    }
    @JsonProperty("connectionDetails")
    @JacksonXmlProperty(localName = "ConnectionDetails")
    public void setConnectionDetails(@Nullable String connectionDetails) {
      this.connectionDetails = connectionDetails;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getConnectionString() { throw new UnsupportedOperationException(); }
    @Override
    public String getConnectionDetails() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDataSource fromJson(Json json) {
    ImmutableDataSource.Builder builder = ImmutableDataSource.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.connectionString != null) {
      builder.connectionString(json.connectionString);
    }
    if (json.connectionDetails != null) {
      builder.connectionDetails(json.connectionDetails);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DataSource} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DataSource instance
   */
  public static ImmutableDataSource copyOf(DataSource instance) {
    if (instance instanceof ImmutableDataSource) {
      return (ImmutableDataSource) instance;
    }
    return ImmutableDataSource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDataSource ImmutableDataSource}.
   * <pre>
   * ImmutableDataSource.builder()
   *    .id(String) // required {@link DataSource#getId() id}
   *    .name(String | null) // nullable {@link DataSource#getName() name}
   *    .type(String | null) // nullable {@link DataSource#getType() type}
   *    .connectionString(String | null) // nullable {@link DataSource#getConnectionString() connectionString}
   *    .connectionDetails(String | null) // nullable {@link DataSource#getConnectionDetails() connectionDetails}
   *    .build();
   * </pre>
   * @return A new ImmutableDataSource builder
   */
  public static ImmutableDataSource.Builder builder() {
    return new ImmutableDataSource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDataSource ImmutableDataSource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DataSource", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private String id;
    private String name;
    private String type;
    private String connectionString;
    private String connectionDetails;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DataSource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DataSource instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      @Nullable String connectionStringValue = instance.getConnectionString();
      if (connectionStringValue != null) {
        connectionString(connectionStringValue);
      }
      @Nullable String connectionDetailsValue = instance.getConnectionDetails();
      if (connectionDetailsValue != null) {
        connectionDetails(connectionDetailsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DataSource#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DataSource#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link DataSource#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    @JacksonXmlProperty(localName = "Type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link DataSource#getConnectionString() connectionString} attribute.
     * @param connectionString The value for connectionString (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("connectionString")
    @JacksonXmlProperty(localName = "ConnectionString")
    public final Builder connectionString(@Nullable String connectionString) {
      this.connectionString = connectionString;
      return this;
    }

    /**
     * Initializes the value for the {@link DataSource#getConnectionDetails() connectionDetails} attribute.
     * @param connectionDetails The value for connectionDetails (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("connectionDetails")
    @JacksonXmlProperty(localName = "ConnectionDetails")
    public final Builder connectionDetails(@Nullable String connectionDetails) {
      this.connectionDetails = connectionDetails;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDataSource ImmutableDataSource}.
     * @return An immutable instance of DataSource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDataSource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDataSource(id, name, type, connectionString, connectionDetails);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build DataSource, some of required attributes are not set " + attributes;
    }
  }
}
