package zeenea.connector.sqlserver.services.ssas.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Field}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableField.builder()}.
 */
@Generated(from = "Field", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableField implements Field {
  @NotNull
  private final String name;
  @NotNull
  private final String type;
  @NotNull
  private final CubeFieldType cubeFieldType;
  private final @Nullable Integer length;
  private final @Nullable String description;
  private final @Nullable Boolean nullable;
  private final @Nullable String measureGroup;
  private final @Nullable String aggregateFunction;
  private final @Nullable String tableBinding;
  private final @Nullable String columnBinding;

  private ImmutableField(
      String name,
      String type,
      CubeFieldType cubeFieldType,
      @Nullable Integer length,
      @Nullable String description,
      @Nullable Boolean nullable,
      @Nullable String measureGroup,
      @Nullable String aggregateFunction,
      @Nullable String tableBinding,
      @Nullable String columnBinding) {
    this.name = name;
    this.type = type;
    this.cubeFieldType = cubeFieldType;
    this.length = length;
    this.description = description;
    this.nullable = nullable;
    this.measureGroup = measureGroup;
    this.aggregateFunction = aggregateFunction;
    this.tableBinding = tableBinding;
    this.columnBinding = columnBinding;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @NotNull
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @NotNull
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code cubeFieldType} attribute
   */
  @JsonProperty("cubeFieldType")
  @NotNull
  @Override
  public CubeFieldType getCubeFieldType() {
    return cubeFieldType;
  }

  /**
   * @return The value of the {@code length} attribute
   */
  @JsonProperty("length")
  @Override
  public @Nullable Integer getLength() {
    return length;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code nullable} attribute
   */
  @JsonProperty("nullable")
  @Override
  public @Nullable Boolean getNullable() {
    return nullable;
  }

  /**
   * @return The value of the {@code measureGroup} attribute
   */
  @JsonProperty("measureGroup")
  @Override
  public @Nullable String getMeasureGroup() {
    return measureGroup;
  }

  /**
   * @return The value of the {@code aggregateFunction} attribute
   */
  @JsonProperty("aggregateFunction")
  @Override
  public @Nullable String getAggregateFunction() {
    return aggregateFunction;
  }

  /**
   * @return The value of the {@code tableBinding} attribute
   */
  @JsonProperty("tableBinding")
  @Override
  public @Nullable String getTableBinding() {
    return tableBinding;
  }

  /**
   * @return The value of the {@code columnBinding} attribute
   */
  @JsonProperty("columnBinding")
  @Override
  public @Nullable String getColumnBinding() {
    return columnBinding;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableField(
        newValue,
        this.type,
        this.cubeFieldType,
        this.length,
        this.description,
        this.nullable,
        this.measureGroup,
        this.aggregateFunction,
        this.tableBinding,
        this.columnBinding);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableField(
        this.name,
        newValue,
        this.cubeFieldType,
        this.length,
        this.description,
        this.nullable,
        this.measureGroup,
        this.aggregateFunction,
        this.tableBinding,
        this.columnBinding);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getCubeFieldType() cubeFieldType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cubeFieldType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withCubeFieldType(CubeFieldType value) {
    CubeFieldType newValue = Objects.requireNonNull(value, "cubeFieldType");
    if (this.cubeFieldType == newValue) return this;
    return new ImmutableField(
        this.name,
        this.type,
        newValue,
        this.length,
        this.description,
        this.nullable,
        this.measureGroup,
        this.aggregateFunction,
        this.tableBinding,
        this.columnBinding);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getLength() length} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for length (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withLength(@Nullable Integer value) {
    if (Objects.equals(this.length, value)) return this;
    return new ImmutableField(
        this.name,
        this.type,
        this.cubeFieldType,
        value,
        this.description,
        this.nullable,
        this.measureGroup,
        this.aggregateFunction,
        this.tableBinding,
        this.columnBinding);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableField(
        this.name,
        this.type,
        this.cubeFieldType,
        this.length,
        value,
        this.nullable,
        this.measureGroup,
        this.aggregateFunction,
        this.tableBinding,
        this.columnBinding);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getNullable() nullable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withNullable(@Nullable Boolean value) {
    if (Objects.equals(this.nullable, value)) return this;
    return new ImmutableField(
        this.name,
        this.type,
        this.cubeFieldType,
        this.length,
        this.description,
        value,
        this.measureGroup,
        this.aggregateFunction,
        this.tableBinding,
        this.columnBinding);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getMeasureGroup() measureGroup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for measureGroup (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withMeasureGroup(@Nullable String value) {
    if (Objects.equals(this.measureGroup, value)) return this;
    return new ImmutableField(
        this.name,
        this.type,
        this.cubeFieldType,
        this.length,
        this.description,
        this.nullable,
        value,
        this.aggregateFunction,
        this.tableBinding,
        this.columnBinding);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getAggregateFunction() aggregateFunction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for aggregateFunction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withAggregateFunction(@Nullable String value) {
    if (Objects.equals(this.aggregateFunction, value)) return this;
    return new ImmutableField(
        this.name,
        this.type,
        this.cubeFieldType,
        this.length,
        this.description,
        this.nullable,
        this.measureGroup,
        value,
        this.tableBinding,
        this.columnBinding);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getTableBinding() tableBinding} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tableBinding (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withTableBinding(@Nullable String value) {
    if (Objects.equals(this.tableBinding, value)) return this;
    return new ImmutableField(
        this.name,
        this.type,
        this.cubeFieldType,
        this.length,
        this.description,
        this.nullable,
        this.measureGroup,
        this.aggregateFunction,
        value,
        this.columnBinding);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getColumnBinding() columnBinding} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for columnBinding (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withColumnBinding(@Nullable String value) {
    if (Objects.equals(this.columnBinding, value)) return this;
    return new ImmutableField(
        this.name,
        this.type,
        this.cubeFieldType,
        this.length,
        this.description,
        this.nullable,
        this.measureGroup,
        this.aggregateFunction,
        this.tableBinding,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableField} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableField
        && equalTo(0, (ImmutableField) another);
  }

  private boolean equalTo(int synthetic, ImmutableField another) {
    return name.equals(another.name)
        && type.equals(another.type)
        && cubeFieldType.equals(another.cubeFieldType)
        && Objects.equals(length, another.length)
        && Objects.equals(description, another.description)
        && Objects.equals(nullable, another.nullable)
        && Objects.equals(measureGroup, another.measureGroup)
        && Objects.equals(aggregateFunction, another.aggregateFunction)
        && Objects.equals(tableBinding, another.tableBinding)
        && Objects.equals(columnBinding, another.columnBinding);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code type}, {@code cubeFieldType}, {@code length}, {@code description}, {@code nullable}, {@code measureGroup}, {@code aggregateFunction}, {@code tableBinding}, {@code columnBinding}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + cubeFieldType.hashCode();
    h += (h << 5) + Objects.hashCode(length);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(nullable);
    h += (h << 5) + Objects.hashCode(measureGroup);
    h += (h << 5) + Objects.hashCode(aggregateFunction);
    h += (h << 5) + Objects.hashCode(tableBinding);
    h += (h << 5) + Objects.hashCode(columnBinding);
    return h;
  }

  /**
   * Prints the immutable value {@code Field} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Field{"
        + "name=" + name
        + ", type=" + type
        + ", cubeFieldType=" + cubeFieldType
        + ", length=" + length
        + ", description=" + description
        + ", nullable=" + nullable
        + ", measureGroup=" + measureGroup
        + ", aggregateFunction=" + aggregateFunction
        + ", tableBinding=" + tableBinding
        + ", columnBinding=" + columnBinding
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Field", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Field {
    String name;
    String type;
    CubeFieldType cubeFieldType;
    Integer length;
    String description;
    Boolean nullable;
    String measureGroup;
    String aggregateFunction;
    String tableBinding;
    String columnBinding;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("cubeFieldType")
    public void setCubeFieldType(CubeFieldType cubeFieldType) {
      this.cubeFieldType = cubeFieldType;
    }
    @JsonProperty("length")
    public void setLength(@Nullable Integer length) {
      this.length = length;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("nullable")
    public void setNullable(@Nullable Boolean nullable) {
      this.nullable = nullable;
    }
    @JsonProperty("measureGroup")
    public void setMeasureGroup(@Nullable String measureGroup) {
      this.measureGroup = measureGroup;
    }
    @JsonProperty("aggregateFunction")
    public void setAggregateFunction(@Nullable String aggregateFunction) {
      this.aggregateFunction = aggregateFunction;
    }
    @JsonProperty("tableBinding")
    public void setTableBinding(@Nullable String tableBinding) {
      this.tableBinding = tableBinding;
    }
    @JsonProperty("columnBinding")
    public void setColumnBinding(@Nullable String columnBinding) {
      this.columnBinding = columnBinding;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public CubeFieldType getCubeFieldType() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getLength() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getNullable() { throw new UnsupportedOperationException(); }
    @Override
    public String getMeasureGroup() { throw new UnsupportedOperationException(); }
    @Override
    public String getAggregateFunction() { throw new UnsupportedOperationException(); }
    @Override
    public String getTableBinding() { throw new UnsupportedOperationException(); }
    @Override
    public String getColumnBinding() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableField fromJson(Json json) {
    ImmutableField.Builder builder = ImmutableField.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.cubeFieldType != null) {
      builder.cubeFieldType(json.cubeFieldType);
    }
    if (json.length != null) {
      builder.length(json.length);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.nullable != null) {
      builder.nullable(json.nullable);
    }
    if (json.measureGroup != null) {
      builder.measureGroup(json.measureGroup);
    }
    if (json.aggregateFunction != null) {
      builder.aggregateFunction(json.aggregateFunction);
    }
    if (json.tableBinding != null) {
      builder.tableBinding(json.tableBinding);
    }
    if (json.columnBinding != null) {
      builder.columnBinding(json.columnBinding);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Field} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Field instance
   */
  public static ImmutableField copyOf(Field instance) {
    if (instance instanceof ImmutableField) {
      return (ImmutableField) instance;
    }
    return ImmutableField.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableField ImmutableField}.
   * <pre>
   * ImmutableField.builder()
   *    .name(String) // required {@link Field#getName() name}
   *    .type(String) // required {@link Field#getType() type}
   *    .cubeFieldType(zeenea.connector.sqlserver.services.ssas.client.CubeFieldType) // required {@link Field#getCubeFieldType() cubeFieldType}
   *    .length(Integer | null) // nullable {@link Field#getLength() length}
   *    .description(String | null) // nullable {@link Field#getDescription() description}
   *    .nullable(Boolean | null) // nullable {@link Field#getNullable() nullable}
   *    .measureGroup(String | null) // nullable {@link Field#getMeasureGroup() measureGroup}
   *    .aggregateFunction(String | null) // nullable {@link Field#getAggregateFunction() aggregateFunction}
   *    .tableBinding(String | null) // nullable {@link Field#getTableBinding() tableBinding}
   *    .columnBinding(String | null) // nullable {@link Field#getColumnBinding() columnBinding}
   *    .build();
   * </pre>
   * @return A new ImmutableField builder
   */
  public static ImmutableField.Builder builder() {
    return new ImmutableField.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableField ImmutableField}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Field", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_CUBE_FIELD_TYPE = 0x4L;
    private long initBits = 0x7L;

    private String name;
    private String type;
    private CubeFieldType cubeFieldType;
    private Integer length;
    private String description;
    private Boolean nullable;
    private String measureGroup;
    private String aggregateFunction;
    private String tableBinding;
    private String columnBinding;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Field} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Field instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.type(instance.getType());
      this.cubeFieldType(instance.getCubeFieldType());
      @Nullable Integer lengthValue = instance.getLength();
      if (lengthValue != null) {
        length(lengthValue);
      }
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      @Nullable Boolean nullableValue = instance.getNullable();
      if (nullableValue != null) {
        nullable(nullableValue);
      }
      @Nullable String measureGroupValue = instance.getMeasureGroup();
      if (measureGroupValue != null) {
        measureGroup(measureGroupValue);
      }
      @Nullable String aggregateFunctionValue = instance.getAggregateFunction();
      if (aggregateFunctionValue != null) {
        aggregateFunction(aggregateFunctionValue);
      }
      @Nullable String tableBindingValue = instance.getTableBinding();
      if (tableBindingValue != null) {
        tableBinding(tableBindingValue);
      }
      @Nullable String columnBindingValue = instance.getColumnBinding();
      if (columnBindingValue != null) {
        columnBinding(columnBindingValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getCubeFieldType() cubeFieldType} attribute.
     * @param cubeFieldType The value for cubeFieldType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("cubeFieldType")
    public final Builder cubeFieldType(CubeFieldType cubeFieldType) {
      this.cubeFieldType = Objects.requireNonNull(cubeFieldType, "cubeFieldType");
      initBits &= ~INIT_BIT_CUBE_FIELD_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getLength() length} attribute.
     * @param length The value for length (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("length")
    public final Builder length(@Nullable Integer length) {
      this.length = length;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getNullable() nullable} attribute.
     * @param nullable The value for nullable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nullable")
    public final Builder nullable(@Nullable Boolean nullable) {
      this.nullable = nullable;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getMeasureGroup() measureGroup} attribute.
     * @param measureGroup The value for measureGroup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("measureGroup")
    public final Builder measureGroup(@Nullable String measureGroup) {
      this.measureGroup = measureGroup;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getAggregateFunction() aggregateFunction} attribute.
     * @param aggregateFunction The value for aggregateFunction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("aggregateFunction")
    public final Builder aggregateFunction(@Nullable String aggregateFunction) {
      this.aggregateFunction = aggregateFunction;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getTableBinding() tableBinding} attribute.
     * @param tableBinding The value for tableBinding (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tableBinding")
    public final Builder tableBinding(@Nullable String tableBinding) {
      this.tableBinding = tableBinding;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getColumnBinding() columnBinding} attribute.
     * @param columnBinding The value for columnBinding (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("columnBinding")
    public final Builder columnBinding(@Nullable String columnBinding) {
      this.columnBinding = columnBinding;
      return this;
    }

    /**
     * Builds a new {@link ImmutableField ImmutableField}.
     * @return An immutable instance of Field
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableField build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableField(
          name,
          type,
          cubeFieldType,
          length,
          description,
          nullable,
          measureGroup,
          aggregateFunction,
          tableBinding,
          columnBinding);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_CUBE_FIELD_TYPE) != 0) attributes.add("cubeFieldType");
      return "Cannot build Field, some of required attributes are not set " + attributes;
    }
  }
}
