package zeenea.connector.sqlserver.services.ssas.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link DatasetLink}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDatasetLink.builder()}.
 */
@Generated(from = "DatasetLink", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDatasetLink implements DatasetLink {
  @NotNull
  private final DatasetLinkType type;
  @NotNull
  private final List<String> path;
  private final @Nullable String connectionCode;

  private ImmutableDatasetLink(
      DatasetLinkType type,
      List<String> path,
      @Nullable String connectionCode) {
    this.type = type;
    this.path = path;
    this.connectionCode = connectionCode;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @NotNull
  @Override
  public DatasetLinkType getType() {
    return type;
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @NotNull
  @Override
  public List<String> getPath() {
    return path;
  }

  /**
   * @return The value of the {@code connectionCode} attribute
   */
  @Override
  public @Nullable String getConnectionCode() {
    return connectionCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DatasetLink#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDatasetLink withType(DatasetLinkType value) {
    DatasetLinkType newValue = Objects.requireNonNull(value, "type");
    if (this.type == newValue) return this;
    return new ImmutableDatasetLink(newValue, this.path, this.connectionCode);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DatasetLink#getPath() path}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDatasetLink withPath(String... elements) {
    List<String> newValue = List.of(elements);
    return new ImmutableDatasetLink(this.type, newValue, this.connectionCode);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DatasetLink#getPath() path}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of path elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDatasetLink withPath(Iterable<String> elements) {
    if (this.path == elements) return this;
    List<String> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<String>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDatasetLink(this.type, newValue, this.connectionCode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DatasetLink#getConnectionCode() connectionCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectionCode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDatasetLink withConnectionCode(@Nullable String value) {
    if (Objects.equals(this.connectionCode, value)) return this;
    return new ImmutableDatasetLink(this.type, this.path, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDatasetLink} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDatasetLink
        && equalTo(0, (ImmutableDatasetLink) another);
  }

  private boolean equalTo(int synthetic, ImmutableDatasetLink another) {
    return type.equals(another.type)
        && path.equals(another.path)
        && Objects.equals(connectionCode, another.connectionCode);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code path}, {@code connectionCode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + path.hashCode();
    h += (h << 5) + Objects.hashCode(connectionCode);
    return h;
  }

  /**
   * Prints the immutable value {@code DatasetLink} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DatasetLink{"
        + "type=" + type
        + ", path=" + path
        + ", connectionCode=" + connectionCode
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DatasetLink} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DatasetLink instance
   */
  public static ImmutableDatasetLink copyOf(DatasetLink instance) {
    if (instance instanceof ImmutableDatasetLink) {
      return (ImmutableDatasetLink) instance;
    }
    return ImmutableDatasetLink.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDatasetLink ImmutableDatasetLink}.
   * <pre>
   * ImmutableDatasetLink.builder()
   *    .type(zeenea.connector.sqlserver.services.ssas.client.DatasetLinkType) // required {@link DatasetLink#getType() type}
   *    .addPath|addAllPath(String) // {@link DatasetLink#getPath() path} elements
   *    .connectionCode(String | null) // nullable {@link DatasetLink#getConnectionCode() connectionCode}
   *    .build();
   * </pre>
   * @return A new ImmutableDatasetLink builder
   */
  public static ImmutableDatasetLink.Builder builder() {
    return new ImmutableDatasetLink.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDatasetLink ImmutableDatasetLink}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DatasetLink", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private DatasetLinkType type;
    private List<String> path = new ArrayList<String>();
    private String connectionCode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DatasetLink} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DatasetLink instance) {
      Objects.requireNonNull(instance, "instance");
      this.type(instance.getType());
      addAllPath(instance.getPath());
      @Nullable String connectionCodeValue = instance.getConnectionCode();
      if (connectionCodeValue != null) {
        connectionCode(connectionCodeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DatasetLink#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(DatasetLinkType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Adds one element to {@link DatasetLink#getPath() path} list.
     * @param element A path element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPath(String element) {
      this.path.add(Objects.requireNonNull(element, "path element"));
      return this;
    }

    /**
     * Adds elements to {@link DatasetLink#getPath() path} list.
     * @param elements An array of path elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPath(String... elements) {
      for (String element : elements) {
        this.path.add(Objects.requireNonNull(element, "path element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DatasetLink#getPath() path} list.
     * @param elements An iterable of path elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(Iterable<String> elements) {
      this.path.clear();
      return addAllPath(elements);
    }

    /**
     * Adds elements to {@link DatasetLink#getPath() path} list.
     * @param elements An iterable of path elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPath(Iterable<String> elements) {
      for (String element : elements) {
        this.path.add(Objects.requireNonNull(element, "path element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DatasetLink#getConnectionCode() connectionCode} attribute.
     * @param connectionCode The value for connectionCode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectionCode(@Nullable String connectionCode) {
      this.connectionCode = connectionCode;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDatasetLink ImmutableDatasetLink}.
     * @return An immutable instance of DatasetLink
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDatasetLink build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDatasetLink(type, List.copyOf(path), connectionCode);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build DatasetLink, some of required attributes are not set " + attributes;
    }
  }
}
