package zeenea.connector.sqlserver.services.ssas.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.sqlserver.services.ssas.ItemRef;

/**
 * Immutable implementation of {@link Dataset}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDataset.builder()}.
 */
@Generated(from = "Dataset", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDataset implements Dataset {
  @NotNull
  private final ItemRef reference;
  private final @Nullable String description;
  private final @Nullable Instant createdDate;
  private final @Nullable Instant updatedDate;
  @NotNull
  private final List<Field> fields;
  @NotNull
  private final List<DataProcess> dataProcesses;

  private ImmutableDataset(
      ItemRef reference,
      @Nullable String description,
      @Nullable Instant createdDate,
      @Nullable Instant updatedDate,
      List<Field> fields,
      List<DataProcess> dataProcesses) {
    this.reference = reference;
    this.description = description;
    this.createdDate = createdDate;
    this.updatedDate = updatedDate;
    this.fields = fields;
    this.dataProcesses = dataProcesses;
  }

  /**
   * @return The value of the {@code reference} attribute
   */
  @JsonProperty("reference")
  @NotNull
  @Override
  public ItemRef getReference() {
    return reference;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code createdDate} attribute
   */
  @JsonProperty("createdDate")
  @Override
  public @Nullable Instant getCreatedDate() {
    return createdDate;
  }

  /**
   * @return The value of the {@code updatedDate} attribute
   */
  @JsonProperty("updatedDate")
  @Override
  public @Nullable Instant getUpdatedDate() {
    return updatedDate;
  }

  /**
   * @return The value of the {@code fields} attribute
   */
  @JsonProperty("fields")
  @NotNull
  @Override
  public List<Field> getFields() {
    return fields;
  }

  /**
   * @return The value of the {@code dataProcesses} attribute
   */
  @JsonProperty("dataProcesses")
  @NotNull
  @Override
  public List<DataProcess> getDataProcesses() {
    return dataProcesses;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Dataset#getReference() reference} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reference
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataset withReference(ItemRef value) {
    if (this.reference == value) return this;
    ItemRef newValue = Objects.requireNonNull(value, "reference");
    return new ImmutableDataset(newValue, this.description, this.createdDate, this.updatedDate, this.fields, this.dataProcesses);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Dataset#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataset withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableDataset(this.reference, value, this.createdDate, this.updatedDate, this.fields, this.dataProcesses);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Dataset#getCreatedDate() createdDate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdDate (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataset withCreatedDate(@Nullable Instant value) {
    if (this.createdDate == value) return this;
    return new ImmutableDataset(this.reference, this.description, value, this.updatedDate, this.fields, this.dataProcesses);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Dataset#getUpdatedDate() updatedDate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedDate (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataset withUpdatedDate(@Nullable Instant value) {
    if (this.updatedDate == value) return this;
    return new ImmutableDataset(this.reference, this.description, this.createdDate, value, this.fields, this.dataProcesses);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Dataset#getFields() fields}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataset withFields(Field... elements) {
    List<Field> newValue = List.of(elements);
    return new ImmutableDataset(
        this.reference,
        this.description,
        this.createdDate,
        this.updatedDate,
        newValue,
        this.dataProcesses);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Dataset#getFields() fields}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fields elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataset withFields(Iterable<? extends Field> elements) {
    if (this.fields == elements) return this;
    List<Field> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Field>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDataset(
        this.reference,
        this.description,
        this.createdDate,
        this.updatedDate,
        newValue,
        this.dataProcesses);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Dataset#getDataProcesses() dataProcesses}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataset withDataProcesses(DataProcess... elements) {
    List<DataProcess> newValue = List.of(elements);
    return new ImmutableDataset(this.reference, this.description, this.createdDate, this.updatedDate, this.fields, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Dataset#getDataProcesses() dataProcesses}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dataProcesses elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataset withDataProcesses(Iterable<? extends DataProcess> elements) {
    if (this.dataProcesses == elements) return this;
    List<DataProcess> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends DataProcess>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDataset(this.reference, this.description, this.createdDate, this.updatedDate, this.fields, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDataset} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDataset
        && equalTo(0, (ImmutableDataset) another);
  }

  private boolean equalTo(int synthetic, ImmutableDataset another) {
    return reference.equals(another.reference)
        && Objects.equals(description, another.description)
        && Objects.equals(createdDate, another.createdDate)
        && Objects.equals(updatedDate, another.updatedDate)
        && fields.equals(another.fields)
        && dataProcesses.equals(another.dataProcesses);
  }

  /**
   * Computes a hash code from attributes: {@code reference}, {@code description}, {@code createdDate}, {@code updatedDate}, {@code fields}, {@code dataProcesses}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + reference.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(createdDate);
    h += (h << 5) + Objects.hashCode(updatedDate);
    h += (h << 5) + fields.hashCode();
    h += (h << 5) + dataProcesses.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Dataset} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Dataset{"
        + "reference=" + reference
        + ", description=" + description
        + ", createdDate=" + createdDate
        + ", updatedDate=" + updatedDate
        + ", fields=" + fields
        + ", dataProcesses=" + dataProcesses
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Dataset", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Dataset {
    ItemRef reference;
    String description;
    Instant createdDate;
    Instant updatedDate;
    List<Field> fields = List.of();
    List<DataProcess> dataProcesses = List.of();
    @JsonProperty("reference")
    public void setReference(ItemRef reference) {
      this.reference = reference;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("createdDate")
    public void setCreatedDate(@Nullable Instant createdDate) {
      this.createdDate = createdDate;
    }
    @JsonProperty("updatedDate")
    public void setUpdatedDate(@Nullable Instant updatedDate) {
      this.updatedDate = updatedDate;
    }
    @JsonProperty("fields")
    public void setFields(List<Field> fields) {
      this.fields = fields;
    }
    @JsonProperty("dataProcesses")
    public void setDataProcesses(List<DataProcess> dataProcesses) {
      this.dataProcesses = dataProcesses;
    }
    @Override
    public ItemRef getReference() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public Instant getCreatedDate() { throw new UnsupportedOperationException(); }
    @Override
    public Instant getUpdatedDate() { throw new UnsupportedOperationException(); }
    @Override
    public List<Field> getFields() { throw new UnsupportedOperationException(); }
    @Override
    public List<DataProcess> getDataProcesses() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDataset fromJson(Json json) {
    ImmutableDataset.Builder builder = ImmutableDataset.builder();
    if (json.reference != null) {
      builder.reference(json.reference);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.createdDate != null) {
      builder.createdDate(json.createdDate);
    }
    if (json.updatedDate != null) {
      builder.updatedDate(json.updatedDate);
    }
    if (json.fields != null) {
      builder.addAllFields(json.fields);
    }
    if (json.dataProcesses != null) {
      builder.addAllDataProcesses(json.dataProcesses);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Dataset} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Dataset instance
   */
  public static ImmutableDataset copyOf(Dataset instance) {
    if (instance instanceof ImmutableDataset) {
      return (ImmutableDataset) instance;
    }
    return ImmutableDataset.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDataset ImmutableDataset}.
   * <pre>
   * ImmutableDataset.builder()
   *    .reference(zeenea.connector.sqlserver.services.ssas.ItemRef) // required {@link Dataset#getReference() reference}
   *    .description(String | null) // nullable {@link Dataset#getDescription() description}
   *    .createdDate(java.time.Instant | null) // nullable {@link Dataset#getCreatedDate() createdDate}
   *    .updatedDate(java.time.Instant | null) // nullable {@link Dataset#getUpdatedDate() updatedDate}
   *    .addFields|addAllFields(zeenea.connector.sqlserver.services.ssas.client.Field) // {@link Dataset#getFields() fields} elements
   *    .addDataProcesses|addAllDataProcesses(zeenea.connector.sqlserver.services.ssas.client.DataProcess) // {@link Dataset#getDataProcesses() dataProcesses} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDataset builder
   */
  public static ImmutableDataset.Builder builder() {
    return new ImmutableDataset.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDataset ImmutableDataset}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Dataset", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_REFERENCE = 0x1L;
    private long initBits = 0x1L;

    private ItemRef reference;
    private String description;
    private Instant createdDate;
    private Instant updatedDate;
    private List<Field> fields = new ArrayList<Field>();
    private List<DataProcess> dataProcesses = new ArrayList<DataProcess>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Dataset} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Dataset instance) {
      Objects.requireNonNull(instance, "instance");
      this.reference(instance.getReference());
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      @Nullable Instant createdDateValue = instance.getCreatedDate();
      if (createdDateValue != null) {
        createdDate(createdDateValue);
      }
      @Nullable Instant updatedDateValue = instance.getUpdatedDate();
      if (updatedDateValue != null) {
        updatedDate(updatedDateValue);
      }
      addAllFields(instance.getFields());
      addAllDataProcesses(instance.getDataProcesses());
      return this;
    }

    /**
     * Initializes the value for the {@link Dataset#getReference() reference} attribute.
     * @param reference The value for reference 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("reference")
    public final Builder reference(ItemRef reference) {
      this.reference = Objects.requireNonNull(reference, "reference");
      initBits &= ~INIT_BIT_REFERENCE;
      return this;
    }

    /**
     * Initializes the value for the {@link Dataset#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Dataset#getCreatedDate() createdDate} attribute.
     * @param createdDate The value for createdDate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("createdDate")
    public final Builder createdDate(@Nullable Instant createdDate) {
      this.createdDate = createdDate;
      return this;
    }

    /**
     * Initializes the value for the {@link Dataset#getUpdatedDate() updatedDate} attribute.
     * @param updatedDate The value for updatedDate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updatedDate")
    public final Builder updatedDate(@Nullable Instant updatedDate) {
      this.updatedDate = updatedDate;
      return this;
    }

    /**
     * Adds one element to {@link Dataset#getFields() fields} list.
     * @param element A fields element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFields(Field element) {
      this.fields.add(Objects.requireNonNull(element, "fields element"));
      return this;
    }

    /**
     * Adds elements to {@link Dataset#getFields() fields} list.
     * @param elements An array of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFields(Field... elements) {
      for (Field element : elements) {
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Dataset#getFields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("fields")
    public final Builder fields(Iterable<? extends Field> elements) {
      this.fields.clear();
      return addAllFields(elements);
    }

    /**
     * Adds elements to {@link Dataset#getFields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllFields(Iterable<? extends Field> elements) {
      for (Field element : elements) {
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Dataset#getDataProcesses() dataProcesses} list.
     * @param element A dataProcesses element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDataProcesses(DataProcess element) {
      this.dataProcesses.add(Objects.requireNonNull(element, "dataProcesses element"));
      return this;
    }

    /**
     * Adds elements to {@link Dataset#getDataProcesses() dataProcesses} list.
     * @param elements An array of dataProcesses elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDataProcesses(DataProcess... elements) {
      for (DataProcess element : elements) {
        this.dataProcesses.add(Objects.requireNonNull(element, "dataProcesses element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Dataset#getDataProcesses() dataProcesses} list.
     * @param elements An iterable of dataProcesses elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dataProcesses")
    public final Builder dataProcesses(Iterable<? extends DataProcess> elements) {
      this.dataProcesses.clear();
      return addAllDataProcesses(elements);
    }

    /**
     * Adds elements to {@link Dataset#getDataProcesses() dataProcesses} list.
     * @param elements An iterable of dataProcesses elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDataProcesses(Iterable<? extends DataProcess> elements) {
      for (DataProcess element : elements) {
        this.dataProcesses.add(Objects.requireNonNull(element, "dataProcesses element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDataset ImmutableDataset}.
     * @return An immutable instance of Dataset
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDataset build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDataset(
          reference,
          description,
          createdDate,
          updatedDate,
          List.copyOf(fields),
          List.copyOf(dataProcesses));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REFERENCE) != 0) attributes.add("reference");
      return "Cannot build Dataset, some of required attributes are not set " + attributes;
    }
  }
}
