package zeenea.connector.sqlserver.services.ssas.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.sqlserver.services.ssas.ItemRef;

/**
 * Immutable implementation of {@link DataProcess}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDataProcess.builder()}.
 */
@Generated(from = "DataProcess", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDataProcess implements DataProcess {
  @NotNull
  private final ItemRef reference;
  private final @Nullable String description;
  @NotNull
  private final List<DatasetLink> datasetLinks;

  private ImmutableDataProcess(
      ItemRef reference,
      @Nullable String description,
      List<DatasetLink> datasetLinks) {
    this.reference = reference;
    this.description = description;
    this.datasetLinks = datasetLinks;
  }

  /**
   * @return The value of the {@code reference} attribute
   */
  @NotNull
  @Override
  public ItemRef getReference() {
    return reference;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code datasetLinks} attribute
   */
  @NotNull
  @Override
  public List<DatasetLink> getDatasetLinks() {
    return datasetLinks;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataProcess#getReference() reference} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reference
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataProcess withReference(ItemRef value) {
    if (this.reference == value) return this;
    ItemRef newValue = Objects.requireNonNull(value, "reference");
    return new ImmutableDataProcess(newValue, this.description, this.datasetLinks);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataProcess#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataProcess withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableDataProcess(this.reference, value, this.datasetLinks);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataProcess#getDatasetLinks() datasetLinks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataProcess withDatasetLinks(DatasetLink... elements) {
    List<DatasetLink> newValue = List.of(elements);
    return new ImmutableDataProcess(this.reference, this.description, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataProcess#getDatasetLinks() datasetLinks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of datasetLinks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataProcess withDatasetLinks(Iterable<? extends DatasetLink> elements) {
    if (this.datasetLinks == elements) return this;
    List<DatasetLink> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends DatasetLink>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDataProcess(this.reference, this.description, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDataProcess} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDataProcess
        && equalTo(0, (ImmutableDataProcess) another);
  }

  private boolean equalTo(int synthetic, ImmutableDataProcess another) {
    return reference.equals(another.reference)
        && Objects.equals(description, another.description)
        && datasetLinks.equals(another.datasetLinks);
  }

  /**
   * Computes a hash code from attributes: {@code reference}, {@code description}, {@code datasetLinks}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + reference.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + datasetLinks.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DataProcess} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DataProcess{"
        + "reference=" + reference
        + ", description=" + description
        + ", datasetLinks=" + datasetLinks
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DataProcess} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DataProcess instance
   */
  public static ImmutableDataProcess copyOf(DataProcess instance) {
    if (instance instanceof ImmutableDataProcess) {
      return (ImmutableDataProcess) instance;
    }
    return ImmutableDataProcess.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDataProcess ImmutableDataProcess}.
   * <pre>
   * ImmutableDataProcess.builder()
   *    .reference(zeenea.connector.sqlserver.services.ssas.ItemRef) // required {@link DataProcess#getReference() reference}
   *    .description(String | null) // nullable {@link DataProcess#getDescription() description}
   *    .addDatasetLinks|addAllDatasetLinks(zeenea.connector.sqlserver.services.ssas.client.DatasetLink) // {@link DataProcess#getDatasetLinks() datasetLinks} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDataProcess builder
   */
  public static ImmutableDataProcess.Builder builder() {
    return new ImmutableDataProcess.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDataProcess ImmutableDataProcess}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DataProcess", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_REFERENCE = 0x1L;
    private long initBits = 0x1L;

    private ItemRef reference;
    private String description;
    private List<DatasetLink> datasetLinks = new ArrayList<DatasetLink>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DataProcess} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DataProcess instance) {
      Objects.requireNonNull(instance, "instance");
      this.reference(instance.getReference());
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      addAllDatasetLinks(instance.getDatasetLinks());
      return this;
    }

    /**
     * Initializes the value for the {@link DataProcess#getReference() reference} attribute.
     * @param reference The value for reference 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder reference(ItemRef reference) {
      this.reference = Objects.requireNonNull(reference, "reference");
      initBits &= ~INIT_BIT_REFERENCE;
      return this;
    }

    /**
     * Initializes the value for the {@link DataProcess#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Adds one element to {@link DataProcess#getDatasetLinks() datasetLinks} list.
     * @param element A datasetLinks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDatasetLinks(DatasetLink element) {
      this.datasetLinks.add(Objects.requireNonNull(element, "datasetLinks element"));
      return this;
    }

    /**
     * Adds elements to {@link DataProcess#getDatasetLinks() datasetLinks} list.
     * @param elements An array of datasetLinks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDatasetLinks(DatasetLink... elements) {
      for (DatasetLink element : elements) {
        this.datasetLinks.add(Objects.requireNonNull(element, "datasetLinks element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DataProcess#getDatasetLinks() datasetLinks} list.
     * @param elements An iterable of datasetLinks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datasetLinks(Iterable<? extends DatasetLink> elements) {
      this.datasetLinks.clear();
      return addAllDatasetLinks(elements);
    }

    /**
     * Adds elements to {@link DataProcess#getDatasetLinks() datasetLinks} list.
     * @param elements An iterable of datasetLinks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDatasetLinks(Iterable<? extends DatasetLink> elements) {
      for (DatasetLink element : elements) {
        this.datasetLinks.add(Objects.requireNonNull(element, "datasetLinks element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDataProcess ImmutableDataProcess}.
     * @return An immutable instance of DataProcess
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDataProcess build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDataProcess(reference, description, List.copyOf(datasetLinks));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REFERENCE) != 0) attributes.add("reference");
      return "Cannot build DataProcess, some of required attributes are not set " + attributes;
    }
  }
}
