package zeenea.connector.sqlserver.services.ssas;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.sqlserver.services.ssas.client.ItemType;

/**
 * Immutable implementation of {@link ItemRef}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItemRef.builder()}.
 */
@Generated(from = "ItemRef", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableItemRef implements ItemRef {
  @NotNull
  private final String project;
  @NotNull
  private final ItemType type;
  @NotNull
  private final String name;

  private ImmutableItemRef(
      String project,
      ItemType type,
      String name) {
    this.project = project;
    this.type = type;
    this.name = name;
  }

  /**
   * @return The value of the {@code project} attribute
   */
  @JsonProperty("project")
  @NotNull
  @Override
  public String getProject() {
    return project;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @NotNull
  @Override
  public ItemType getType() {
    return type;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @NotNull
  @Override
  public String getName() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getProject() project} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for project
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRef withProject(String value) {
    String newValue = Objects.requireNonNull(value, "project");
    if (this.project.equals(newValue)) return this;
    return new ImmutableItemRef(newValue, this.type, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRef withType(ItemType value) {
    ItemType newValue = Objects.requireNonNull(value, "type");
    if (this.type == newValue) return this;
    return new ImmutableItemRef(this.project, newValue, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRef withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableItemRef(this.project, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItemRef} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItemRef
        && equalTo(0, (ImmutableItemRef) another);
  }

  private boolean equalTo(int synthetic, ImmutableItemRef another) {
    return project.equals(another.project)
        && type.equals(another.type)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code project}, {@code type}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + project.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ItemRef} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ItemRef{"
        + "project=" + project
        + ", type=" + type
        + ", name=" + name
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ItemRef", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ItemRef {
    String project;
    ItemType type;
    String name;
    @JsonProperty("project")
    public void setProject(String project) {
      this.project = project;
    }
    @JsonProperty("type")
    public void setType(ItemType type) {
      this.type = type;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @Override
    public String getProject() { throw new UnsupportedOperationException(); }
    @Override
    public ItemType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableItemRef fromJson(Json json) {
    ImmutableItemRef.Builder builder = ImmutableItemRef.builder();
    if (json.project != null) {
      builder.project(json.project);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ItemRef} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ItemRef instance
   */
  public static ImmutableItemRef copyOf(ItemRef instance) {
    if (instance instanceof ImmutableItemRef) {
      return (ImmutableItemRef) instance;
    }
    return ImmutableItemRef.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItemRef ImmutableItemRef}.
   * <pre>
   * ImmutableItemRef.builder()
   *    .project(String) // required {@link ItemRef#getProject() project}
   *    .type(zeenea.connector.sqlserver.services.ssas.client.ItemType) // required {@link ItemRef#getType() type}
   *    .name(String) // required {@link ItemRef#getName() name}
   *    .build();
   * </pre>
   * @return A new ImmutableItemRef builder
   */
  public static ImmutableItemRef.Builder builder() {
    return new ImmutableItemRef.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItemRef ImmutableItemRef}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ItemRef", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PROJECT = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private long initBits = 0x7L;

    private String project;
    private ItemType type;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ItemRef} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ItemRef instance) {
      Objects.requireNonNull(instance, "instance");
      this.project(instance.getProject());
      this.type(instance.getType());
      this.name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getProject() project} attribute.
     * @param project The value for project 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("project")
    public final Builder project(String project) {
      this.project = Objects.requireNonNull(project, "project");
      initBits &= ~INIT_BIT_PROJECT;
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(ItemType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableItemRef ImmutableItemRef}.
     * @return An immutable instance of ItemRef
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItemRef build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableItemRef(project, type, name);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROJECT) != 0) attributes.add("project");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build ItemRef, some of required attributes are not set " + attributes;
    }
  }
}
