package zeenea.connector.sqlserver.services.ssas;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link AnalysisServicesConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAnalysisServicesConfig.builder()}.
 */
@Generated(from = "AnalysisServicesConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableAnalysisServicesConfig
    implements AnalysisServicesConfig {
  @NotNull
  private final String connectionName;
  @NotNull
  private final Mode mode;
  private final boolean multiCatalog;

  private ImmutableAnalysisServicesConfig(
      String connectionName,
      Mode mode,
      boolean multiCatalog) {
    this.connectionName = connectionName;
    this.mode = mode;
    this.multiCatalog = multiCatalog;
  }

  /**
   * @return The value of the {@code connectionName} attribute
   */
  @NotNull
  @Override
  public String connectionName() {
    return connectionName;
  }

  /**
   * @return The value of the {@code mode} attribute
   */
  @NotNull
  @Override
  public Mode mode() {
    return mode;
  }

  /**
   * @return The value of the {@code multiCatalog} attribute
   */
  @Override
  public boolean multiCatalog() {
    return multiCatalog;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AnalysisServicesConfig#connectionName() connectionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectionName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnalysisServicesConfig withConnectionName(String value) {
    String newValue = Objects.requireNonNull(value, "connectionName");
    if (this.connectionName.equals(newValue)) return this;
    return new ImmutableAnalysisServicesConfig(newValue, this.mode, this.multiCatalog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AnalysisServicesConfig#mode() mode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnalysisServicesConfig withMode(Mode value) {
    Mode newValue = Objects.requireNonNull(value, "mode");
    if (this.mode == newValue) return this;
    return new ImmutableAnalysisServicesConfig(this.connectionName, newValue, this.multiCatalog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AnalysisServicesConfig#multiCatalog() multiCatalog} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for multiCatalog
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnalysisServicesConfig withMultiCatalog(boolean value) {
    if (this.multiCatalog == value) return this;
    return new ImmutableAnalysisServicesConfig(this.connectionName, this.mode, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAnalysisServicesConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAnalysisServicesConfig
        && equalTo(0, (ImmutableAnalysisServicesConfig) another);
  }

  private boolean equalTo(int synthetic, ImmutableAnalysisServicesConfig another) {
    return connectionName.equals(another.connectionName)
        && mode.equals(another.mode)
        && multiCatalog == another.multiCatalog;
  }

  /**
   * Computes a hash code from attributes: {@code connectionName}, {@code mode}, {@code multiCatalog}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + connectionName.hashCode();
    h += (h << 5) + mode.hashCode();
    h += (h << 5) + Boolean.hashCode(multiCatalog);
    return h;
  }

  /**
   * Prints the immutable value {@code AnalysisServicesConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AnalysisServicesConfig{"
        + "connectionName=" + connectionName
        + ", mode=" + mode
        + ", multiCatalog=" + multiCatalog
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link AnalysisServicesConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AnalysisServicesConfig instance
   */
  public static ImmutableAnalysisServicesConfig copyOf(AnalysisServicesConfig instance) {
    if (instance instanceof ImmutableAnalysisServicesConfig) {
      return (ImmutableAnalysisServicesConfig) instance;
    }
    return ImmutableAnalysisServicesConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAnalysisServicesConfig ImmutableAnalysisServicesConfig}.
   * <pre>
   * ImmutableAnalysisServicesConfig.builder()
   *    .connectionName(String) // required {@link AnalysisServicesConfig#connectionName() connectionName}
   *    .mode(zeenea.connector.sqlserver.services.ssas.Mode) // required {@link AnalysisServicesConfig#mode() mode}
   *    .multiCatalog(boolean) // required {@link AnalysisServicesConfig#multiCatalog() multiCatalog}
   *    .build();
   * </pre>
   * @return A new ImmutableAnalysisServicesConfig builder
   */
  public static ImmutableAnalysisServicesConfig.Builder builder() {
    return new ImmutableAnalysisServicesConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAnalysisServicesConfig ImmutableAnalysisServicesConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AnalysisServicesConfig", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CONNECTION_NAME = 0x1L;
    private static final long INIT_BIT_MODE = 0x2L;
    private static final long INIT_BIT_MULTI_CATALOG = 0x4L;
    private long initBits = 0x7L;

    private String connectionName;
    private Mode mode;
    private boolean multiCatalog;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AnalysisServicesConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AnalysisServicesConfig instance) {
      Objects.requireNonNull(instance, "instance");
      this.connectionName(instance.connectionName());
      this.mode(instance.mode());
      this.multiCatalog(instance.multiCatalog());
      return this;
    }

    /**
     * Initializes the value for the {@link AnalysisServicesConfig#connectionName() connectionName} attribute.
     * @param connectionName The value for connectionName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectionName(String connectionName) {
      this.connectionName = Objects.requireNonNull(connectionName, "connectionName");
      initBits &= ~INIT_BIT_CONNECTION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link AnalysisServicesConfig#mode() mode} attribute.
     * @param mode The value for mode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mode(Mode mode) {
      this.mode = Objects.requireNonNull(mode, "mode");
      initBits &= ~INIT_BIT_MODE;
      return this;
    }

    /**
     * Initializes the value for the {@link AnalysisServicesConfig#multiCatalog() multiCatalog} attribute.
     * @param multiCatalog The value for multiCatalog 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder multiCatalog(boolean multiCatalog) {
      this.multiCatalog = multiCatalog;
      initBits &= ~INIT_BIT_MULTI_CATALOG;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAnalysisServicesConfig ImmutableAnalysisServicesConfig}.
     * @return An immutable instance of AnalysisServicesConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAnalysisServicesConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAnalysisServicesConfig(connectionName, mode, multiCatalog);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONNECTION_NAME) != 0) attributes.add("connectionName");
      if ((initBits & INIT_BIT_MODE) != 0) attributes.add("mode");
      if ((initBits & INIT_BIT_MULTI_CATALOG) != 0) attributes.add("multiCatalog");
      return "Cannot build AnalysisServicesConfig, some of required attributes are not set " + attributes;
    }
  }
}
