/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.proxy;

import java.math.BigDecimal;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.ConnectionConfiguration;
import zeenea.connector.commons.proxy.ProxyCommonConfiguration;
import zeenea.connector.commons.proxy.ProxyConfigException;
import zeenea.connector.exception.InvalidConfigurationException;
import zeenea.connector.jdk.PropertyValueMap;
import zeenea.connector.source.SourceNumberProperty;
import zeenea.connector.source.SourceProperty;
import zeenea.connector.source.SourceStringProperty;

public class Proxy {
    @Nullable
    private final String scheme;
    @NotNull
    private final String hostname;
    private final int port;
    @Nullable
    private final String username;
    @Nullable
    private final String password;

    public Proxy(Builder builder) {
        this.scheme = builder.scheme;
        this.hostname = Objects.requireNonNull(builder.hostname);
        this.port = Objects.requireNonNull(builder.port);
        this.username = builder.username;
        this.password = builder.password;
    }

    @Nullable
    public String getScheme() {
        return this.scheme;
    }

    @NotNull
    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String scheme;
        private String hostname;
        private Integer port;
        private String username;
        private String password;
        private boolean configRead;

        private Builder() {
        }

        public Builder configuration(@NotNull ConnectionConfiguration configuration) throws InvalidConfigurationException {
            this.configRead = true;
            configuration.getStringOptional("proxy.scheme").ifPresent(this::scheme);
            configuration.getStringOptional("proxy.hostname").ifPresent(this::hostname);
            configuration.getLongOptional("proxy.port").map(Long::intValue).ifPresent(this::port);
            configuration.getStringOptional("proxy.username").ifPresent(this::username);
            configuration.getStringOptional("proxy.password").ifPresent(this::password);
            return this;
        }

        public Builder configuration(@NotNull PropertyValueMap configuration) {
            this.configRead = true;
            configuration.get((SourceStringProperty)ProxyCommonConfiguration.PROXY_SCHEME).ifPresent(scheme -> {
                this.scheme = scheme;
            });
            configuration.get((SourceStringProperty)ProxyCommonConfiguration.PROXY_HOSTNAME).ifPresent(hostname -> {
                this.hostname = hostname;
            });
            configuration.get((SourceNumberProperty)ProxyCommonConfiguration.PROXY_PORT).map(BigDecimal::intValue).ifPresent(port -> {
                this.port = port;
            });
            configuration.get((SourceStringProperty)ProxyCommonConfiguration.PROXY_USERNAME).ifPresent(username -> {
                this.username = username;
            });
            configuration.get((SourceStringProperty)ProxyCommonConfiguration.PROXY_PASSWORD).ifPresent(password -> {
                this.password = password;
            });
            return this;
        }

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        @Nullable
        public Proxy build() {
            if (this.hostname != null && this.port != null) {
                return new Proxy(this);
            }
            if (this.hostname != null) {
                return (Proxy)ProxyConfigException.throwConfigException(this.configRead, (SourceProperty)ProxyCommonConfiguration.PROXY_PORT, "Proxy port is required when a hostname is provided");
            }
            if (this.port != null) {
                return (Proxy)ProxyConfigException.throwConfigException(this.configRead, (SourceProperty)ProxyCommonConfiguration.PROXY_HOSTNAME, "Proxy hostname is required when a port is provided");
            }
            return null;
        }
    }
}

