/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.itemidentifier;

import java.util.Locale;
import java.util.NoSuchElementException;
import zeenea.connector.common.ItemIdentifier;
import zeenea.connector.commons.itemidentifier.InvalidItemIdentifierException;
import zeenea.connector.commons.itemidentifier.ParseStatus;

public class ParsedRef<T> {
    private final ParseStatus status;
    private final ItemIdentifier itemIdentifier;
    private final T result;
    private final InvalidItemIdentifierException exception;

    private ParsedRef(ParseStatus status, ItemIdentifier itemIdentifier, T result, InvalidItemIdentifierException invalidZeePathException) {
        this.status = status;
        this.itemIdentifier = itemIdentifier;
        this.result = result;
        this.exception = invalidZeePathException;
    }

    static <U> ParsedRef<U> supported(ItemIdentifier itemIdentifier, U itemRef) {
        return new ParsedRef<U>(ParseStatus.SUPPORTED, itemIdentifier, itemRef, null);
    }

    static <U> ParsedRef<U> ignored(ItemIdentifier itemIdentifier) {
        return new ParsedRef<Object>(ParseStatus.IGNORED, itemIdentifier, null, null);
    }

    static <U> ParsedRef<U> invalid(ItemIdentifier itemIdentifier, InvalidItemIdentifierException exception) {
        return new ParsedRef<Object>(ParseStatus.INVALID, itemIdentifier, null, exception);
    }

    public boolean isSupported() {
        return this.status == ParseStatus.SUPPORTED;
    }

    public boolean isIgnored() {
        return this.status == ParseStatus.IGNORED;
    }

    public boolean isInvalid() {
        return this.status == ParseStatus.INVALID;
    }

    public ItemIdentifier getItemIdentifier() {
        return this.itemIdentifier;
    }

    public T get() {
        if (this.status != ParseStatus.SUPPORTED) {
            throw new NoSuchElementException("Path " + this.status.toString().toLowerCase(Locale.ROOT));
        }
        return this.result;
    }

    public InvalidItemIdentifierException getException() {
        if (this.status != ParseStatus.INVALID) {
            throw new NoSuchElementException("Path " + this.status.toString().toLowerCase(Locale.ROOT));
        }
        return this.exception;
    }
}

