/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scala.Option;
import zeenea.connector.common.DataSourceIdentifier;
import zeenea.connector.common.IdentificationProperty;
import zeenea.connector.common.ItemIdentifier;
import zeenea.connector.common.ItemReference;
import zeenea.connector.commons.db.DbEngine;
import zeenea.connector.commons.db.DbTable;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.util.ObjectUtil;
import zeenea.connector.commons.util.StringUtil;
import zeenea.connector.commons.zeepath.ZeePaths;
import zeenea.connector.source.InternItemReference;
import zeenea.connector.source.ZeePath;

public class DbReferenceFactory
implements AutoCloseable {
    private static final SimpleLogger log = SimpleLogger.of(DbReferenceFactory.class);
    public static final String PREFIX_NAME = "prefix";
    public static final String DATABASE_NAME = "database";
    public static final String SCHEMA_NAME = "schema";
    public static final String TABLE_NAME = "table";
    public static final String FIELD_KEY = "field_key";
    private final Set<String> connectionAliases = new HashSet<String>();
    @NotNull
    private final String connectorPrefix;
    @NotNull
    private final String connectionCode;

    public DbReferenceFactory(@NotNull String connectorPrefix, @NotNull String connectionCode) {
        this.connectorPrefix = connectorPrefix;
        this.connectionCode = connectionCode;
    }

    public Set<String> connectionAliases() {
        return Collections.unmodifiableSet(this.connectionAliases);
    }

    @Override
    public void close() {
        if (!this.connectionAliases.isEmpty()) {
            String message = this.connectionAliases.stream().sorted().collect(Collectors.joining(System.lineSeparator() + "    - ", "Links to items from external connections have been found." + System.lineSeparator() + "Automatic lineage can be enabled for these items by adding these values" + System.lineSeparator() + "as aliases in their corresponding configuration files." + System.lineSeparator() + "    - ", ""));
            log.entry(this.connectorPrefix + "_lineage_used_connection_aliases").with("connection", this.connectionCode).body("Aliases", message).info();
        }
    }

    @Nullable
    public InternItemReference itemReference(DbTable table, boolean multiEnabled) {
        List<String> prefix;
        if (ObjectUtil.anyNull(table, new Object[]{table.engine(), table.table()})) {
            return null;
        }
        DbEngine engine = table.engine();
        if (!engine.has(DbEngine.Feature.NO_HOST) && table.host() == null) {
            return null;
        }
        if (!engine.has(DbEngine.Feature.NO_DB) && !engine.has(DbEngine.Feature.OPTIONAL_DB) && table.database() == null) {
            return null;
        }
        if (!(engine.has(DbEngine.Feature.NO_SCHEMA) || engine.has(DbEngine.Feature.DEFAULT_SCHEMA) || engine.has(DbEngine.Feature.OPTIONAL_SCHEMA) || table.schema() != null)) {
            return null;
        }
        StringBuilder alias = new StringBuilder();
        ArrayList<String> path = new ArrayList<String>();
        if (!engine.has(DbEngine.Feature.NO_HOST)) {
            alias.append(table.host());
            if (!engine.has(DbEngine.Feature.FIXED_PORT)) {
                alias.append(':');
                alias.append(table.port());
            }
        }
        if (engine.has(DbEngine.Feature.PREFIXED) && (prefix = table.prefix()) != null) {
            path.addAll(prefix);
        }
        String database = table.database();
        if (!engine.has(DbEngine.Feature.NO_DB) && database != null) {
            if (engine.has(DbEngine.Feature.MULTI_DB) || engine.has(DbEngine.Feature.OPTIONAL_MULTI_DB) && multiEnabled) {
                path.add(database);
            } else {
                alias.append('/');
                alias.append(database);
            }
        }
        if (!engine.has(DbEngine.Feature.NO_SCHEMA)) {
            String schema = table.schema();
            if (schema != null) {
                path.add(schema);
            } else if (engine.has(DbEngine.Feature.DEFAULT_SCHEMA)) {
                path.add(engine.defaultSchema());
            }
        }
        path.add(table.table());
        String connectionAlias = alias.toString();
        if (StringUtil.nonEmpty(connectionAlias)) {
            this.connectionAliases.add(connectionAlias);
            return InternItemReference.apply((ZeePath)ZeePaths.zeePath(path), (Option)Option.apply((Object)connectionAlias));
        }
        return InternItemReference.apply((ZeePath)ZeePaths.zeePath(path));
    }

    public ItemReference sourceDatasetReference(DbTable table) {
        ItemReference.Builder builder = ItemReference.builder();
        ItemIdentifier itemIdentifier = this.sourceDatasetIdentifier(table);
        builder.itemIdentifier(itemIdentifier);
        if (table.host() != null) {
            Optional.ofNullable(this.getDataSourceIdentifier(table)).ifPresent(arg_0 -> ((ItemReference.Builder)builder).dataSourceIdentifier(arg_0));
        }
        return builder.build();
    }

    public ItemReference sourceFieldReference(DbTable table, String columnName) {
        ItemReference.Builder builder = ItemReference.builder();
        builder.itemIdentifier(this.sourceFieldIdentifier(table, columnName));
        Optional.ofNullable(table.host()).flatMap(host -> Optional.ofNullable(this.getDataSourceIdentifier(table))).ifPresent(arg_0 -> ((ItemReference.Builder)builder).dataSourceIdentifier(arg_0));
        return builder.build();
    }

    public ItemReference fieldReference(String columnName) {
        return ItemReference.of((ItemIdentifier)this.fieldIdentifier(columnName));
    }

    @Nullable
    public DataSourceIdentifier getDataSourceIdentifier(DbTable table) {
        ArrayList<IdentificationProperty> properties = new ArrayList<IdentificationProperty>();
        DbEngine engine = table.engine();
        StringBuilder aliasBuilder = new StringBuilder();
        if (!engine.has(DbEngine.Feature.NO_HOST)) {
            properties.add(IdentificationProperty.of((String)"host", (String)table.host()));
            aliasBuilder.append(table.host());
        }
        if (!engine.has(DbEngine.Feature.NO_HOST) && !engine.has(DbEngine.Feature.FIXED_PORT)) {
            properties.add(IdentificationProperty.of((String)"port", (String)String.valueOf(table.port())));
            aliasBuilder.append(":");
            aliasBuilder.append(table.port());
        }
        if (aliasBuilder.length() > 0) {
            this.connectionAliases.add(aliasBuilder.toString());
        }
        return properties.isEmpty() ? null : DataSourceIdentifier.of(properties);
    }

    @NotNull
    public ItemIdentifier sourceDatasetIdentifier(DbTable table) {
        return this.sourceDatasetIdentifier(table.engine(), table.prefix(), table.database(), table.schema(), table.table());
    }

    @NotNull
    public ItemIdentifier sourceFieldIdentifier(DbTable table, String columnName) {
        return this.sourceFieldIdentifier(table.engine(), table.prefix(), table.database(), table.schema(), table.table(), columnName);
    }

    @NotNull
    public ItemIdentifier fieldIdentifier(String columnName) {
        return ItemIdentifier.of((IdentificationProperty[])new IdentificationProperty[]{IdentificationProperty.of((String)FIELD_KEY, (String)columnName)});
    }

    @NotNull
    public ItemIdentifier sourceFieldIdentifier(DbEngine engine, List<String> prefix, String database, String schema, String table, String column) {
        return ItemIdentifier.of(this.getIdentificationProperties(engine, prefix, database, schema, table, column));
    }

    @NotNull
    public ItemIdentifier sourceDatasetIdentifier(DbEngine engine, List<String> prefix, String database, String schema, String table) {
        return ItemIdentifier.of(this.getIdentificationProperties(engine, prefix, database, schema, table, null));
    }

    @NotNull
    private List<IdentificationProperty> getIdentificationProperties(DbEngine engine, List<String> prefix, String database, String schema, String table, String column) {
        ArrayList<IdentificationProperty> properties = new ArrayList<IdentificationProperty>();
        if (engine.has(DbEngine.Feature.PREFIXED)) {
            Optional.ofNullable(prefix).ifPresent(prefixList -> prefixList.forEach(p -> properties.add(IdentificationProperty.of((String)PREFIX_NAME, (String)p))));
        }
        if (!engine.has(DbEngine.Feature.NO_DB) && StringUtils.isNotEmpty((CharSequence)database) && (engine.has(DbEngine.Feature.MULTI_DB) || engine.has(DbEngine.Feature.OPTIONAL_MULTI_DB))) {
            properties.add(IdentificationProperty.of((String)DATABASE_NAME, (String)database));
        }
        if (!engine.has(DbEngine.Feature.NO_SCHEMA)) {
            if (StringUtils.isNotEmpty((CharSequence)schema)) {
                properties.add(IdentificationProperty.of((String)SCHEMA_NAME, (String)schema));
            } else if (engine.has(DbEngine.Feature.DEFAULT_SCHEMA)) {
                properties.add(IdentificationProperty.of((String)SCHEMA_NAME, (String)engine.defaultSchema()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)table)) {
            properties.add(IdentificationProperty.of((String)TABLE_NAME, (String)table));
        }
        if (StringUtils.isNotEmpty((CharSequence)column)) {
            properties.add(IdentificationProperty.of((String)FIELD_KEY, (String)column));
        }
        return properties;
    }
}

