/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.sql.parser;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.db.DbEngine;
import zeenea.connector.commons.db.DbTable;
import zeenea.connector.commons.immutables.ImmutablePojo;
import zeenea.connector.commons.sql.parser.ImmutableSqlTable;

@ImmutablePojo
public interface SqlTable {
    @NotNull
    public DbEngine engine();

    @NotNull
    public String table();

    @Nullable
    public String schema();

    @Nullable
    public String database();

    public static SqlTable of(@NotNull DbEngine engine, @Nullable String database, @Nullable String schema, @NotNull String name) {
        return ImmutableSqlTable.builder().engine(engine).table(name).schema(schema == null || schema.isEmpty() ? null : schema).database(database == null || database.isEmpty() ? null : database).build();
    }

    public static SqlTable of(@NotNull DbEngine engine, @Nullable String schema, @NotNull String name) {
        return SqlTable.of(engine, null, schema, name);
    }

    public static SqlTable of(@NotNull DbEngine engine, @NotNull String name) {
        return SqlTable.of(engine, null, null, name);
    }

    default public DbTable.Builder toDbTable(@NotNull DbEngine engine) {
        return DbTable.builder((DbEngine)engine, (boolean)false).table(this.table()).schema(this.schema()).database(this.database());
    }
}

