package zeenea.connector.sqlserver.services.ssrs.client.xml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Report}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReport.builder()}.
 */
@Generated(from = "Report", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableReport implements Report {
  private final String id;
  private final @Nullable String name;
  private final @Nullable String description;
  private final @Nullable String author;
  private final List<DataSource> dataSources;
  private final List<DataSet> dataSets;

  private ImmutableReport(
      String id,
      @Nullable String name,
      @Nullable String description,
      @Nullable String author,
      List<DataSource> dataSources,
      List<DataSet> dataSets) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.author = author;
    this.dataSources = dataSources;
    this.dataSets = dataSets;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JacksonXmlProperty(namespace = "rd", localName = "ReportID")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @JacksonXmlProperty(localName = "Description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code author} attribute
   */
  @JsonProperty("author")
  @JacksonXmlProperty(localName = "Author")
  @Override
  public @Nullable String getAuthor() {
    return author;
  }

  /**
   * @return The value of the {@code dataSources} attribute
   */
  @JsonProperty("dataSources")
  @JacksonXmlElementWrapper(localName = "DataSources")
  @Override
  public List<DataSource> getDataSources() {
    return dataSources;
  }

  /**
   * @return The value of the {@code dataSets} attribute
   */
  @JsonProperty("dataSets")
  @JacksonXmlElementWrapper(localName = "DataSets")
  @Override
  public List<DataSet> getDataSets() {
    return dataSets;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Report#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReport withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableReport(newValue, this.name, this.description, this.author, this.dataSources, this.dataSets);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Report#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReport withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableReport(this.id, value, this.description, this.author, this.dataSources, this.dataSets);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Report#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReport withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableReport(this.id, this.name, value, this.author, this.dataSources, this.dataSets);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Report#getAuthor() author} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for author (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReport withAuthor(@Nullable String value) {
    if (Objects.equals(this.author, value)) return this;
    return new ImmutableReport(this.id, this.name, this.description, value, this.dataSources, this.dataSets);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Report#getDataSources() dataSources}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReport withDataSources(DataSource... elements) {
    List<DataSource> newValue = List.of(elements);
    return new ImmutableReport(this.id, this.name, this.description, this.author, newValue, this.dataSets);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Report#getDataSources() dataSources}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dataSources elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReport withDataSources(Iterable<? extends DataSource> elements) {
    if (this.dataSources == elements) return this;
    List<DataSource> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends DataSource>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableReport(this.id, this.name, this.description, this.author, newValue, this.dataSets);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Report#getDataSets() dataSets}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReport withDataSets(DataSet... elements) {
    List<DataSet> newValue = List.of(elements);
    return new ImmutableReport(this.id, this.name, this.description, this.author, this.dataSources, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Report#getDataSets() dataSets}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dataSets elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReport withDataSets(Iterable<? extends DataSet> elements) {
    if (this.dataSets == elements) return this;
    List<DataSet> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends DataSet>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableReport(this.id, this.name, this.description, this.author, this.dataSources, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReport} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReport
        && equalTo(0, (ImmutableReport) another);
  }

  private boolean equalTo(int synthetic, ImmutableReport another) {
    return id.equals(another.id)
        && Objects.equals(name, another.name)
        && Objects.equals(description, another.description)
        && Objects.equals(author, another.author)
        && dataSources.equals(another.dataSources)
        && dataSets.equals(another.dataSets);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code description}, {@code author}, {@code dataSources}, {@code dataSets}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(author);
    h += (h << 5) + dataSources.hashCode();
    h += (h << 5) + dataSets.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Report} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Report{"
        + "id=" + id
        + ", name=" + name
        + ", description=" + description
        + ", author=" + author
        + ", dataSources=" + dataSources
        + ", dataSets=" + dataSets
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Report} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Report instance
   */
  public static ImmutableReport copyOf(Report instance) {
    if (instance instanceof ImmutableReport) {
      return (ImmutableReport) instance;
    }
    return ImmutableReport.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReport ImmutableReport}.
   * <pre>
   * ImmutableReport.builder()
   *    .id(String) // required {@link Report#getId() id}
   *    .name(String | null) // nullable {@link Report#getName() name}
   *    .description(String | null) // nullable {@link Report#getDescription() description}
   *    .author(String | null) // nullable {@link Report#getAuthor() author}
   *    .addDataSources|addAllDataSources(zeenea.connector.sqlserver.services.ssrs.client.xml.DataSource) // {@link Report#getDataSources() dataSources} elements
   *    .addDataSets|addAllDataSets(zeenea.connector.sqlserver.services.ssrs.client.xml.DataSet) // {@link Report#getDataSets() dataSets} elements
   *    .build();
   * </pre>
   * @return A new ImmutableReport builder
   */
  public static ImmutableReport.Builder builder() {
    return new ImmutableReport.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableReport ImmutableReport}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Report", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private String id;
    private String name;
    private String description;
    private String author;
    private List<DataSource> dataSources = new ArrayList<DataSource>();
    private List<DataSet> dataSets = new ArrayList<DataSet>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Report} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Report instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      @Nullable String authorValue = instance.getAuthor();
      if (authorValue != null) {
        author(authorValue);
      }
      addAllDataSources(instance.getDataSources());
      addAllDataSets(instance.getDataSets());
      return this;
    }

    /**
     * Initializes the value for the {@link Report#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    @JacksonXmlProperty(namespace = "rd", localName = "ReportID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Report#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Report#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    @JacksonXmlProperty(localName = "Description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Report#getAuthor() author} attribute.
     * @param author The value for author (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("author")
    @JacksonXmlProperty(localName = "Author")
    public final Builder author(@Nullable String author) {
      this.author = author;
      return this;
    }

    /**
     * Adds one element to {@link Report#getDataSources() dataSources} list.
     * @param element A dataSources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDataSources(DataSource element) {
      this.dataSources.add(Objects.requireNonNull(element, "dataSources element"));
      return this;
    }

    /**
     * Adds elements to {@link Report#getDataSources() dataSources} list.
     * @param elements An array of dataSources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDataSources(DataSource... elements) {
      for (DataSource element : elements) {
        this.dataSources.add(Objects.requireNonNull(element, "dataSources element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Report#getDataSources() dataSources} list.
     * @param elements An iterable of dataSources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dataSources")
    @JacksonXmlElementWrapper(localName = "DataSources")
    public final Builder dataSources(Iterable<? extends DataSource> elements) {
      this.dataSources.clear();
      return addAllDataSources(elements);
    }

    /**
     * Adds elements to {@link Report#getDataSources() dataSources} list.
     * @param elements An iterable of dataSources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDataSources(Iterable<? extends DataSource> elements) {
      for (DataSource element : elements) {
        this.dataSources.add(Objects.requireNonNull(element, "dataSources element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Report#getDataSets() dataSets} list.
     * @param element A dataSets element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDataSets(DataSet element) {
      this.dataSets.add(Objects.requireNonNull(element, "dataSets element"));
      return this;
    }

    /**
     * Adds elements to {@link Report#getDataSets() dataSets} list.
     * @param elements An array of dataSets elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDataSets(DataSet... elements) {
      for (DataSet element : elements) {
        this.dataSets.add(Objects.requireNonNull(element, "dataSets element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Report#getDataSets() dataSets} list.
     * @param elements An iterable of dataSets elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dataSets")
    @JacksonXmlElementWrapper(localName = "DataSets")
    public final Builder dataSets(Iterable<? extends DataSet> elements) {
      this.dataSets.clear();
      return addAllDataSets(elements);
    }

    /**
     * Adds elements to {@link Report#getDataSets() dataSets} list.
     * @param elements An iterable of dataSets elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDataSets(Iterable<? extends DataSet> elements) {
      for (DataSet element : elements) {
        this.dataSets.add(Objects.requireNonNull(element, "dataSets element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableReport ImmutableReport}.
     * @return An immutable instance of Report
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReport build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableReport(
          id,
          name,
          description,
          author,
          List.copyOf(dataSources),
          List.copyOf(dataSets));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build Report, some of required attributes are not set " + attributes;
    }
  }
}
