package zeenea.connector.sqlserver.services.ssrs.client.xml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Query}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQuery.builder()}.
 */
@Generated(from = "Query", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableQuery implements Query {
  private final @Nullable String dataSourceName;
  private final @Nullable String dataSourceReference;
  private final @Nullable List<QueryParameter> queryParameters;

  private ImmutableQuery(
      @Nullable String dataSourceName,
      @Nullable String dataSourceReference,
      @Nullable List<QueryParameter> queryParameters) {
    this.dataSourceName = dataSourceName;
    this.dataSourceReference = dataSourceReference;
    this.queryParameters = queryParameters;
  }

  /**
   * @return The value of the {@code dataSourceName} attribute
   */
  @JsonProperty("dataSourceName")
  @JacksonXmlProperty(localName = "DataSourceName")
  @Override
  public @Nullable String getDataSourceName() {
    return dataSourceName;
  }

  /**
   * @return The value of the {@code dataSourceReference} attribute
   */
  @JsonProperty("dataSourceReference")
  @JacksonXmlProperty(localName = "DataSourceReference")
  @Override
  public @Nullable String getDataSourceReference() {
    return dataSourceReference;
  }

  /**
   * @return The value of the {@code queryParameters} attribute
   */
  @JsonProperty("queryParameters")
  @JacksonXmlElementWrapper(localName = "QueryParameters")
  @Override
  public @Nullable List<QueryParameter> getQueryParameters() {
    return queryParameters;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Query#getDataSourceName() dataSourceName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dataSourceName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuery withDataSourceName(@Nullable String value) {
    if (Objects.equals(this.dataSourceName, value)) return this;
    return new ImmutableQuery(value, this.dataSourceReference, this.queryParameters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Query#getDataSourceReference() dataSourceReference} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dataSourceReference (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuery withDataSourceReference(@Nullable String value) {
    if (Objects.equals(this.dataSourceReference, value)) return this;
    return new ImmutableQuery(this.dataSourceName, value, this.queryParameters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Query#getQueryParameters() queryParameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQuery withQueryParameters(@Nullable QueryParameter... elements) {
    if (elements == null) {
      return new ImmutableQuery(this.dataSourceName, this.dataSourceReference, null);
    }
    List<QueryParameter> newValue = List.of(elements);
    return new ImmutableQuery(this.dataSourceName, this.dataSourceReference, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Query#getQueryParameters() queryParameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of queryParameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQuery withQueryParameters(@Nullable Iterable<? extends QueryParameter> elements) {
    if (this.queryParameters == elements) return this;
    @Nullable List<QueryParameter> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends QueryParameter>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableQuery(this.dataSourceName, this.dataSourceReference, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuery} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuery
        && equalTo(0, (ImmutableQuery) another);
  }

  private boolean equalTo(int synthetic, ImmutableQuery another) {
    return Objects.equals(dataSourceName, another.dataSourceName)
        && Objects.equals(dataSourceReference, another.dataSourceReference)
        && Objects.equals(queryParameters, another.queryParameters);
  }

  /**
   * Computes a hash code from attributes: {@code dataSourceName}, {@code dataSourceReference}, {@code queryParameters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(dataSourceName);
    h += (h << 5) + Objects.hashCode(dataSourceReference);
    h += (h << 5) + Objects.hashCode(queryParameters);
    return h;
  }

  /**
   * Prints the immutable value {@code Query} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Query{"
        + "dataSourceName=" + dataSourceName
        + ", dataSourceReference=" + dataSourceReference
        + ", queryParameters=" + queryParameters
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Query} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Query instance
   */
  public static ImmutableQuery copyOf(Query instance) {
    if (instance instanceof ImmutableQuery) {
      return (ImmutableQuery) instance;
    }
    return ImmutableQuery.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQuery ImmutableQuery}.
   * <pre>
   * ImmutableQuery.builder()
   *    .dataSourceName(String | null) // nullable {@link Query#getDataSourceName() dataSourceName}
   *    .dataSourceReference(String | null) // nullable {@link Query#getDataSourceReference() dataSourceReference}
   *    .queryParameters(List&amp;lt;zeenea.connector.sqlserver.services.ssrs.client.xml.QueryParameter&amp;gt; | null) // nullable {@link Query#getQueryParameters() queryParameters}
   *    .build();
   * </pre>
   * @return A new ImmutableQuery builder
   */
  public static ImmutableQuery.Builder builder() {
    return new ImmutableQuery.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQuery ImmutableQuery}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Query", generator = "Immutables")
  @JacksonXmlRootElement(localName = "Query")
  public static final class Builder {
    private String dataSourceName;
    private String dataSourceReference;
    private List<QueryParameter> queryParameters = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Query} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Query instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String dataSourceNameValue = instance.getDataSourceName();
      if (dataSourceNameValue != null) {
        dataSourceName(dataSourceNameValue);
      }
      @Nullable String dataSourceReferenceValue = instance.getDataSourceReference();
      if (dataSourceReferenceValue != null) {
        dataSourceReference(dataSourceReferenceValue);
      }
      @Nullable List<QueryParameter> queryParametersValue = instance.getQueryParameters();
      if (queryParametersValue != null) {
        addAllQueryParameters(queryParametersValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Query#getDataSourceName() dataSourceName} attribute.
     * @param dataSourceName The value for dataSourceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dataSourceName")
    @JacksonXmlProperty(localName = "DataSourceName")
    public final Builder dataSourceName(@Nullable String dataSourceName) {
      this.dataSourceName = dataSourceName;
      return this;
    }

    /**
     * Initializes the value for the {@link Query#getDataSourceReference() dataSourceReference} attribute.
     * @param dataSourceReference The value for dataSourceReference (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dataSourceReference")
    @JacksonXmlProperty(localName = "DataSourceReference")
    public final Builder dataSourceReference(@Nullable String dataSourceReference) {
      this.dataSourceReference = dataSourceReference;
      return this;
    }

    /**
     * Adds one element to {@link Query#getQueryParameters() queryParameters} list.
     * @param element A queryParameters element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addQueryParameters(QueryParameter element) {
      if (this.queryParameters == null) {
        this.queryParameters = new ArrayList<QueryParameter>();
      }
      this.queryParameters.add(Objects.requireNonNull(element, "queryParameters element"));
      return this;
    }

    /**
     * Adds elements to {@link Query#getQueryParameters() queryParameters} list.
     * @param elements An array of queryParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addQueryParameters(QueryParameter... elements) {
      if (this.queryParameters == null) {
        this.queryParameters = new ArrayList<QueryParameter>();
      }
      for (QueryParameter element : elements) {
        this.queryParameters.add(Objects.requireNonNull(element, "queryParameters element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Query#getQueryParameters() queryParameters} list.
     * @param elements An iterable of queryParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("queryParameters")
    @JacksonXmlElementWrapper(localName = "QueryParameters")
    public final Builder queryParameters(@Nullable Iterable<? extends QueryParameter> elements) {
      if (elements == null) {
        this.queryParameters = null;
        return this;
      }
      this.queryParameters = new ArrayList<QueryParameter>();
      return addAllQueryParameters(elements);
    }

    /**
     * Adds elements to {@link Query#getQueryParameters() queryParameters} list.
     * @param elements An iterable of queryParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllQueryParameters(Iterable<? extends QueryParameter> elements) {
      Objects.requireNonNull(elements, "queryParameters element");
      if (this.queryParameters == null) {
        this.queryParameters = new ArrayList<QueryParameter>();
      }
      for (QueryParameter element : elements) {
        this.queryParameters.add(Objects.requireNonNull(element, "queryParameters element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableQuery ImmutableQuery}.
     * @return An immutable instance of Query
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuery build() {
      return new ImmutableQuery(
          dataSourceName,
          dataSourceReference,
          queryParameters == null ? null : List.copyOf(queryParameters));
    }
  }
}
