package zeenea.connector.sqlserver.services.ssrs.client.xml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link DataSource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDataSource.builder()}.
 */
@Generated(from = "DataSource", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDataSource
    implements DataSource {
  private final String name;
  private final @Nullable String dataSourceReference;
  private final @Nullable ConnectionProperties connectionProperties;

  private ImmutableDataSource(
      String name,
      @Nullable String dataSourceReference,
      @Nullable ConnectionProperties connectionProperties) {
    this.name = name;
    this.dataSourceReference = dataSourceReference;
    this.connectionProperties = connectionProperties;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JacksonXmlProperty(isAttribute = true, localName = "Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code dataSourceReference} attribute
   */
  @JsonProperty("dataSourceReference")
  @JacksonXmlProperty(localName = "DataSourceReference")
  @Override
  public @Nullable String getDataSourceReference() {
    return dataSourceReference;
  }

  /**
   * @return The value of the {@code connectionProperties} attribute
   */
  @JsonProperty("connectionProperties")
  @JacksonXmlProperty(localName = "ConnectionProperties")
  @Override
  public @Nullable ConnectionProperties getConnectionProperties() {
    return connectionProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSource#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSource withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableDataSource(newValue, this.dataSourceReference, this.connectionProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSource#getDataSourceReference() dataSourceReference} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dataSourceReference (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSource withDataSourceReference(@Nullable String value) {
    if (Objects.equals(this.dataSourceReference, value)) return this;
    return new ImmutableDataSource(this.name, value, this.connectionProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSource#getConnectionProperties() connectionProperties} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectionProperties (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSource withConnectionProperties(@Nullable ConnectionProperties value) {
    if (this.connectionProperties == value) return this;
    return new ImmutableDataSource(this.name, this.dataSourceReference, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDataSource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDataSource
        && equalTo(0, (ImmutableDataSource) another);
  }

  private boolean equalTo(int synthetic, ImmutableDataSource another) {
    return name.equals(another.name)
        && Objects.equals(dataSourceReference, another.dataSourceReference)
        && Objects.equals(connectionProperties, another.connectionProperties);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code dataSourceReference}, {@code connectionProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(dataSourceReference);
    h += (h << 5) + Objects.hashCode(connectionProperties);
    return h;
  }

  /**
   * Prints the immutable value {@code DataSource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DataSource{"
        + "name=" + name
        + ", dataSourceReference=" + dataSourceReference
        + ", connectionProperties=" + connectionProperties
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DataSource} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DataSource instance
   */
  public static ImmutableDataSource copyOf(DataSource instance) {
    if (instance instanceof ImmutableDataSource) {
      return (ImmutableDataSource) instance;
    }
    return ImmutableDataSource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDataSource ImmutableDataSource}.
   * <pre>
   * ImmutableDataSource.builder()
   *    .name(String) // required {@link DataSource#getName() name}
   *    .dataSourceReference(String | null) // nullable {@link DataSource#getDataSourceReference() dataSourceReference}
   *    .connectionProperties(zeenea.connector.sqlserver.services.ssrs.client.xml.ConnectionProperties | null) // nullable {@link DataSource#getConnectionProperties() connectionProperties}
   *    .build();
   * </pre>
   * @return A new ImmutableDataSource builder
   */
  public static ImmutableDataSource.Builder builder() {
    return new ImmutableDataSource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDataSource ImmutableDataSource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DataSource", generator = "Immutables")
  @JacksonXmlRootElement(localName = "DataSource")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;
    private String dataSourceReference;
    private ConnectionProperties connectionProperties;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DataSource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DataSource instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      @Nullable String dataSourceReferenceValue = instance.getDataSourceReference();
      if (dataSourceReferenceValue != null) {
        dataSourceReference(dataSourceReferenceValue);
      }
      @Nullable ConnectionProperties connectionPropertiesValue = instance.getConnectionProperties();
      if (connectionPropertiesValue != null) {
        connectionProperties(connectionPropertiesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DataSource#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    @JacksonXmlProperty(isAttribute = true, localName = "Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DataSource#getDataSourceReference() dataSourceReference} attribute.
     * @param dataSourceReference The value for dataSourceReference (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dataSourceReference")
    @JacksonXmlProperty(localName = "DataSourceReference")
    public final Builder dataSourceReference(@Nullable String dataSourceReference) {
      this.dataSourceReference = dataSourceReference;
      return this;
    }

    /**
     * Initializes the value for the {@link DataSource#getConnectionProperties() connectionProperties} attribute.
     * @param connectionProperties The value for connectionProperties (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("connectionProperties")
    @JacksonXmlProperty(localName = "ConnectionProperties")
    public final Builder connectionProperties(@Nullable ConnectionProperties connectionProperties) {
      this.connectionProperties = connectionProperties;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDataSource ImmutableDataSource}.
     * @return An immutable instance of DataSource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDataSource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDataSource(name, dataSourceReference, connectionProperties);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build DataSource, some of required attributes are not set " + attributes;
    }
  }
}
