package zeenea.connector.sqlserver.services.ssrs.client.xml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link DataSet}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDataSet.builder()}.
 */
@Generated(from = "DataSet", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDataSet implements DataSet {
  private final @Nullable String name;
  private final @Nullable Query query;
  private final @Nullable SharedDataSet sharedDataSet;
  private final List<Field> fields;
  private final @Nullable List<Filter> filters;

  private ImmutableDataSet(
      @Nullable String name,
      @Nullable Query query,
      @Nullable SharedDataSet sharedDataSet,
      List<Field> fields,
      @Nullable List<Filter> filters) {
    this.name = name;
    this.query = query;
    this.sharedDataSet = sharedDataSet;
    this.fields = fields;
    this.filters = filters;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JacksonXmlProperty(isAttribute = true, localName = "Name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code query} attribute
   */
  @JsonProperty("query")
  @JacksonXmlProperty(localName = "Query")
  @Override
  public @Nullable Query getQuery() {
    return query;
  }

  /**
   * @return The value of the {@code sharedDataSet} attribute
   */
  @JsonProperty("sharedDataSet")
  @JacksonXmlProperty(localName = "SharedDataSet")
  @Override
  public @Nullable SharedDataSet getSharedDataSet() {
    return sharedDataSet;
  }

  /**
   * @return The value of the {@code fields} attribute
   */
  @JsonProperty("fields")
  @JacksonXmlElementWrapper(localName = "Fields")
  @Override
  public List<Field> getFields() {
    return fields;
  }

  /**
   * @return The value of the {@code filters} attribute
   */
  @JsonProperty("filters")
  @JacksonXmlElementWrapper(localName = "Filters")
  @Override
  public @Nullable List<Filter> getFilters() {
    return filters;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSet#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSet withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableDataSet(value, this.query, this.sharedDataSet, this.fields, this.filters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSet#getQuery() query} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for query (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSet withQuery(@Nullable Query value) {
    if (this.query == value) return this;
    return new ImmutableDataSet(this.name, value, this.sharedDataSet, this.fields, this.filters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSet#getSharedDataSet() sharedDataSet} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sharedDataSet (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSet withSharedDataSet(@Nullable SharedDataSet value) {
    if (this.sharedDataSet == value) return this;
    return new ImmutableDataSet(this.name, this.query, value, this.fields, this.filters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataSet#getFields() fields}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataSet withFields(Field... elements) {
    List<Field> newValue = List.of(elements);
    return new ImmutableDataSet(this.name, this.query, this.sharedDataSet, newValue, this.filters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataSet#getFields() fields}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fields elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataSet withFields(Iterable<? extends Field> elements) {
    if (this.fields == elements) return this;
    List<Field> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Field>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDataSet(this.name, this.query, this.sharedDataSet, newValue, this.filters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataSet#getFilters() filters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataSet withFilters(@Nullable Filter... elements) {
    if (elements == null) {
      return new ImmutableDataSet(this.name, this.query, this.sharedDataSet, this.fields, null);
    }
    List<Filter> newValue = List.of(elements);
    return new ImmutableDataSet(this.name, this.query, this.sharedDataSet, this.fields, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataSet#getFilters() filters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of filters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataSet withFilters(@Nullable Iterable<? extends Filter> elements) {
    if (this.filters == elements) return this;
    @Nullable List<Filter> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Filter>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDataSet(this.name, this.query, this.sharedDataSet, this.fields, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDataSet} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDataSet
        && equalTo(0, (ImmutableDataSet) another);
  }

  private boolean equalTo(int synthetic, ImmutableDataSet another) {
    return Objects.equals(name, another.name)
        && Objects.equals(query, another.query)
        && Objects.equals(sharedDataSet, another.sharedDataSet)
        && fields.equals(another.fields)
        && Objects.equals(filters, another.filters);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code query}, {@code sharedDataSet}, {@code fields}, {@code filters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(query);
    h += (h << 5) + Objects.hashCode(sharedDataSet);
    h += (h << 5) + fields.hashCode();
    h += (h << 5) + Objects.hashCode(filters);
    return h;
  }

  /**
   * Prints the immutable value {@code DataSet} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DataSet{"
        + "name=" + name
        + ", query=" + query
        + ", sharedDataSet=" + sharedDataSet
        + ", fields=" + fields
        + ", filters=" + filters
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DataSet} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DataSet instance
   */
  public static ImmutableDataSet copyOf(DataSet instance) {
    if (instance instanceof ImmutableDataSet) {
      return (ImmutableDataSet) instance;
    }
    return ImmutableDataSet.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDataSet ImmutableDataSet}.
   * <pre>
   * ImmutableDataSet.builder()
   *    .name(String | null) // nullable {@link DataSet#getName() name}
   *    .query(zeenea.connector.sqlserver.services.ssrs.client.xml.Query | null) // nullable {@link DataSet#getQuery() query}
   *    .sharedDataSet(zeenea.connector.sqlserver.services.ssrs.client.xml.SharedDataSet | null) // nullable {@link DataSet#getSharedDataSet() sharedDataSet}
   *    .addFields|addAllFields(zeenea.connector.sqlserver.services.ssrs.client.xml.Field) // {@link DataSet#getFields() fields} elements
   *    .filters(List&amp;lt;zeenea.connector.sqlserver.services.ssrs.client.xml.Filter&amp;gt; | null) // nullable {@link DataSet#getFilters() filters}
   *    .build();
   * </pre>
   * @return A new ImmutableDataSet builder
   */
  public static ImmutableDataSet.Builder builder() {
    return new ImmutableDataSet.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDataSet ImmutableDataSet}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DataSet", generator = "Immutables")
  public static final class Builder {
    private String name;
    private Query query;
    private SharedDataSet sharedDataSet;
    private List<Field> fields = new ArrayList<Field>();
    private List<Filter> filters = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DataSet} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DataSet instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable Query queryValue = instance.getQuery();
      if (queryValue != null) {
        query(queryValue);
      }
      @Nullable SharedDataSet sharedDataSetValue = instance.getSharedDataSet();
      if (sharedDataSetValue != null) {
        sharedDataSet(sharedDataSetValue);
      }
      addAllFields(instance.getFields());
      @Nullable List<Filter> filtersValue = instance.getFilters();
      if (filtersValue != null) {
        addAllFilters(filtersValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DataSet#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    @JacksonXmlProperty(isAttribute = true, localName = "Name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link DataSet#getQuery() query} attribute.
     * @param query The value for query (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("query")
    @JacksonXmlProperty(localName = "Query")
    public final Builder query(@Nullable Query query) {
      this.query = query;
      return this;
    }

    /**
     * Initializes the value for the {@link DataSet#getSharedDataSet() sharedDataSet} attribute.
     * @param sharedDataSet The value for sharedDataSet (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("sharedDataSet")
    @JacksonXmlProperty(localName = "SharedDataSet")
    public final Builder sharedDataSet(@Nullable SharedDataSet sharedDataSet) {
      this.sharedDataSet = sharedDataSet;
      return this;
    }

    /**
     * Adds one element to {@link DataSet#getFields() fields} list.
     * @param element A fields element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFields(Field element) {
      this.fields.add(Objects.requireNonNull(element, "fields element"));
      return this;
    }

    /**
     * Adds elements to {@link DataSet#getFields() fields} list.
     * @param elements An array of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFields(Field... elements) {
      for (Field element : elements) {
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DataSet#getFields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("fields")
    @JacksonXmlElementWrapper(localName = "Fields")
    public final Builder fields(Iterable<? extends Field> elements) {
      this.fields.clear();
      return addAllFields(elements);
    }

    /**
     * Adds elements to {@link DataSet#getFields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllFields(Iterable<? extends Field> elements) {
      for (Field element : elements) {
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link DataSet#getFilters() filters} list.
     * @param element A filters element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFilters(Filter element) {
      if (this.filters == null) {
        this.filters = new ArrayList<Filter>();
      }
      this.filters.add(Objects.requireNonNull(element, "filters element"));
      return this;
    }

    /**
     * Adds elements to {@link DataSet#getFilters() filters} list.
     * @param elements An array of filters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFilters(Filter... elements) {
      if (this.filters == null) {
        this.filters = new ArrayList<Filter>();
      }
      for (Filter element : elements) {
        this.filters.add(Objects.requireNonNull(element, "filters element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DataSet#getFilters() filters} list.
     * @param elements An iterable of filters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("filters")
    @JacksonXmlElementWrapper(localName = "Filters")
    public final Builder filters(@Nullable Iterable<? extends Filter> elements) {
      if (elements == null) {
        this.filters = null;
        return this;
      }
      this.filters = new ArrayList<Filter>();
      return addAllFilters(elements);
    }

    /**
     * Adds elements to {@link DataSet#getFilters() filters} list.
     * @param elements An iterable of filters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllFilters(Iterable<? extends Filter> elements) {
      Objects.requireNonNull(elements, "filters element");
      if (this.filters == null) {
        this.filters = new ArrayList<Filter>();
      }
      for (Filter element : elements) {
        this.filters.add(Objects.requireNonNull(element, "filters element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDataSet ImmutableDataSet}.
     * @return An immutable instance of DataSet
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDataSet build() {
      return new ImmutableDataSet(
          name,
          query,
          sharedDataSet,
          List.copyOf(fields),
          filters == null ? null : List.copyOf(filters));
    }
  }
}
