package zeenea.connector.sqlserver.services.ssrs.client.xml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link ConnectionProperties}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConnectionProperties.builder()}.
 */
@Generated(from = "ConnectionProperties", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableConnectionProperties
    implements ConnectionProperties {
  private final @Nullable String extension;
  private final @Nullable String dataProvider;
  private final String connectString;

  private ImmutableConnectionProperties(
      @Nullable String extension,
      @Nullable String dataProvider,
      String connectString) {
    this.extension = extension;
    this.dataProvider = dataProvider;
    this.connectString = connectString;
  }

  /**
   * @return The value of the {@code extension} attribute
   */
  @JsonProperty("extension")
  @JacksonXmlProperty(localName = "Extension")
  @Override
  public @Nullable String getExtension() {
    return extension;
  }

  /**
   * @return The value of the {@code dataProvider} attribute
   */
  @JsonProperty("dataProvider")
  @JacksonXmlProperty(localName = "DataProvider")
  @Override
  public @Nullable String getDataProvider() {
    return dataProvider;
  }

  /**
   * @return The value of the {@code connectString} attribute
   */
  @JsonProperty("connectString")
  @JacksonXmlProperty(localName = "ConnectString")
  @Override
  public String getConnectString() {
    return connectString;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConnectionProperties#getExtension() extension} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for extension (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnectionProperties withExtension(@Nullable String value) {
    if (Objects.equals(this.extension, value)) return this;
    return new ImmutableConnectionProperties(value, this.dataProvider, this.connectString);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConnectionProperties#getDataProvider() dataProvider} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dataProvider (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnectionProperties withDataProvider(@Nullable String value) {
    if (Objects.equals(this.dataProvider, value)) return this;
    return new ImmutableConnectionProperties(this.extension, value, this.connectString);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConnectionProperties#getConnectString() connectString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectString
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnectionProperties withConnectString(String value) {
    String newValue = Objects.requireNonNull(value, "connectString");
    if (this.connectString.equals(newValue)) return this;
    return new ImmutableConnectionProperties(this.extension, this.dataProvider, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConnectionProperties} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConnectionProperties
        && equalTo(0, (ImmutableConnectionProperties) another);
  }

  private boolean equalTo(int synthetic, ImmutableConnectionProperties another) {
    return Objects.equals(extension, another.extension)
        && Objects.equals(dataProvider, another.dataProvider)
        && connectString.equals(another.connectString);
  }

  /**
   * Computes a hash code from attributes: {@code extension}, {@code dataProvider}, {@code connectString}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(extension);
    h += (h << 5) + Objects.hashCode(dataProvider);
    h += (h << 5) + connectString.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConnectionProperties} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ConnectionProperties{"
        + "extension=" + extension
        + ", dataProvider=" + dataProvider
        + ", connectString=" + connectString
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ConnectionProperties} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConnectionProperties instance
   */
  public static ImmutableConnectionProperties copyOf(ConnectionProperties instance) {
    if (instance instanceof ImmutableConnectionProperties) {
      return (ImmutableConnectionProperties) instance;
    }
    return ImmutableConnectionProperties.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConnectionProperties ImmutableConnectionProperties}.
   * <pre>
   * ImmutableConnectionProperties.builder()
   *    .extension(String | null) // nullable {@link ConnectionProperties#getExtension() extension}
   *    .dataProvider(String | null) // nullable {@link ConnectionProperties#getDataProvider() dataProvider}
   *    .connectString(String) // required {@link ConnectionProperties#getConnectString() connectString}
   *    .build();
   * </pre>
   * @return A new ImmutableConnectionProperties builder
   */
  public static ImmutableConnectionProperties.Builder builder() {
    return new ImmutableConnectionProperties.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConnectionProperties ImmutableConnectionProperties}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ConnectionProperties", generator = "Immutables")
  @JacksonXmlRootElement(localName = "ConnectionProperties")
  public static final class Builder {
    private static final long INIT_BIT_CONNECT_STRING = 0x1L;
    private long initBits = 0x1L;

    private String extension;
    private String dataProvider;
    private String connectString;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConnectionProperties} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConnectionProperties instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String extensionValue = instance.getExtension();
      if (extensionValue != null) {
        extension(extensionValue);
      }
      @Nullable String dataProviderValue = instance.getDataProvider();
      if (dataProviderValue != null) {
        dataProvider(dataProviderValue);
      }
      this.connectString(instance.getConnectString());
      return this;
    }

    /**
     * Initializes the value for the {@link ConnectionProperties#getExtension() extension} attribute.
     * @param extension The value for extension (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("extension")
    @JacksonXmlProperty(localName = "Extension")
    public final Builder extension(@Nullable String extension) {
      this.extension = extension;
      return this;
    }

    /**
     * Initializes the value for the {@link ConnectionProperties#getDataProvider() dataProvider} attribute.
     * @param dataProvider The value for dataProvider (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dataProvider")
    @JacksonXmlProperty(localName = "DataProvider")
    public final Builder dataProvider(@Nullable String dataProvider) {
      this.dataProvider = dataProvider;
      return this;
    }

    /**
     * Initializes the value for the {@link ConnectionProperties#getConnectString() connectString} attribute.
     * @param connectString The value for connectString 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("connectString")
    @JacksonXmlProperty(localName = "ConnectString")
    public final Builder connectString(String connectString) {
      this.connectString = Objects.requireNonNull(connectString, "connectString");
      initBits &= ~INIT_BIT_CONNECT_STRING;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConnectionProperties ImmutableConnectionProperties}.
     * @return An immutable instance of ConnectionProperties
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConnectionProperties build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConnectionProperties(extension, dataProvider, connectString);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONNECT_STRING) != 0) attributes.add("connectString");
      return "Cannot build ConnectionProperties, some of required attributes are not set " + attributes;
    }
  }
}
